<?php
namespace LACI_InternalLinks\Utils;

/**
 *
 * @method static Helpers get_instance()
 */
class Helpers {

    public static function wp_kses_allowed_html( $cus_attr_tags = [] ) {
        $allowed_html_tags = wp_kses_allowed_html( 'post' );

        $allowed_html_tags['style'] = true;

        $allowed_html_tags['select'] = [
            'id'       => true,
            'class'    => true,
            'name'     => true,
            'style'    => true,
            'multiple' => true,
            'data-id'  => true,
        ];

        $allowed_html_tags['option'] = [
            'value'    => true,
            'selected' => true,
            'style'    => true,
            'class'    => true,
            'data-id'  => true,
        ];

        $allowed_html_tags['script'] = true;

        $allowed_html_attr = $cus_attr_tags;

        return array_map(
            function ( $item ) use ( $allowed_html_attr ) {
                return is_array( $item ) ? array_merge( $item, $allowed_html_attr ) : $item;
            },
            $allowed_html_tags
        );
    }
    /**
     * Count the occurrences of a keyword in a text, ignoring keywords within href attributes.
     *
     * @param string $content The content to search within.
     * @param string $key_word The keyword to count.
     * @return int The number of occurrences of the keyword.
     */
    public static function count_keyword_occurrences( $content, $key_word ) {
        // Normalize the keyword and content to lowercase for case-insensitive matching
        $normalized_key_word = strtolower( $key_word );
        $normalized_content  = strtolower( $content );

        // Find and clean keywords inside href attributes
        $cleaned_content = preg_replace_callback(
            '/<a\b[^>]*href=[\'"]([^\'"]+)[\'"][^>]*>.*?<\/a>/i',
            function ( $matches ) use ( $normalized_key_word ) {
                $href = $matches[1];
                // Remove the keyword from the href value
                $cleaned_href = str_ireplace( $normalized_key_word, '', $href );
                return str_replace( $href, $cleaned_href, $matches[0] );
            },
            $normalized_content
        );

        // Count the occurrences of the keyword in the cleaned content
        $count = 0;
        preg_match_all( '/' . preg_quote( $normalized_key_word, '/' ) . '/', $cleaned_content, $matches, PREG_OFFSET_CAPTURE );

        foreach ( $matches[0] as $match ) {
            $start_pos = $match[1];
            $end_pos   = $start_pos + strlen( $match[0] );

            // Check if the keyword is inside an <a> tag
            $is_inside_href = false;
            if ( preg_match_all( '/<a\b[^>]*href=[\'"]([^\'"]+)[\'"][^>]*>.*?<\/a>/i', $content, $link_matches, PREG_OFFSET_CAPTURE ) ) {
                foreach ( $link_matches[0] as $link ) {
                    $href_start_pos = $link[1];
                    $href_end_pos   = $href_start_pos + strlen( $link[0] );

                    if ( $start_pos >= $href_start_pos && $end_pos <= $href_end_pos ) {
                        $is_inside_href = true;
                        break;
                    }
                }
            }

            if ( ! $is_inside_href ) {
                ++$count;
            }
        }

        return $count;
    }
}
