<?php
namespace LACI_InternalLinks;

defined( 'ABSPATH' ) || exit;

/**
 * Class I18n
 *
 * Handles the internationalization functionality of the plugin.
 */
class I18n {

    /**
     * Load the plugin text domain for translation.
     */
    public static function load_plugin_textdomain() {
        if ( function_exists( 'determine_locale' ) ) {
            $locale = determine_locale();
        } else {
            $locale = is_admin() ? get_user_locale() : get_locale();
        }

        unload_textdomain( 'laci-link-cluster' );
        load_textdomain( 'laci-link-cluster', LACI_INTERNAL_LINKS_PLUGIN_PATH . '/languages/i18n/laci-link-cluster-' . $locale . '.mo' );

        load_plugin_textdomain(
            'laci-link-cluster',
            false,
            LACI_INTERNAL_LINKS_PLUGIN_URL . 'languages/i18n/'
        );
    }
}
