<?php
use LACI_InternalLinks\Utils\Helpers;

if ( ! function_exists( 'laci_kses_post' ) ) {
    /**
     * The function laci_kses_post sanitizes HTML content using the allowed HTML tags defined in the
     * Helpers class.
     *
     * @param html The  parameter is the input string that you want to sanitize and allow only
     * certain HTML tags and attributes.
     *
     * @return the result of the wp_kses() function, which is the sanitized version of the
     * parameter using the  array as the allowed HTML tags and attributes.
     */
    function laci_kses_post( $html ) {
        $allowed_html = Helpers::wp_kses_allowed_html();
        return wp_kses( $html, $allowed_html );
    }
}


if ( ! function_exists( 'laci_kses_post_e' ) ) {
    /**
     * The function `laci_kses_post_e` echoes the HTML content after sanitizing it using the allowed
     * HTML tags defined in the `Helpers::wp_kses_allowed_html()` method.
     *
     * @param html The  parameter is the content that you want to sanitize and filter using the
     * wp_kses() function. It could be any HTML content that you want to ensure is safe and free from
     * any potentially harmful or malicious code.
     */
    function laci_kses_post_e( $html ) {
        $allowed_html = Helpers::wp_kses_allowed_html();
        echo wp_kses( $html, $allowed_html );
    }
}

if ( ! function_exists( 'laci_delete_shortcode' ) ) {
    /**
     * The function `laci_delete_shortcode` removes the shortcode from the post content.
     *
     */
    function laci_delete_shortcode( $shortcode_name = 'laci_related_post_content', $post_id = null ) {
        global $wpdb;

        $pattern = '<!-- wp:shortcode -->\s*\[' . preg_quote( $shortcode_name, '/' ) . '[^\]]*\]\s*<!-- \/wp:shortcode -->';

        if ( $post_id ) {
            $result = $wpdb->query(
                $wpdb->prepare(
                    "UPDATE {$wpdb->posts} SET post_content = REGEXP_REPLACE(post_content, %s, '') WHERE ID = %d",
                    $pattern,
                    $post_id
                )
            );
        } else {
            $result = $wpdb->query(
                $wpdb->prepare(
                    "UPDATE {$wpdb->posts} SET post_content = REGEXP_REPLACE(post_content, %s, '') WHERE post_status IN ('publish', 'draft', 'pending')",
                    $pattern
                )
            );
        }

        return $result;
    }
}
