<?php
namespace LACI_InternalLinks\Controllers;

use LACI_InternalLinks\Utils\SingletonTrait;

/**
 * @method static PostLinkManagerController get_instance()
 */
class PostLinkManagerController {
    use SingletonTrait;

    protected function __construct() {
        // Add columns for posts
        add_filter( 'manage_posts_columns', [ $this, 'add_custom_columns' ] );
        add_action( 'manage_posts_custom_column', [ $this, 'custom_column_content' ], 10, 2 );

        // Add columns for pages
        add_filter( 'manage_pages_columns', [ $this, 'add_custom_columns' ] );
        add_action( 'manage_pages_custom_column', [ $this, 'custom_column_content' ], 10, 2 );
    }

    public function custom_column_content( $column_name, $post_id ) {
        if ( $column_name === 'laci_internal_links' ) {
            $inbound_links     = count( WPILCustomTableManager::get_meta_value( $post_id, 'inbound_links' ) );
            $outbound_links    = count( WPILCustomTableManager::get_meta_value( $post_id, 'outbound_links' ) );
            $key_words         = get_post_meta( $post_id, 'laci_list_key_word', true );
            $key_words_implode = is_array( $key_words ) ? implode( ',', $key_words ) : '';
            $link_assistant    = admin_url( 'admin.php?page=laci-internal-links-assistant' ) . '&post_id=' . $post_id . '&key_word=' . $key_words_implode;

            ob_start();
            include LACI_INTERNAL_LINKS_PLUGIN_PATH . 'templates/manage-posts/column-content.php';
            $html = ob_get_contents();
            ob_end_clean();
            laci_kses_post_e( $html );
        }
    }

    public function add_custom_columns( $columns ) {
        $columns['laci_internal_links'] = __( 'Links Status', 'laci-link-cluster' );
        return $columns;
    }
}
