
const linkAssistant = {
    actionChangeKeyword($) {
        jQuery('.laci-key-words-change').on('input', function() {
            const value = jQuery(this).val();
            const options = value.split(',').map(item => item.trim());
            const select = jQuery('.laci-search-input-control');

            select.empty();

            const $defaultOption = jQuery('<option></option>')
                .attr('value', '')
                .text('Select a keyword');

            select.append($defaultOption);

            options.forEach(option => {
                const $option = jQuery('<option></option>')
                    .attr('value', option)
                    .text(option);
                select.append($option);
            });

            select.trigger('change');
        });
    },
    handleShowPopupEdit($){
        jQuery(document).on("click", ".laci-same-cat-content-edit", function (e) {
            e.preventDefault();

            const midSection = jQuery(this).closest('.laci-mid-section').addClass('laci-current-section-active');
            const title = midSection.find('.laci-name-post').data('title');

            const parent = jQuery(this).closest('.laci-post-content__excerpt');
            const currentExcerpt = parent.attr('data-current-excerpt');
            const content = parent.find('.laci-post-content__excerpt__content').html();
          
            const postID = jQuery(this).closest('.laci-container-same-cat-item').data('id');

            jQuery("#popup-editor").html(content);

            jQuery("#laci-current-data").html(content);
            jQuery("#laci-current-data").attr('data-id', postID);
            jQuery("#laci-current-data").attr('data-currentExcerpt', currentExcerpt);

            jQuery('.laci-internal-links-popup').dialog('open');
            jQuery('.laci-internal-links-popup').dialog('option', 'title', title);

            if (tinymce.get('popup-editor')) {
                setTimeout(function() {
                    tinymce.get('popup-editor').setContent(content);
                }, 10);
            }
        });

        jQuery(document).on("click", ".laci-diff-cat-content-edit", function (e) {
            e.preventDefault();

            const midSection = jQuery(this).closest('.laci-mid-section').addClass('laci-current-section-active');
            const title = midSection.find('.laci-name-post').data('title');

            const parent = jQuery(this).closest('.laci-post-content__excerpt');
            const currentExcerpt = parent.attr('data-current-excerpt');
            const content = parent.find('.laci-post-content__excerpt__content').html();

            const postID = jQuery(this).closest('.laci-container-diff-cat-item').data('id');

            jQuery("#popup-editor").html(content);

            jQuery("#laci-current-data").html(content);
            jQuery("#laci-current-data").attr('data-id', postID);
            jQuery("#laci-current-data").attr('data-currentExcerpt', currentExcerpt);

            jQuery('.laci-internal-links-popup').dialog('open');
            jQuery('.laci-internal-links-popup').dialog('option', 'title', title);

            if (tinymce.get('popup-editor')) {
                setTimeout(function() {
                    tinymce.get('popup-editor').setContent(content);
                }, 10);
            }
        });
        
    },
    createdPopup($) {
        const dialogHeight = $(window).height()* 80/100;
        $('.laci-internal-links-popup').dialog({
            autoOpen: false,
            title: 'Title',
            width: '60%',
            height: dialogHeight,
            modal: true,
            buttons: {
                Close: function() {
                    $(this).dialog("close");
                    jQuery('.laci-mid-section').removeClass('laci-current-section-active');
                },
                Save: function() {
                    HandelSaveContent();
                },
                "Save & Close": function() {
                    HandelSaveContent();
                    jQuery('.laci-mid-section').removeClass('laci-current-section-active');
                    $(this).dialog("close");
                }

            },
            close: function() { 
                jQuery('.laci-mid-section').removeClass('laci-current-section-active');
            }
        });

        function HandelSaveContent() {
            const midSection = jQuery('.laci-mid-section.laci-current-section-active');
            const postID =  jQuery("#laci-current-data").attr('data-id');
            const currentExcerpt = jQuery("#laci-current-data").attr('data-currentExcerpt');

            const contentBefore = midSection.find(`.laci-post-content__excerpt[data-num="${currentExcerpt}"] .laci-post-content__excerpt__content`).html();
            const contentAfter = tinymce.get('popup-editor').getContent().replace(/<p>(?:&nbsp;|\s)*<\/p>/g, '');
           
            jQuery.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_save_internal_links_for_post',
                    nonce: laci_internal_links.nonce,
                    content_after: contentAfter,
                    content_before: contentBefore,
                    post_id: postID

                },
                success: function(response) {
                    if (response.success === true) {
                        midSection.find(`.laci-post-content__excerpt[data-num="${currentExcerpt}"] .laci-post-content__excerpt__content`).html(contentAfter)
                        notification.showNotification('Key words updated');
                    } else {
                        console.log(response);
                        notification.showNotification('Key words can\'t be updated');
                    }
                },
                error: function(response) {
                    console.log(response);
                    notification.showNotification('Key words can\'t be updated');
                }
            });
        }
    },
    handleSearchKeyWordSameCate($) {
        function Search() {
            const keyWord = jQuery('.laci-search-input-control').val();
            const postId = jQuery('.laci-search-input-control').data('id');
            $('.laci-search-button').addClass('laci-updating-message');
            $('.laci-search-button').attr('disabled', 'disabled');
        
            jQuery.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_search_keyword_same_cate',
                    nonce: laci_internal_links.nonce,
                    key_word: keyWord,
                    post_id: postId,
                },
                success: function(response) {
                    $('.laci-search-button').removeClass('laci-updating-message');
                    $('.laci-search-button').removeAttr('disabled', 'disabled');
                    if (response.success && response.data) {
                        jQuery('.laci-search-results__same-category__content').html(response.data.html_same_cate);
                        jQuery('.laci-load-more-same-category').attr('data-max-pages', response.data.max_pages_same_cate);
                        jQuery('.laci-load-more-same-category').attr('data-post-id', postId);
                        jQuery('.laci-load-more-same-category').attr('data-key-word', keyWord);
                        jQuery('.laci-load-more-same-category').attr('data-set-paging', 1);


                        jQuery('.laci-search-results__diff-category__content').html(response.data.html_diff_cate);
                        jQuery('.laci-load-more-diff-category').attr('data-max-pages', response.data.max_pages_diff_cate);
                        jQuery('.laci-load-more-diff-category').attr('data-post-id', postId);
                        jQuery('.laci-load-more-diff-category').attr('data-key-word', keyWord);
                        jQuery('.laci-load-more-diff-category').attr('data-set-paging', 1);


                        if (+response.data.max_pages_same_cate > 1) {
                            jQuery('.laci-search-results__same-category__load-more').removeClass('laci-display-none');
                        } else {
                            jQuery('.laci-search-results__same-category__load-more').addClass('laci-display-none');
                        }

                        if (+response.data.max_pages_diff_cate > 1) {
                            jQuery('.laci-search-results__diff-category__load-more').removeClass('laci-display-none');
                        } else {
                            jQuery('.laci-search-results__diff-category__load-more').addClass('laci-display-none');
                        }

                        const currentURL = response.data.current_url;
                        window.history.replaceState(null, '', currentURL);

                        if(response.data.same_cate_error) {
                            jQuery('.laci-search-results__same-category__content').html(`<p class="laci-text-not-info">${response.data.same_cate_error}</p>`);
                        }

                        if(response.data.diff_cate_error) {
                            jQuery('.laci-search-results__diff-category__content').html(`<p class="laci-text-not-info">${response.data.diff_cate_error}</p>`);
                        }

                        notification.showNotification('Search completed');
                    } else {
                        jQuery('.laci-search-results__same-category__load-more').addClass('laci-display-none');
                        jQuery('.laci-load-more-same-category').attr('data-set-paging', 1);
                        jQuery('.laci-search-results__same-category__content').html(`<p class="laci-text-not-info">${response.data.same_cate_error}</p>`);

                        jQuery('.laci-search-results__diff-category__load-more').addClass('laci-display-none');
                        jQuery('.laci-load-more-diff-category').attr('data-set-paging', 1);
                        jQuery('.laci-search-results__diff-category__content').html(`<p class="laci-text-not-info">${response.data.diff_cate_error}</p>`);
                        
                        const currentURL = response.data.current_url;
                        window.history.replaceState(null, '', currentURL);
                        notification.showNotification('Search completed');
                    }
                },
                error: function(response) {
                    $('.laci-search-button').removeClass('laci-updating-message');
                    $('.laci-search-button').removeAttr('disabled', 'disabled');
                    console.log(response);
                    notification.showNotification('Search failed', true);
                }
            });
        }

        jQuery('.laci-search-button').on('click', function() {
            Search();
        });

        $('.laci-search-input-control').on('keypress', function(e) {
            if (e.which === 13) { 
                Search();
            }
        });
    
    },
     actionNextAndPreviousContent($) {
        function updateButtons(midSection, currentExcerpt, totalExcerpts) {
            const totalKeyWord = midSection.find('.laci-text-highlight').length;

            const isDisabledPreviousBtn = currentExcerpt === 0 && midSection.find('.laci-text-highlight').eq(0).hasClass('active-highlight');

            const isDisabledNextBtn = currentExcerpt === totalExcerpts - 1 && midSection.find('.laci-text-highlight').eq(totalKeyWord - 1).hasClass('active-highlight');
        }

        function updateButtonsForDiff(midSection, currentExcerpt, totalExcerpts) {
            const totalKeyWord = midSection.find('.laci-text-highlight').length;

            const isDisabledPreviousBtn = currentExcerpt === 0 && midSection.find('.laci-text-highlight').eq(0).hasClass('active-highlight');

            const isDisabledNextBtn = currentExcerpt === totalExcerpts - 1 && midSection.find('.laci-text-highlight').eq(totalKeyWord - 1).hasClass('active-highlight');
        } 
    },    
    tinymceCustomButton($) {
        const postTitle = jQuery('.laci-placement-assistant-title').data('title');

        tinymce.create('tinymce.plugins.CustomButtonAddLink', {
            init: function(editor, url) {
                editor.addButton('custom_button_add_link', {
                    text: `⥅ Place a link to: ${postTitle}`,
                    classes: 'laci-custom-button-add-link',
                    icon: false,
                    onclick: function() {
                        var editor = tinymce.activeEditor;
                        var selectedText = editor.selection.getContent();

                        const postLinkElement = jQuery('.laci-placement-assistant-title');
                        if (!postLinkElement.length) {
                            alert('Error: Post link element not found.');
                            return;
                        }
                        
                        const postLink = postLinkElement.data('link');
                        if (!postLink) {
                            alert('Error: Post link is not available.');
                            return;
                        }

                        let contentChanged = false;

                        if (selectedText.length > 0) {
                            editor.execCommand('mceInsertLink', false, {
                                href: postLink,
                                text: selectedText,
                               'data-id' : postLinkElement.data('id'),
                               'data-type': 'post'
                            });
                            contentChanged = true;
                        } else {
                            alert("Please select a text before adding a link.");
                        }

                        if (contentChanged) {
                            tinymce.triggerSave();
                        } else {
                            alert('Error: None of the keywords were found in the content.');
                        }

                    }
                });
            }
        });
        
        tinymce.PluginManager.add('custom_button_add_link', tinymce.plugins.CustomButtonAddLink);
    },
    getUrlParameter(name) {
        name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
        var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
        var results = regex.exec(location.search);
        return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
    },
    triggerChangeKeyword($) {
        //let keyWord = linkAssistant.getUrlParameter('key_word');
        let keyWord = jQuery('.laci-placement-assistant-title').data('keywords');
        
        if(keyWord) {
            keyWord = keyWord.replace(/,+/g, ',');
            keyWord = keyWord.replace(/^,|,$/g, '');
            jQuery('.laci-search-input-control').val(keyWord).trigger('change');
        }
    },
    handleLoadMore($) {
        $('.laci-load-more-same-category').click(function() {
            let wpilCurrentPage = $(this).data('set-paging') || 1;
            const wpilMaxPages = $(this).data('max-pages');
            const postId = $(this).data('post-id');
            const keyWord = $(this).data('key-word');
            
            jQuery('.laci-loading').show();

            wpilCurrentPage++;
            $(this).attr('data-set-paging', wpilCurrentPage);
    
            if (wpilCurrentPage <= wpilMaxPages) {
                jQuery('.laci-loading').show();
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {
                        action: 'laci_load_more_post_same_cate',
                        nonce: laci_internal_links.nonce,
                        post_id: postId,
                        key_word: keyWord,
                        page: wpilCurrentPage,
                    },
                    success: function(response) {
                        jQuery('.laci-loading').hide();
                        if (response.success) {
                            $('.laci-search-results__same-category__content').append(response.data.html_same_cate);
                            if (wpilCurrentPage >= wpilMaxPages) {
                                jQuery('.laci-search-results__same-category__load-more').addClass('laci-display-none');
                            }
                        } else {
                            alert(response.data.mess);
                        }
                    }
                });
            } else {
                jQuery('.laci-search-results__same-category__load-more').addClass('laci-display-none');
            }
        });

        $('.laci-load-more-diff-category').click(function() {
            let wpilCurrentPage = $(this).data('set-paging') || 1;
            const wpilMaxPages = $(this).data('max-pages');
            const postId = $(this).data('post-id');
            const keyWord = $(this).data('key-word');
            
            jQuery('.laci-loading').show();

            wpilCurrentPage++;
            $(this).attr('data-set-paging', wpilCurrentPage);
    
            if (wpilCurrentPage <= wpilMaxPages) {
                jQuery('.laci-loading').show();
                $.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {
                        action: 'laci_load_more_post_diff_cate',
                        nonce: laci_internal_links.nonce,
                        post_id: postId,
                        key_word: keyWord,
                        page: wpilCurrentPage,
                    },
                    success: function(response) {
                        jQuery('.laci-loading').hide();
                        if (response.success) {
                            $('.laci-search-results__diff-category__content').append(response.data.html_diff_cate);
                            if (wpilCurrentPage >= wpilMaxPages) {
                                jQuery('.laci-search-results__diff-category__load-more').addClass('laci-display-none');
                            }
                        } else {
                            alert(response.data.mess);
                        }
                    }
                });
            } else {
                jQuery('.laci-search-results__diff-category__load-more').addClass('laci-display-none');
            }
        });
    },
    showPopupRelatedPost($) {
        function scrollToTarget() {
            const wrapContainer = $('.laci-add-related-box-popup');
            const target = wrapContainer.find('.laci-related-box-container');
        
            if (target.length) {
                wrapContainer.animate({
                    scrollTop: target.position().top + wrapContainer.scrollTop() - wrapContainer.position().top
                }, 500);
            } else {
                alert('Error: Target element not found.');
            }
        }

        jQuery(document).on("click", ".laci-add-related-box", function (e) {
            e.preventDefault();
            const postId = $(this).parents('.laci-container-cat-item').data('id');
            const relatedPostTitle = $('.laci-placement-assistant-title').data('title');
            const relatedPostId = $('.laci-placement-assistant-title').data('id');
            const keyword = $(this).parents('.laci-mid-section').find('.laci-text-highlight').text().trim();
            const location_keywork = $(this).parents('.laci-mid-section').find('.laci-text-highlight').data('occurrence');
            
            $(this).addClass('laci-updating-message');
            $(this).attr('disabled', 'disabled');

            jQuery.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_get_content_post',
                    nonce: laci_internal_links.nonce,
                    post_id: postId,
                    keyword: keyword,
                    location_keywork: location_keywork,
                    related_post_title: relatedPostTitle,
                    related_post_id: relatedPostId
                },
                success: function (response) {
                    if (response.success === true) {
                        $('.laci-add-related-box').removeClass('laci-updating-message');
                        $('.laci-add-related-box').removeAttr('disabled');
                        if (response.success && response.data.html) {
                            let $popup = $(".laci-add-related-box-popup");
                            if ($popup.length === 0) {
                                $popup = $('<div class="laci-add-related-box-popup"></div>').appendTo('body');
                            }
                            $popup.html(response.data.html);
    
                            const title = response.data.title;
                            const dialogHeight = $(window).height()* 80/100;
                            $popup.dialog({
                                title: title,
                                width: '60%',
                                height: dialogHeight,
                                modal: true,
                                buttons: {
                                    "Move Up Related Posts": function() {
                                        const div = $('.laci-add-related-box-popup .laci-related-box-container');

                                        const prevGroup = div.prevAll().first();

                                        const currentGroup = div.closest('.wp-block-group');
                                        
                                        if (prevGroup.length) {
                                            div.insertBefore(prevGroup);
                                        } else {
                                            // Otherwise, move it to the next wp-block-group
                                            const prevGroup = currentGroup.prevAll().first();
                                            if (prevGroup.length) {
                                                // Skip the first child of the next wp-block-group
                                                div.insertBefore(prevGroup);
                                            }
                                        }

                                        scrollToTarget();
                                    },
                                    "Move Down Related Posts": function() {
                                        const div = $('.laci-add-related-box-popup .laci-related-box-container');

                                        const nextGroup = div.nextAll().first();

                                        const currentGroup = div.closest('.wp-block-group');

                                        if (nextGroup.length) {
                                            div.insertAfter(nextGroup);
                                        } else {
                                            // Otherwise, move it to the next wp-block-group
                                            const nextGroup = currentGroup.nextAll().first();
                                            if (nextGroup.length) {
                                                // Skip the first child of the next wp-block-group
                                                div.insertAfter(nextGroup);
                                            }
                                        }
                                        scrollToTarget();
                                    },
                                    "Place Related Post": function() {
                                        const content = $('.laci-post-content-container').html();
                                        const relatedPostId = $('.laci-placement-assistant-title').data('id');
                                        jQuery.ajax({
                                            url: laci_internal_links.ajax_url,
                                            type: 'POST',
                                            data: {
                                                action: 'laci_save_related_post',
                                                nonce: laci_internal_links.nonce,
                                                post_id: postId,
                                                content: content,
                                                related_post_id: relatedPostId
                                            },
                                            success: function(response) {
                                                if (response.success && response.data) {
                                                   notification.showNotification('Related post added');
                                                } else {
                                                    notification.showNotification('Related post can\'t be added');
                                                }
                                            },
                                            error: function(response) {
                                                notification.showNotification('Related post can\'t be added');
                                            }
                                        });
                                        $(this).dialog("close");
                                        $(this).remove();
                                    },
                                    Close: function() {
                                        $(this).dialog("close");
                                        $(this).remove();
                                    },
                                },
                                open: function() {
                                    $(this).parent().addClass('laci-add-related-box-popup-container');
                                    $(this).parent().find('.ui-dialog-buttonpane button:contains("Move Up")').addClass('laci-move-up-button');
                                    $(this).parent().find('.ui-dialog-buttonpane button:contains("Move Down")').addClass('laci-move-down-button');
                                    $(this).parent().find('.ui-dialog-buttonpane button:contains("Close")').addClass('laci-close-button');
                                    $(this).parent().find('.ui-dialog-buttonpane button:contains("Place Related Post")').addClass('laci-place-post-button');
                                    
                                    setTimeout(function() {
                                        scrollToTarget();
                                    }, 500);
                                }
                            });
                        } else {
                            alert('Not have internal links information.');
                        }
                    }
                },
                error: function(response) {
                    $('.laci-add-related-box').removeClass('laci-updating-message');
                    $('.laci-add-related-box').removeAttr('disabled');
                    alert('Error: Failed to get content post.');
                }
            });

          
        });
    },
    insertMainKeywords($) {
        jQuery(document).on("click", ".laci-insert-main-key-word", function (e) {
            e.preventDefault();
            const postId = jQuery('.laci-placement-assistant-title').data('id');

            $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: {
                    action: 'laci_insert_main_keywords',
                    nonce: laci_internal_links.nonce,
                    post_id: postId,
                },
                success: function(response) {
                    jQuery('.laci-loading').hide();
                    if (response.success) {
                        jQuery('.laci-search-input-control').val(response.data.key_word).trigger('change');
                    } else {
                        alert(response.data.mess);
                    }
                }
            });
        
        });
    },
    addRelatedBox($){
        function deleteRelatedPost(postId) {
            jQuery.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_delete_related_post',
                    nonce: laci_internal_links.nonce,
                    post_id: postId,
                },
                success: function (response) {
                    if (response.success) {
                        console.log('Related post deleted');
                    } else {
                        console.log('Related post can\'t deleted');
                    }
                },
                error: function (response) {
                    console.log('Related post can\'t deleted');
                }
            });
        }

        jQuery(document).on("click", ".laci-add-related-box", function (e) {
            e.preventDefault();
            const postId = $(this).parents('.laci-container-cat-item').data('id');
            const relatedPostTitle = $('.laci-placement-assistant-title').data('title');
            const relatedPostId = $('.laci-placement-assistant-title').data('id');
            const keyword = $(this).parents('.laci-mid-section').find('.active-highlight').text().trim();
            const locationKeyword = $(this).parents('.laci-mid-section').find('.active-highlight').data('occurrence');
        
            $(this).addClass('laci-updating-message');
            $(this).attr('disabled', 'disabled');
        
            jQuery.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_add_related_box',
                    nonce: laci_internal_links.nonce,
                    post_id: postId,
                },
                success: function (response) {
                    $('.laci-add-related-box').removeClass('laci-updating-message');
                    $('.laci-add-related-box').removeAttr('disabled');
                    if (response.success) {
                        let $popup = $(".laci-add-related-box-popup");
                        if ($popup.length === 0) {
                            $popup = $(
                                `<div class="laci-add-related-box-popup">
                                    <div class="laci-pro-message"><a class="laci-pro-text" href="https://linkandcluster.com/" target="_blank"> Note: This is just a demo. To get it please buy our pro version<a></div>
                                    <iframe id="editPostIframe" src="" style="width:100%; height:100%; border:0;"></iframe>
                                </div>`
                            ).appendTo('body');
                        }
                        const editUrl = `/wp-admin/post.php?post=${postId}&action=edit&laci_action=added_related_post`;
                        $('#editPostIframe').attr('src', editUrl);
        
                        let iframeWindow;
                        let isContentChanged = false;
                        var isContentSaved = 0;
                        $('#editPostIframe').on('load', function () {
                            iframeWindow = this.contentWindow;
                            if (iframeWindow) {
                                const { subscribe, select } = iframeWindow.wp.data;
                                subscribe(() => {
                                    const isDirty = select('core/editor').isEditedPostDirty();
                                    const isSaving = select('core/editor').isSavingPost();
                                    isContentChanged = isDirty;
        
                                    if (isSaving) {
                                        isContentSaved += 1;
                                    }
                                });
                            }
                        });
        
                        const dialogHeight = $(window).height() * 80 / 100;
        
                        $popup.dialog({
                            title: relatedPostTitle,
                            width: '60%',
                            height: dialogHeight,
                            modal: true,
                            zIndex: '999999',
                            classes: {
                                "ui-dialog": "laci-custom-dialog"
                            },
                            close: function () {
                                $(".laci-add-related-box-popup").remove();
                            }
                        });
                    } else {
                        alert('Not have internal links information.');
                    }
                },
                error: function () {
                    $('.laci-add-related-box').removeClass('laci-updating-message');
                    $('.laci-add-related-box').removeAttr('disabled');
                    alert('Error: Failed to get content post.');
                }
            });
        });
    }
}

jQuery(document).ready(function($) {
    linkAssistant.actionChangeKeyword($);
    linkAssistant.createdPopup($);
    linkAssistant.handleShowPopupEdit($);
    linkAssistant.handleSearchKeyWordSameCate($);
    linkAssistant.actionNextAndPreviousContent($);
    linkAssistant.tinymceCustomButton($);
    linkAssistant.triggerChangeKeyword($);
    linkAssistant.handleLoadMore($);
    //linkAssistant.showPopupRelatedPost($);
    linkAssistant.insertMainKeywords($);
    linkAssistant.addRelatedBox($);
});