const externalLinks = {
    handlePopupDetailPosts($) {
        jQuery(document).on("click", ".laci-posts-cell", function (e) {
            e.preventDefault();
            console.log('click');
            const domain = $(this).data('domain');

            $.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_get_domain_posts',
                    domain: domain,
                    nonce: laci_internal_links.nonce
                },
                success: function(response) {
                    if (response.success) {
                        console.log(response);
                        const $popup = $('<div class="laci-internal-links-popup"></div>').html(response.data.html);
                        const title = response.data.title;
                        const dialogHeight = $(window).height()* 80/100;

                        $popup.dialog({
                            title: title,
                            width: '60%',
                            height: dialogHeight,
                            modal: true,
                            buttons: {
                                Close: function() {
                                    $(this).dialog("close");
                                    $(this).remove();
                                }
                            },
                            close: function() { 
                                $(this).remove();
                            }
                        });

                    }
                }
            });
        });
    },
    handlePopupDetailLinks($) {
        jQuery(document).on("click", ".laci-total-links-cell", function (e) {
            e.preventDefault();
            const domain = $(this).data('domain');

            $.ajax({
                url: laci_internal_links.ajax_url,
                type: 'POST',
                data: {
                    action: 'laci_get_total_links',
                    domain: domain,
                    nonce: laci_internal_links.nonce
                },
                success: function(response) {
                    if (response.success) {
                        const $popup = $('<div class="laci-internal-links-popup"></div>').html(response.data.html);
                        const title = response.data.title;
                        const dialogHeight = $(window).height()* 80/100;
                        $popup.dialog({
                            title: title,
                            width: '60%',
                            height: dialogHeight,
                            modal: true,
                            buttons: {
                                Close: function() {
                                    $(this).dialog("close");
                                    $(this).remove();
                                }
                            },
                            close: function() { 
                                $(this).remove();
                            }
                        });

                    }
                }
            });
        });
    }
};


jQuery(document).ready(function($) {
    externalLinks.handlePopupDetailPosts($);
    externalLinks.handlePopupDetailLinks($);
}); 