<?php
/*
Plugin Name: Kotivon Call to Action
Plugin URI: https://kotivon.com/kotivon-call-to-action/
Description: Professional floating WhatsApp and Phone CTA buttons with modern design.
Version: 1.2.8
Author: Kotivon
Author URI: https://kotivon.com
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: kotivon-call-to-action
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Admin Menü
add_action('admin_menu', function() {
    add_options_page('Kotivon CTA', 'Kotivon CTA', 'manage_options', 'kotivon-cta', 'kotivon_cta_settings_page');
});

// Ayar Sayfası
function kotivon_cta_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Kotivon Call to Action Settings', 'kotivon-call-to-action'); ?></h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('kotivon_cta_options_group');
            do_settings_sections('kotivon-cta');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('WhatsApp Number (e.g. 905xxxxxxxxx)', 'kotivon-call-to-action'); ?></th>
                    <td><input type="text" name="kotivon_cta_whatsapp" value="<?php echo esc_attr(get_option('kotivon_cta_whatsapp')); ?>" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('Phone Number (e.g. +905xxxxxxxxx)', 'kotivon-call-to-action'); ?></th>
                    <td><input type="text" name="kotivon_cta_phone" value="<?php echo esc_attr(get_option('kotivon_cta_phone')); ?>" /></td>
                </tr>
            </table>
            
            <h2><?php esc_html_e('Color Customization', 'kotivon-call-to-action'); ?></h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('WhatsApp Button Color', 'kotivon-call-to-action'); ?></th>
                    <td>
                        <input type="color" name="kotivon_cta_whatsapp_color" value="<?php echo esc_attr(get_option('kotivon_cta_whatsapp_color', '#25D366')); ?>" />
                        <p class="description"><?php esc_html_e('Default: #25D366 (WhatsApp Green)', 'kotivon-call-to-action'); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('Phone Button Color', 'kotivon-call-to-action'); ?></th>
                    <td>
                        <input type="color" name="kotivon_cta_phone_color" value="<?php echo esc_attr(get_option('kotivon_cta_phone_color', '#007cba')); ?>" />
                        <p class="description"><?php esc_html_e('Default: #007cba (Blue)', 'kotivon-call-to-action'); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('Toggle Button Color', 'kotivon-call-to-action'); ?></th>
                    <td>
                        <input type="color" name="kotivon_cta_toggle_color" value="<?php echo esc_attr(get_option('kotivon_cta_toggle_color', '#000000')); ?>" />
                        <p class="description"><?php esc_html_e('Default: #000000 (Black)', 'kotivon-call-to-action'); ?></p>
                    </td>
                </tr>
            </table>
            
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Ayar Kayıtları
add_action('admin_init', function() {
    register_setting('kotivon_cta_options_group', 'kotivon_cta_whatsapp', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('kotivon_cta_options_group', 'kotivon_cta_phone', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('kotivon_cta_options_group', 'kotivon_cta_whatsapp_color', ['sanitize_callback' => 'sanitize_hex_color']);
    register_setting('kotivon_cta_options_group', 'kotivon_cta_phone_color', ['sanitize_callback' => 'sanitize_hex_color']);
    register_setting('kotivon_cta_options_group', 'kotivon_cta_toggle_color', ['sanitize_callback' => 'sanitize_hex_color']);
});

// Sürüm sabiti
define('KOTIVON_CTA_VERSION', '1.2.8');

// Footer'da butonları ve stilleri göster
add_action('wp_footer', function() {
    $whatsapp = get_option('kotivon_cta_whatsapp');
    $phone = get_option('kotivon_cta_phone');
    
    // En az bir numara varsa göster
    if (!$whatsapp && !$phone) {
        return;
    }
    
    // Renk ayarları
    $whatsapp_color = get_option('kotivon_cta_whatsapp_color', '#25D366');
    $phone_color = get_option('kotivon_cta_phone_color', '#007cba');
    $toggle_color = get_option('kotivon_cta_toggle_color', '#000000');
    
    // Hover renkleri için biraz daha koyu ton
    $toggle_hover_color = kotivon_darken_color($toggle_color, 20);
    ?>
    
    <style>
    #kotivon-cta-wrapper {
        position: fixed !important;
        bottom: 20px !important;
        right: 20px !important;
        z-index: 99999 !important;
        font-family: Arial, sans-serif !important;
    }

    #kotivon-cta-buttons {
        display: none !important;
        flex-direction: column !important;
        gap: 10px !important;
        margin-bottom: 15px !important;
    }

    #kotivon-cta-buttons.show {
        display: flex !important;
        animation: kotivon-slide-up 0.3s ease !important;
    }

    @keyframes kotivon-slide-up {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .kotivon-cta-btn {
        width: 55px !important;
        height: 55px !important;
        border-radius: 50% !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-decoration: none !important;
        color: white !important;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2) !important;
        transition: all 0.3s ease !important;
        border: none !important;
        outline: none !important;
    }

    .kotivon-cta-btn:hover {
        transform: scale(1.1) !important;
        box-shadow: 0 6px 18px rgba(0,0,0,0.3) !important;
        text-decoration: none !important;
    }

    .kotivon-cta-btn.whatsapp {
        background: <?php echo esc_attr($whatsapp_color); ?> !important;
    }

    .kotivon-cta-btn.phone {
        background: <?php echo esc_attr($phone_color); ?> !important;
    }

    .kotivon-cta-btn svg {
        width: 24px !important;
        height: 24px !important;
        fill: white !important;
    }

    #kotivon-cta-toggle {
        width: 65px !important;
        height: 65px !important;
        border-radius: 50% !important;
        background: <?php echo esc_attr($toggle_color); ?> !important;
        border: none !important;
        color: white !important;
        cursor: pointer !important;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2) !important;
        transition: all 0.3s ease !important;
        outline: none !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
    }

    #kotivon-cta-toggle:hover {
        transform: scale(1.05) !important;
        background: <?php echo esc_attr($toggle_hover_color); ?> !important;
    }

    #kotivon-cta-toggle.active {
        transform: rotate(45deg) !important;
    }

    #kotivon-cta-toggle svg {
        width: 28px !important;
        height: 28px !important;
        fill: white !important;
        transition: transform 0.3s ease !important;
    }

    /* Responsive */
    @media (max-width: 768px) {
        #kotivon-cta-wrapper {
            bottom: 15px !important;
            right: 15px !important;
        }
        
        .kotivon-cta-btn {
            width: 50px !important;
            height: 50px !important;
        }
        
        .kotivon-cta-btn svg {
            width: 20px !important;
            height: 20px !important;
        }
        
        #kotivon-cta-toggle {
            width: 60px !important;
            height: 60px !important;
        }
        
        #kotivon-cta-toggle svg {
            width: 24px !important;
            height: 24px !important;
        }
    }
    </style>

    <div id="kotivon-cta-wrapper">
        <div id="kotivon-cta-buttons">
            <?php if ($whatsapp): ?>
            <a class="kotivon-cta-btn whatsapp" href="https://wa.me/<?php echo esc_attr($whatsapp); ?>" target="_blank" aria-label="WhatsApp" title="WhatsApp">
                <svg viewBox="0 0 24 24">
                    <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/>
                </svg>
            </a>
            <?php endif; ?>
            
            <?php if ($phone): ?>
            <a class="kotivon-cta-btn phone" href="tel:<?php echo esc_attr($phone); ?>" aria-label="Phone" title="Telefon">
                <svg viewBox="0 0 24 24">
                    <path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12.37 2.33.57 3.57.57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25.2 2.45.57 3.57.11.35.03.74-.25 1.02l-2.2 2.2z"/>
                </svg>
            </a>
            <?php endif; ?>
        </div>
        <button id="kotivon-cta-toggle" aria-label="İletişim" title="İletişim">
            <svg viewBox="0 0 24 24">
                <path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 12H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
            </svg>
        </button>
    </div>
    
    <script>
    (function() {
        document.addEventListener('DOMContentLoaded', function() {
            const toggle = document.getElementById('kotivon-cta-toggle');
            const buttons = document.getElementById('kotivon-cta-buttons');
            
            if (toggle && buttons) {
                toggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    buttons.classList.toggle('show');
                    toggle.classList.toggle('active');
                });
                
                // Dışarı tıklandığında kapat
                document.addEventListener('click', function(e) {
                    if (!e.target.closest('#kotivon-cta-wrapper')) {
                        buttons.classList.remove('show');
                        toggle.classList.remove('active');
                    }
                });
            }
        });
    })();
    </script>
    <?php
}, 999);

// Renk koyulaştırma fonksiyonu
function kotivon_darken_color($color, $percent) {
    $color = str_replace('#', '', $color);
    $r = hexdec(substr($color, 0, 2));
    $g = hexdec(substr($color, 2, 2));
    $b = hexdec(substr($color, 4, 2));
    
    $r = max(0, min(255, $r - ($r * $percent / 100)));
    $g = max(0, min(255, $g - ($g * $percent / 100)));
    $b = max(0, min(255, $b - ($b * $percent / 100)));
    
    return sprintf('#%02x%02x%02x', $r, $g, $b);
}

// Dil dosyası yükleme
add_action('init', function() {
    load_plugin_textdomain('kotivon-call-to-action', false, dirname(plugin_basename(__FILE__)) . '/languages');
});