<?php
if (!defined('ABSPATH')) exit;

// 🔁 Programare cron săptămânală
add_action('init', function() {
    if (get_option('kombatoptimizer_webp_cron_enabled')) {
        if (!wp_next_scheduled('kombatoptimizer_weekly_webp_cron')) {
            wp_schedule_event(time(), 'weekly', 'kombatoptimizer_weekly_webp_cron');
        }
    } else {
        $timestamp = wp_next_scheduled('kombatoptimizer_weekly_webp_cron');
        if ($timestamp) {
            wp_unschedule_event($timestamp, 'kombatoptimizer_weekly_webp_cron');
        }
    }
});

// 🔧 Acțiune cron
add_action('kombatoptimizer_weekly_webp_cron', 'kombatoptimizer_run_weekly_webp');

if (!function_exists('kombatoptimizer_run_weekly_webp')) {
    function kombatoptimizer_run_weekly_webp() {
        $upload_dir = wp_upload_dir();
        $base_dir   = trailingslashit($upload_dir['basedir']) . 'kombatoptimizer/';

        if (!file_exists($base_dir)) {
            wp_mkdir_p($base_dir);
        }

        $folders = array_filter(glob($base_dir . '*'), 'is_dir');

        foreach ($folders as $folder) {
            $name = str_replace($base_dir, '', $folder);

            if (function_exists('generate_webp_from_folder')) {
                $report = generate_webp_from_folder($name);

                // ✅ Log dacă funcția există
                if (function_exists('kombatoptimizer_log')) {
                    kombatoptimizer_log("WebP regenerat automat pentru {$name}: convertite={$report['converted']}, ignorate={$report['skipped']}");
                }
            }
        }

        // ✅ Salvează data ultimei rulări
        update_option('kombatoptimizer_last_cron_run', current_time('mysql'));
    }
}
