<?php
// 🔒 Protecție directă
if (!defined('ABSPATH')) exit;

/**
 * 🔍 Scanează imaginile sursă din uploads/{folder}
 * Verifică dacă există WebP corespunzător în uploads/kombatoptimizer/{folder}
 * Calculează acoperirea și detectează WebP corupte
 *
 * @param string $folder Numele folderului relativ din uploads/
 * @return array Raport complet: total, webp, lipsă, corupte, procent
 */
function kombatoptimizer_scan_webp_folder($folder) {
    $upload_dir   = wp_upload_dir();
    $source_path  = trailingslashit($upload_dir['basedir']) . $folder;
    $webp_base    = trailingslashit($upload_dir['basedir']) . 'kombatoptimizer/' . $folder;

    // 🔐 Verificare folder sursă valid
    if (!is_dir($source_path)) {
        return [
            'total' => 0,
            'webp' => 0,
            'missing' => 0,
            'corrupt' => 0,
            'percent' => 0
        ];
    }

    // 🔁 Scanare recursivă în folderul sursă
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source_path));
    $images = [];

    foreach ($rii as $file) {
        if ($file->isFile() && preg_match('/\.(jpg|jpeg|png)$/i', $file->getFilename())) {
            $images[] = $file->getPathname();
        }
    }

    // 📊 Inițializare raport
    $total   = count($images);
    $webp    = 0;
    $missing = 0;
    $corrupt = 0;

    foreach ($images as $img) {
        // 🧭 Calea relativă față de folderul sursă
        $relative = str_replace($source_path, '', $img);

        // 📍 Calea WebP în kombatoptimizer
        $webp_file = $webp_base . $relative;
        $webp_file = preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $webp_file);

        if (file_exists($webp_file)) {
            $webp++;
            $info = @getimagesize($webp_file);
            if ($info === false || $info[2] !== IMAGETYPE_WEBP) {
                $corrupt++;
            }
        } else {
            $missing++;
        }
    }

    $percent = $total > 0 ? round(($webp / $total) * 100, 2) : 0;

    return [
        'total' => $total,
        'webp' => $webp,
        'missing' => $missing,
        'corrupt' => $corrupt,
        'percent' => $percent
    ];
}