<?php
if (!defined('ABSPATH')) {
    exit;
}

// 🔄 Activează filtre doar dacă opțiunea este activă
if (get_option('kombatoptimizer_replace_images')) {
    add_filter('the_content', 'kombatoptimizer_replace_all_image_attributes_with_webp', 40);
    add_filter('post_thumbnail_html', 'kombatoptimizer_replace_all_image_attributes_with_webp', 40);
    add_filter('woocommerce_product_get_image', 'kombatoptimizer_replace_all_image_attributes_with_webp', 40);
    add_filter('woocommerce_single_product_image_thumbnail_html', 'kombatoptimizer_replace_all_image_attributes_with_webp', 50);
    add_filter('wp_get_attachment_image_attributes', 'kombatoptimizer_replace_attachment_src_with_webp', 10, 2);
    add_filter('wp_calculate_image_srcset', 'kombatoptimizer_replace_srcset_with_webp', 10, 5);
    add_filter('wp_get_attachment_image_src', 'kombatoptimizer_replace_thumbnail_src', 10, 4);
    add_filter('post_thumbnail_html', 'kombatoptimizer_replace_images_in_html');
}

// ✅ Generează URL-ul WebP (fallback pentru kombatoptimizer/)
function kombatoptimizer_get_webp_url($original_url) {
    // Dacă fișierul original este deja în kombatoptimizer/, doar schimbă extensia
    if (strpos($original_url, '/kombatoptimizer/') !== false) {
        return preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $original_url);
    }

    // Altfel, mută în folderul kombatoptimizer/
    $upload_dir = wp_upload_dir();
    $base_url   = $upload_dir['baseurl'];
    $relative   = ltrim(str_replace($base_url, '', $original_url), '/');
    $webp_relative = preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $relative);

    return $base_url . '/kombatoptimizer/' . $webp_relative;
}

// ✅ Verifică dacă fișierul .webp există fizic pe server
function kombatoptimizer_webp_exists($original_url) {
    $webp_url = kombatoptimizer_get_webp_url($original_url);
    $path     = wp_parse_url($webp_url, PHP_URL_PATH);

    if (!$path) return false;

    $document_root = isset($_SERVER['DOCUMENT_ROOT']) ? sanitize_text_field(wp_unslash($_SERVER['DOCUMENT_ROOT'])) : '';
    $local_path    = $document_root . $path;

    return file_exists($local_path) && filesize($local_path) > 100;
}

// ✅ Înlocuiește toate atributele relevante din HTML cu versiunea .webp
function kombatoptimizer_replace_all_image_attributes_with_webp($html) {
    if (!is_string($html) || empty($html)) {
        return $html;
    }

    return preg_replace_callback('/(src|srcset|href|data-[a-z_]+)=["\']([^"\']+\.(jpg|jpeg|png))["\']/', function($matches) {
        $attr         = $matches[1];
        $original_url = $matches[2];
        $webp_url     = kombatoptimizer_get_webp_url($original_url);

        return kombatoptimizer_webp_exists($original_url)
            ? $attr . '="' . esc_url($webp_url) . '"'
            : $matches[0];
    }, $html);
}

// ✅ Înlocuiește atributul 'src' din array-ul de imagine
function kombatoptimizer_replace_attachment_src_with_webp($attr, $attachment) {
    if (!isset($attr['src']) || !is_string($attr['src'])) {
        return $attr;
    }

    $original_url = $attr['src'];
    $webp_url     = kombatoptimizer_get_webp_url($original_url);

    if (kombatoptimizer_webp_exists($original_url)) {
        $attr['src'] = esc_url($webp_url);
    }

    return $attr;
}

// ✅ Înlocuiește imaginile din srcset cu versiunea .webp
function kombatoptimizer_replace_srcset_with_webp($sources, $size_array, $image_src, $image_meta, $attachment_id) {
    if (!is_array($sources)) {
        return $sources;
    }

    foreach ($sources as $key => $source) {
        if (isset($source['url']) && preg_match('/\.(jpg|jpeg|png)$/i', $source['url'])) {
            $webp_url = kombatoptimizer_get_webp_url($source['url']);
            if (kombatoptimizer_webp_exists($source['url'])) {
                $sources[$key]['url'] = esc_url($webp_url);
            }
        }
    }

    return $sources;
}

// 🔁 Înlocuire imagini în thumbnails WooCommerce
function kombatoptimizer_replace_thumbnail_src($image, $attachment_id, $size, $icon) {
    if (!is_array($image) || empty($image[0])) return $image;

    $url  = $image[0];
    $webp = kombatoptimizer_get_webp_url($url);

    if (kombatoptimizer_webp_exists($url)) {
        $image[0] = esc_url($webp);
    }

    return $image;
}

// 🔁 Înlocuire imagini în post thumbnail HTML
function kombatoptimizer_replace_images_in_html($html) {
    if (!is_string($html) || empty($html)) {
        return $html;
    }

    return preg_replace_callback('/<img[^>]+src="([^"]+\.(jpg|jpeg|png))"[^>]*>/i', function($matches) {
        $original = $matches[1];
        $webp     = kombatoptimizer_get_webp_url($original);

        return kombatoptimizer_webp_exists($original)
            ? str_replace($original, esc_url($webp), $matches[0])
            : $matches[0];
    }, $html);
}
