<?php
if (!defined('ABSPATH')) exit;
// Modul: Monitorizare TTFB pentru homepage


function kombatoptimizer_ttfb_page() {
    echo '<div class="wrap"><h1>TTFB pentru homepage</h1>';

    $ttfb = kombatoptimizer_measure_ttfb(home_url());
echo '<p><strong>TTFB:</strong> ' . esc_html(round($ttfb, 2)) . ' ms</p>';

    echo '<form method="post">
        <p><input type="submit" name="kombat_refresh_ttfb" class="button" value="Reîmprospătează"></p>
    </form></div>';
}

function kombatoptimizer_measure_ttfb($url) {
    $start = microtime(true);

    $response = wp_remote_get($url, [
        'timeout'     => 10,
        'redirection' => 5,
        'httpversion' => '1.1',
        'blocking'    => true,
    ]);

    $end = microtime(true);
    $ttfb = round(($end - $start) * 1000, 2); // în milisecunde

    return $ttfb;
}