<?php
if (!defined('ABSPATH')) exit;

if (!function_exists('kombatoptimizer_log')) {
    function kombatoptimizer_log($message) {
        if (defined('KOMBATOPTIMIZER_DEBUG') && KOMBATOPTIMIZER_DEBUG) {
            $upload_dir = wp_upload_dir();
            $log_folder = trailingslashit($upload_dir['basedir']) . 'kombatoptimizer';

            if (!file_exists($log_folder)) {
                wp_mkdir_p($log_folder);
            }

            $log_file = $log_folder . '/kombatoptimizer-log.txt';
            $timestamp = gmdate('Y-m-d H:i:s');
            $entry = "[KombatOptimizer] [$timestamp] $message" . PHP_EOL;

            file_put_contents($log_file, $entry, FILE_APPEND | LOCK_EX);
        }
    }
}