document.addEventListener("DOMContentLoaded", function () {
  // 🔁 Tabs
  const buttons = document.querySelectorAll(".kombat-tab-buttons button");
  const contents = document.querySelectorAll(".kombat-tab-content");

  function activateTab(tabId) {
    buttons.forEach((b) => b.classList.remove("active"));
    contents.forEach((c) => c.classList.remove("active"));
    const btn = document.querySelector(`.kombat-tab-buttons button[data-target="${tabId}"]`);
    const content = document.getElementById(tabId);
    if (btn && content) {
      btn.classList.add("active");
      content.classList.add("active");
    }
  }

  buttons.forEach((btn) => {
    btn.addEventListener("click", function () {
      const target = btn.dataset.target;
      localStorage.setItem("kombatoptimizer_active_tab", target);
      activateTab(target);
    });
  });

  const savedTab = localStorage.getItem("kombatoptimizer_active_tab");
  activateTab(savedTab || "tab-generator");

  // ✅ Mesaje temporare
  const messages = document.querySelectorAll('.kombat-success:not(.kombat-persistent)');
  messages.forEach(msg => {
    setTimeout(() => {
      msg.style.display = 'none';
    }, 3000);
  });

  // ✖ Închide mesajul informativ și salvează preferința
  const closeBtn = document.getElementById("close-info-box");
  const infoBox = document.getElementById("kombat-info-box");
  const restoreBox = document.getElementById("kombat-info-restore");
  const restoreLink = restoreBox ? restoreBox.querySelector("a") : null;

  if (localStorage.getItem("kombatoptimizer_info_closed") === "true") {
    if (infoBox) infoBox.style.display = "none";
    if (restoreBox) restoreBox.style.display = "block";
  } else {
    if (restoreBox) restoreBox.style.display = "none";
  }

  if (closeBtn && infoBox) {
    closeBtn.addEventListener("click", function () {
      infoBox.style.display = "none";
      localStorage.setItem("kombatoptimizer_info_closed", "true");
      if (restoreBox) restoreBox.style.display = "block";
    });
  }

  if (restoreLink && infoBox) {
    restoreLink.addEventListener("click", function () {
      localStorage.removeItem("kombatoptimizer_info_closed");
      infoBox.style.display = "block";
      if (restoreBox) restoreBox.style.display = "none";
    });
  }

  // 🔄 Loader vizual la submit
  const form = document.querySelector("#tab-generator form");
  const loader = document.getElementById("kombat-loader");

  if (form && loader) {
    form.addEventListener("submit", function () {
      loader.style.display = "block";
    });
  }
});
