<?php
/**
 * Plugin Name: KMM Metrics
 * Description: This is a short description of what the plugin does.
 * Plugin URI:  http://github.com/KroneMultiMedia/plugin-metrics
 * Version:     0.1.14
 * Author:      Krone.at
 * Author URI:  http://www.krone.at
 * Licence:     MIT
 * Text Domain: kmm-metrics
 * Domain Path: /languages
 */



namespace KMM\Metrics;

use KMM\Metrics\Core;

if (! function_exists('add_filter')) {
    return;
}

/**
 * Ensure that autoload is already loaded or loads it if available.
 *
 * @param string $class_name
 *
 * @return bool
 */
function ensure_class_loaded($class_name)
{

    $class_exists   = class_exists($class_name);
    $autoload_found = file_exists(ABSPATH . '/vendor/autoload.php');

    // If the class does not exist, and the vendor file is there
    // maybe the plugin was installed separately via Composer, let's try to load autoload
    $local_autoload_found = file_exists(ABSPATH . '/wp-content/plugins/kmm-metrics/vendor/autoload.php');
    if(! $class_exists && $local_autoload_found ) {
        @require_once ABSPATH . 'wp-content/plugins/kmm-metrics/vendor/autoload.php';
    }

    return $class_exists || ( ($autoload_found || $local_autoload_found) && class_exists($class_name) );

}

// Exit if classes are not available
if (! ensure_class_loaded(__NAMESPACE__ . '\Core')) {
    return;
}


add_action('plugins_loaded', __NAMESPACE__ . '\main');


/**
 * @wp-hook plugins_loaded
 */
function main()
{
    include_once("src/StatsD.php");

    $i18n = 'kmm-metrics';
    load_plugin_textdomain(
        $i18n,
        false,
        dirname(plugin_basename(__FILE__)) . '/languages'
    );


    new Core($i18n);

    if (is_admin()) {
        // Backend

        // TODO: register your backend-code here...
    } else {
        // Frontend

        // TODO: register frontend-code here...
    }
}
