<?php
/**
 * Company review template.
 *
 * @package Converzo\KiyohReviews
 */

use Converzo\KiyohReviews\Service\CompanyReview;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$converzo_kiyoh_company_review = CompanyReview::get_data();

if ( $converzo_kiyoh_company_review ) {
	$converzo_kiyoh_maxrating = 10;
	?>
<div class="kiyoh-shop-snippets">
	<div class="rating-box">
		<div class="rating" style="width:<?php echo esc_attr( floatval( $converzo_kiyoh_company_review['averageRating'] ) * $converzo_kiyoh_maxrating ); ?>%"></div>
	</div>
	<div class="kiyoh-schema" itemscope="itemscope" itemtype="http://schema.org/Organization">
		<meta itemprop="name" content="<?php echo esc_attr( $converzo_kiyoh_company_review['locationName'] ); ?>"/>
		<a href="<?php echo esc_url( get_site_url() ); ?>" itemprop="url" style="display: none"><?php echo esc_url( get_site_url() ); ?></a>
		<div itemprop="aggregateRating" itemscope="itemscope" itemtype="http://schema.org/AggregateRating">
			<meta itemprop="bestRating" content="<?php echo esc_attr( $converzo_kiyoh_maxrating ); ?>">
			<p>
				<a href="<?php echo esc_url( $converzo_kiyoh_company_review['viewReviewUrl'] ); ?>" target="_blank" class="kiyoh-link">
					<?php
					printf(
						/* translators: 1: rating value, 2: maximum rating, 3: number of reviews. */
						esc_html__( 'Rating %1$s out of %2$s, based on %3$s customer reviews', 'kiyoh-reviews' ),
						'<span itemprop="ratingValue">' . esc_html( $converzo_kiyoh_company_review['averageRating'] ) . '</span>',
						esc_html( $converzo_kiyoh_maxrating ),
						'<span itemprop="ratingCount">' . esc_html( $converzo_kiyoh_company_review['numberReviews'] ) . '</span>'
					);
					?>
				</a>
			</p>
		</div>
	</div>
</div>
<?php } ?>
