<?php
/**
 * Admin settings template.
 *
 * @package Converzo\KiyohReviews
 */

use Converzo\KiyohReviews\Admin\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Handle form submission.
// phpcs:ignore WordPress.Security.NonceVerification.Missing -- Nonce is verified by check_admin_referer.
if ( isset( $_POST['save'] ) && check_admin_referer( 'woocommerce-settings' ) ) {
	Settings::save_settings();

	// Always test connection after saving.
	$converzo_kiyoh_connection_result = Settings::test_and_store_connection();

	if ( $converzo_kiyoh_connection_result['success'] ) {
		echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Settings saved.', 'kiyoh-reviews' ) . '</p></div>';
	} else {
		echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'Settings saved.', 'kiyoh-reviews' ) . ' <strong>Kiyoh:</strong> ' . esc_html( $converzo_kiyoh_connection_result['message'] ) . '</p></div>';
	}
}
?>
<div class="wrap woocommerce">
	<h1><?php esc_html_e( 'Kiyoh Reviews Settings', 'kiyoh-reviews' ); ?></h1>

	<form method="post" action="">
		<?php wp_nonce_field( 'woocommerce-settings' ); ?>
		<?php woocommerce_admin_fields( Settings::get_settings_fields() ); ?>

		<div class="kiyoh-settings-section kiyoh-settings-section--sync">
			<h2><?php esc_html_e( 'Product Sync', 'kiyoh-reviews' ); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Sync products', 'kiyoh-reviews' ); ?></th>
					<td>
						<?php if ( Settings::is_connection_valid() ) : ?>
							<button type="button" class="button" id="sync_products">
								<span class="sync-text"><?php esc_html_e( 'Sync products to Kiyoh', 'kiyoh-reviews' ); ?></span>
								<span class="spinner"></span>
							</button>
							<span class="sync-result"></span>
							<p class="description"><?php esc_html_e( 'Send products manually to Kiyoh. This is done automatically daily.', 'kiyoh-reviews' ); ?></p>
						<?php else : ?>
							<p class="description"><?php esc_html_e( 'Save valid API credentials to enable product sync.', 'kiyoh-reviews' ); ?></p>
						<?php endif; ?>
					</td>
				</tr>
			</table>
		</div>

		<p class="submit">
			<button type="submit" name="save" class="button button-primary"><?php esc_html_e( 'Save changes', 'kiyoh-reviews' ); ?></button>
		</p>
	</form>
</div>
