<?php
/**
 * Kiyoh Company Widget.
 *
 * @package Converzo\KiyohReviews
 */

namespace Converzo\KiyohReviews\Widget;

use Converzo\KiyohReviews\Service\CompanyReview;
use WP_Widget;

/**
 * Widget for displaying company review data from Kiyoh.
 */
class CompanyWidget extends WP_Widget {

	/**
	 * Constructor.
	 */
	public function __construct() {
		parent::__construct(
			'converzo_kiyoh_company_widget',
			__( 'Kiyoh', 'kiyoh-reviews' ),
			array( 'description' => __( 'Widget for showing company review', 'kiyoh-reviews' ) )
		);
	}

	/**
	 * Output the widget content.
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Widget instance data.
	 * @return void
	 */
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Widget args are pre-escaped by WordPress.
		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Widget args are pre-escaped by WordPress.
			echo $args['before_title'] . esc_html( $title ) . $args['after_title'];
		}

		CompanyReview::render_template();

		// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Widget args are pre-escaped by WordPress.
		echo $args['after_widget'];
	}

	/**
	 * Output the widget settings form.
	 *
	 * @param array $instance Widget instance data.
	 * @return void
	 */
	public function form( $instance ) {
		$title = isset( $instance['title'] ) ? $instance['title'] : __( 'New title', 'kiyoh-reviews' );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
				<?php esc_html_e( 'Title:', 'kiyoh-reviews' ); ?>
			</label>
			<input class="widefat"
				id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
				type="text"
				value="<?php echo esc_attr( $title ); ?>"
			/>
		</p>
		<?php
	}

	/**
	 * Update widget settings.
	 *
	 * @param array $new_instance New widget instance data.
	 * @param array $old_instance Old widget instance data.
	 * @return array Updated instance data.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? wp_strip_all_tags( $new_instance['title'] ) : '';
		return $instance;
	}
}
