<?php
/**
 * Product Sync Service class for Kiyoh Reviews.
 *
 * @package Converzo\KiyohReviews
 */

namespace Converzo\KiyohReviews\Service;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Converzo\KiyohReviews\Api\Client;

/**
 * Handles syncing product catalog with Kiyoh.
 */
class ProductSync {

	/**
	 * Initialize product sync hooks.
	 *
	 * @return void
	 */
	public static function init(): void {
		add_action( 'converzo_kiyoh_sync_product_catalog', array( static::class, 'sync_catalog' ) );
	}

	/**
	 * Sync the product catalog with Kiyoh.
	 *
	 * @return bool True on success.
	 */
	public static function sync_catalog(): bool {
		$products        = wc_get_products(
			array(
				'status' => 'publish',
				'limit'  => -1,
			)
		);
		$img_placeholder = wc_placeholder_img_src( 'woocommerce_thumbnail' );
		$product_data    = array();

		foreach ( $products as $product ) {
			$image_id = $product->get_image_id();
			$image    = $image_id ? wp_get_attachment_url( $image_id ) : $img_placeholder;

			$product_data[] = array(
				'location_id'  => Client::get_location_id(),
				'product_code' => $product->get_id(),
				'product_name' => $product->get_name(),
				'image_url'    => $image,
				'source_url'   => $product->get_permalink(),
				'active'       => true,
			);
		}

		$success = true;
		foreach ( array_chunk( $product_data, 100 ) as $chunk ) {
			if ( ! Client::push_products( $chunk ) ) {
				$success = false;
			}
		}

		return $success;
	}
}
