<?php
/**
 * Company Review Service class for Kiyoh Reviews.
 *
 * @package Converzo\KiyohReviews
 */

namespace Converzo\KiyohReviews\Service;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Converzo\KiyohReviews\Api\Client;

/**
 * Handles company review data.
 */
class CompanyReview {

	/**
	 * Initialize company review hooks.
	 *
	 * @return void
	 */
	public static function init(): void {
		add_action( 'converzo_kiyoh_fetch_company_reviews', array( static::class, 'fetch_and_cache' ) );
	}

	/**
	 * Option name for cached company review data.
	 *
	 * @var string
	 */
	const OPTION_COMPANY_REVIEW_DATA = 'converzo_kiyoh_company_review_data';

	/**
	 * Get cached company review data.
	 *
	 * @return array|false The company review data or false if not set.
	 */
	public static function get_data() {
		return get_option( self::OPTION_COMPANY_REVIEW_DATA );
	}

	/**
	 * Fetch company review data and cache it.
	 *
	 * @return array|false The company review data or false on failure.
	 */
	public static function fetch_and_cache() {
		$data = Client::fetch_company_reviews();

		if ( false !== $data ) {
			update_option( self::OPTION_COMPANY_REVIEW_DATA, $data );
		}

		return $data;
	}

	/**
	 * Render the company review template.
	 *
	 * @return void
	 */
	public static function render_template(): void {
		include CONVERZO_KIYOH_PLUGIN_DIR . 'templates/company-review.php';
	}
}
