<?php
/**
 * Premium review content handler.
 *
 * @package Converzo\KiyohReviews\Premium__premium_only
 */

namespace Converzo\KiyohReviews\Premium__premium_only;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles rendering of premium review content fields.
 */
class ReviewContent {

	/**
	 * Store KiyOh review data for rendering.
	 *
	 * @var array
	 */
	private static array $kiyoh_reviews = array();

	/**
	 * Initialize the review content hooks.
	 *
	 * @return void
	 */
	public static function init(): void {
		add_filter( 'comments_array', array( static::class, 'store_kiyoh_reviews' ), 20, 2 );
		add_action( 'woocommerce_review_after_comment_text', array( static::class, 'render_extra_content' ) );
	}

	/**
	 * Store KiyOh reviews for later rendering.
	 *
	 * @param array $comments The comments array.
	 * @param int   $post_id  The post ID.
	 * @return array The unchanged comments array.
	 */
	public static function store_kiyoh_reviews( array $comments, int $post_id ): array {
		$product = wc_get_product( $post_id );

		if ( ! $product instanceof \WC_Product ) {
			return $comments;
		}

		$kiyoh_reviews = $product->get_meta( 'converzo_kiyoh_reviews', true );

		if ( is_array( $kiyoh_reviews ) ) {
			foreach ( $kiyoh_reviews as $review ) {
				$comment_id                         = 'converzo_kiyoh_' . ( $review['id'] ?? '' );
				self::$kiyoh_reviews[ $comment_id ] = $review;
			}
		}

		return $comments;
	}

	/**
	 * Render extra content after KiyOh review comment text.
	 *
	 * @param \WP_Comment $comment The comment object.
	 * @return void
	 */
	public static function render_extra_content( $comment ): void {
		$comment_id = $comment->comment_ID;

		if ( ! isset( self::$kiyoh_reviews[ $comment_id ] ) ) {
			return;
		}

		$review = self::$kiyoh_reviews[ $comment_id ];

		// Product review content ratings.
		if ( ! empty( $review['productReviewContent'] ) && is_array( $review['productReviewContent'] ) ) {
			echo '<div class="kiyoh-product-ratings">';
			foreach ( $review['productReviewContent'] as $content ) {
				if ( isset( $content['rating'] ) ) {
					$label = $content['label'] ?? '';
					echo '<span class="kiyoh-product-rating">';
					if ( $label ) {
						echo esc_html( $label ) . ': ';
					}
					echo esc_html( $content['rating'] );
					echo '</span><br>';
				}
			}
			echo '</div>';
		}
	}
}
