<?php
/**
 * Plugin Name: Kiyoh Reviews
 * Plugin URI:  https://converzo.nl/kiyoh-reviews
 * Description: Show Kiyoh reviews in WooCommerce.
 * Version:     1.0.0
 * Author:      Converzo
 * Author URI:  https://converzo.nl
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: kiyoh-reviews
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 *
 * @package Converzo\KiyohReviews
 * @fs_premium_only /src/Premium__premium_only/
 */

defined( 'ABSPATH' ) || exit;

define( 'CONVERZO_KIYOH_VERSION', '1.0.0' );
define( 'CONVERZO_KIYOH_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CONVERZO_KIYOH_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'CONVERZO_KIYOH_PLUGIN_FILE', __FILE__ );

// Composer autoloader.
if ( file_exists( CONVERZO_KIYOH_PLUGIN_DIR . 'vendor/autoload.php' ) ) {
	require_once CONVERZO_KIYOH_PLUGIN_DIR . 'vendor/autoload.php';
}

// Initialize Freemius.
if ( ! function_exists( 'converzo_kiyoh_fs' ) ) {
	/**
	 * Create a helper function for easy SDK access.
	 *
	 * @return Freemius
	 */
	function converzo_kiyoh_fs() { // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedFunctionFound -- Freemius SDK convention.
		global $converzo_kiyoh_fs; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Freemius SDK convention.

		if ( ! isset( $converzo_kiyoh_fs ) ) {
			require_once CONVERZO_KIYOH_PLUGIN_DIR . 'vendor/freemius/wordpress-sdk/start.php';

			// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Freemius SDK convention.
			$converzo_kiyoh_fs = fs_dynamic_init(
				array(
					'id'               => '15664',
					'slug'             => 'kiyoh-reviews',
					'premium_slug'     => 'kiyoh-reviews-gold',
					'type'             => 'plugin',
					'public_key'       => 'pk_deda561ed6e45a2fad93c2e2f342d',
					'is_premium'       => true,
					'premium_suffix'   => '(Gold)',
					'has_addons'       => false,
					'has_paid_plans'   => true,
					'is_org_compliant' => true,
					'menu'             => array(
						'slug'    => 'kiyoh',
						'support' => false,
						'parent'  => array(
							'slug' => 'options-general.php',
						),
					),
					'is_live'          => true,
				)
			);

			// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Freemius SDK convention.
			do_action( 'converzo_kiyoh_fs_loaded' );
		}

		return $converzo_kiyoh_fs;
	}

	// Initialize Freemius after WordPress is loaded.
	add_action( 'plugins_loaded', 'converzo_kiyoh_fs' );
}

// Register hooks.
register_activation_hook( __FILE__, array( 'Converzo\\KiyohReviews\\Plugin', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'Converzo\\KiyohReviews\\Plugin', 'deactivate' ) );

add_action( 'init', array( 'Converzo\\KiyohReviews\\Plugin', 'init' ) );
add_action( 'init', array( 'Converzo\\KiyohReviews\\Plugin', 'init_widgets' ), 0 );
