/**
 * Admin settings JavaScript.
 *
 * @package Converzo\KiyohReviews
 */

/* global jQuery, kiyohSettings */
jQuery(
	function ( $ ) {
		var $button = $( '#sync_products' );
		var $spinner = $button.find( '.spinner' );
		var $result = $button.siblings( '.sync-result' );

		$button.on(
			'click',
			function () {
				$button.prop( 'disabled', true );
				$spinner.addClass( 'is-active' );
				$result.empty();

				$.ajax(
					{
						url: kiyohSettings.ajaxUrl,
						type: 'POST',
						dataType: 'json',
						data: {
							action: 'converzo_kiyoh_sync_products',
							nonce: kiyohSettings.nonce
						},
						success: function ( response ) {
							$spinner.removeClass( 'is-active' );
							$button.prop( 'disabled', false );
							if ( response.success ) {
								$result.html( '<span class="dashicons dashicons-yes" style="color:#00a32a"></span> ' + response.data.message );
							} else {
								$result.html( '<span class="dashicons dashicons-no" style="color:#d63638"></span> ' + response.data.message );
							}
						},
						error: function () {
							$spinner.removeClass( 'is-active' );
							$button.prop( 'disabled', false );
							$result.html( '<span class="dashicons dashicons-no" style="color:#d63638"></span> ' + kiyohSettings.i18n.syncFailed );
						}
					}
				);
			}
		);
	}
);
