(function ($) {
    'use strict';

    function wccfSyncPaymentMethod() {
        var method = $('input[name="payment_method"]:checked').val() || '';
        $('#wccf_payment_method').val(method);
    }

    // On page load.
    $(function () {
        wccfSyncPaymentMethod();
    });

    // When checkout is updated (by WooCommerce).
    $(document.body).on('updated_checkout', function () {
        wccfSyncPaymentMethod();
    });

    // When user changes payment method:
    // 1) sync our hidden field
    // 2) force WooCommerce to recalculate totals.
    $(document.body).on('change', 'input[name="payment_method"]', function () {
        wccfSyncPaymentMethod();
        $(document.body).trigger('update_checkout');
    });

})(jQuery);
