"use strict";

(function ($) {
    const parseNumber = (value, fallback) => {
        const number = parseInt(value, 10);
        return Number.isFinite(number) ? number : fallback;
    };

    const initCardSlider = ($scope) => {
        const container = $scope[0]?.querySelector(".king-addons-card-slider__track");

        if (!container || typeof Swiper === "undefined") {
            return;
        }

        const settings = container.dataset;

        const slidesPerView = parseNumber(settings.slidesPerView, 1);
        const slidesPerViewTablet = parseNumber(settings.slidesPerViewTablet, slidesPerView);
        const slidesPerViewMobile = parseNumber(settings.slidesPerViewMobile, slidesPerViewTablet);
        const spaceBetween = parseNumber(settings.spaceBetween, 20);
        const speed = parseNumber(settings.speed, 600);

        const config = {
            slidesPerView: slidesPerView,
            spaceBetween: spaceBetween,
            speed: speed,
            loop: settings.loop === "yes",
            breakpoints: {
                0: { slidesPerView: slidesPerViewMobile },
                768: { slidesPerView: slidesPerViewTablet },
                1024: { slidesPerView: slidesPerView },
            },
        };

        if (settings.autoplay === "yes") {
            config.autoplay = {
                delay: parseNumber(settings.autoplayDelay, 3200),
                disableOnInteraction: false,
            };
        }

        if (settings.pagination === "yes") {
            config.pagination = {
                el: container.querySelector(".king-addons-card-slider__pagination"),
                clickable: true,
            };
        }

        if (settings.navigation === "yes") {
            config.navigation = {
                nextEl: $scope[0].querySelector(".king-addons-card-slider__arrow--next"),
                prevEl: $scope[0].querySelector(".king-addons-card-slider__arrow--prev"),
            };
        }

        const isEditMode = elementorFrontend.isEditMode();
        const swiperInstance = new Swiper(container, config); // eslint-disable-line no-new

        // Card-level link handling: only bind on frontend to avoid blocking editor selection.
        if (!isEditMode) {
            const slides = $scope[0].querySelectorAll(".king-addons-card-slider__slide[data-card-link]");
            slides.forEach((slide) => {
                slide.addEventListener("click", (event) => {
                    // If clicking a real link inside, respect that link.
                    if (event.target.closest("a")) {
                        return;
                    }

                    const url = slide.dataset.cardLink;
                    if (!url) {
                        return;
                    }

                    const target = slide.dataset.cardLinkTarget || "_self";
                    window.open(url, target);
                });
            });
        }

        return swiperInstance;
    };

    $(window).on("elementor/frontend/init", function () {
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/king-addons-quick-card-slider.default",
            function ($scope) {
                initCardSlider($scope);
            }
        );
    });
})(jQuery);








