# Content Toggle - Widget Guide

## Overview
Content Toggle lets you present two states of content (primary and secondary) behind a simple switcher, reducing scroll and keeping comparisons or alternatives in a single space. Each state can show text or imagery, and the toggle is fully styleable.

## Free Features
- Primary and secondary areas with text or image sources.
- Custom labels and default active state.
- Switch alignment, sizing, colors, and label typography.
- Pane styling for background, padding, borders, radius, and shadows.

## Pro Features
- Use Elementor saved templates for primary and secondary content.
- Add icons to primary and secondary labels.
- Slide or fade animation styles for pane changes.
- Sync external CSS selectors to show/hide per state with custom active/hidden classes.

## How to Use
1. Drop “Content Toggle” onto your page.
2. Set Primary/Secondary labels and choose the default state.
3. Pick a source for each side (Text or Image; Templates in Pro) and add your content.
4. Style the switch (size, colors, typography) and the content panes (background, padding, borders).
5. In Pro, add label icons and configure external selectors to show/hide when states change.

## Tips
- Keep labels short so the switch remains compact.
- When syncing external selectors (Pro), use simple class or ID selectors and ensure your active/hidden classes exist in your stylesheet.
- For imagery, set consistent sizes to avoid layout shift when toggling.




