<?php
/**
 * Pricing Table Presets.
 *
 * @package King_Addons
 */

if (!defined('ABSPATH')) {
    exit;
}

$is_premium = function_exists('king_addons_freemius') && king_addons_freemius()->can_use_premium_code__premium_only();

$presets = [
    // ============================================
    // FREE PRESETS (5)
    // ============================================

    'free_minimal_light' => [
        'id' => 'free_minimal_light',
        'name' => 'Minimal Light',
        'group' => 'minimal',
        'is_pro' => false,
        'preview_image' => 'minimal-light.svg',
        'description' => 'Clean, minimalist design with subtle borders',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e7eb',
                'text' => '#111827',
                'muted' => '#6b7280',
                'accent' => '#2563eb',
                'accent_text' => '#ffffff',
                'badge_bg' => '#dbeafe',
                'badge_text' => '#1d4ed8',
                'highlight' => '#2563eb',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'free_modern_cards' => [
        'id' => 'free_modern_cards',
        'name' => 'Modern Cards',
        'group' => 'modern',
        'is_pro' => false,
        'preview_image' => 'modern-cards.svg',
        'description' => 'Premium style inspired cards with soft shadows',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => 'transparent',
                'text' => '#1d1d1f',
                'muted' => '#86868b',
                'accent' => '#0071e3',
                'accent_text' => '#ffffff',
                'badge_bg' => '#f5f5f7',
                'badge_text' => '#1d1d1f',
                'highlight' => '#0071e3',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 56,
                'body_size' => 14,
            ],
            'radius' => 20,
            'border_width' => 0,
            'shadow' => 'lg',
        ],
    ],

    'free_outline_pro' => [
        'id' => 'free_outline_pro',
        'name' => 'Outline Pro',
        'group' => 'outline',
        'is_pro' => false,
        'preview_image' => 'outline-pro.svg',
        'description' => 'Professional outlined cards',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#d1d5db',
                'text' => '#111827',
                'muted' => '#6b7280',
                'accent' => '#4f46e5',
                'accent_text' => '#ffffff',
                'badge_bg' => '#4f46e5',
                'badge_text' => '#ffffff',
                'highlight' => '#4f46e5',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 44,
                'body_size' => 15,
            ],
            'radius' => 16,
            'border_width' => 2,
            'shadow' => 'sm',
        ],
    ],

    'free_dark_saas' => [
        'id' => 'free_dark_saas',
        'name' => 'Dark SaaS',
        'group' => 'dark',
        'is_pro' => false,
        'preview_image' => 'dark-saas.svg',
        'description' => 'Modern dark theme for SaaS products',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#1f2937',
                'card_border' => '#374151',
                'text' => '#f9fafb',
                'muted' => '#9ca3af',
                'accent' => '#10b981',
                'accent_text' => '#ffffff',
                'badge_bg' => '#10b981',
                'badge_text' => '#ffffff',
                'highlight' => '#10b981',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 16,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'free_gradient_header' => [
        'id' => 'free_gradient_header',
        'name' => 'Gradient Header',
        'group' => 'gradient',
        'is_pro' => false,
        'preview_image' => 'gradient-header.svg',
        'description' => 'Cards with gradient header accent',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e7eb',
                'text' => '#111827',
                'muted' => '#6b7280',
                'accent' => '#8b5cf6',
                'accent_text' => '#ffffff',
                'badge_bg' => 'linear-gradient(135deg, #8b5cf6 0%, #d946ef 100%)',
                'badge_text' => '#ffffff',
                'highlight' => '#8b5cf6',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 52,
                'body_size' => 14,
            ],
            'radius' => 24,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    // ============================================
    // PRO PRESETS (25+)
    // ============================================

    'pro_fruit_phone' => [
        'id' => 'pro_fruit_phone',
        'name' => 'Fruit Phone',
        'group' => 'premium',
        'is_pro' => true,
        'preview_image' => 'fruit-phone.svg',
        'description' => 'Premium style with SF Pro typography feel',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#fbfbfd',
                'card_border' => 'transparent',
                'text' => '#1d1d1f',
                'muted' => '#86868b',
                'accent' => '#0071e3',
                'accent_text' => '#ffffff',
                'badge_bg' => '#1d1d1f',
                'badge_text' => '#ffffff',
                'highlight' => '#0071e3',
            ],
            'typography' => [
                'title_size' => 28,
                'price_size' => 64,
                'body_size' => 15,
            ],
            'radius' => 28,
            'border_width' => 0,
            'shadow' => 'lg',
        ],
    ],

    'pro_helpscout' => [
        'id' => 'pro_helpscout',
        'name' => 'HelpScout Style',
        'group' => 'premium',
        'is_pro' => true,
        'preview_image' => 'helpscout.svg',
        'description' => 'Inspired by HelpScout pricing page',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e2e8f0',
                'text' => '#1a202c',
                'muted' => '#718096',
                'accent' => '#4299e1',
                'accent_text' => '#ffffff',
                'badge_bg' => '#ebf8ff',
                'badge_text' => '#2b6cb0',
                'highlight' => '#4299e1',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 48,
                'body_size' => 16,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_stripe' => [
        'id' => 'pro_stripe',
        'name' => 'Stripe Inspired',
        'group' => 'premium',
        'is_pro' => true,
        'preview_image' => 'stripe.svg',
        'description' => 'Clean design inspired by Stripe',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e6ebf1',
                'text' => '#32325d',
                'muted' => '#6b7c93',
                'accent' => '#6772e5',
                'accent_text' => '#ffffff',
                'badge_bg' => '#6772e5',
                'badge_text' => '#ffffff',
                'highlight' => '#6772e5',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 44,
                'body_size' => 15,
            ],
            'radius' => 8,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_notion' => [
        'id' => 'pro_notion',
        'name' => 'Notion Clean',
        'group' => 'minimal',
        'is_pro' => true,
        'preview_image' => 'notion.svg',
        'description' => 'Minimal design inspired by Notion',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e4e4e4',
                'text' => '#37352f',
                'muted' => '#9b9a97',
                'accent' => '#2eaadc',
                'accent_text' => '#ffffff',
                'badge_bg' => '#e9e9e8',
                'badge_text' => '#37352f',
                'highlight' => '#37352f',
            ],
            'typography' => [
                'title_size' => 18,
                'price_size' => 40,
                'body_size' => 14,
            ],
            'radius' => 4,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'pro_linear' => [
        'id' => 'pro_linear',
        'name' => 'Linear Dark',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'linear.svg',
        'description' => 'Dark theme inspired by Linear app',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#1c1c1e',
                'card_border' => '#2c2c2e',
                'text' => '#ffffff',
                'muted' => '#8e8e93',
                'accent' => '#5e6ad2',
                'accent_text' => '#ffffff',
                'badge_bg' => '#5e6ad2',
                'badge_text' => '#ffffff',
                'highlight' => '#5e6ad2',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_vercel' => [
        'id' => 'pro_vercel',
        'name' => 'Vercel Edge',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'vercel.svg',
        'description' => 'Sharp dark design inspired by Vercel',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#0a0a0a',
                'card_border' => '#262626',
                'text' => '#fafafa',
                'muted' => '#a1a1aa',
                'accent' => '#ffffff',
                'accent_text' => '#000000',
                'badge_bg' => '#ffffff',
                'badge_text' => '#000000',
                'highlight' => '#ffffff',
            ],
            'typography' => [
                'title_size' => 18,
                'price_size' => 44,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'pro_figma' => [
        'id' => 'pro_figma',
        'name' => 'Figma Colors',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'figma.svg',
        'description' => 'Vibrant colors inspired by Figma',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e5e5',
                'text' => '#1e1e1e',
                'muted' => '#6e6e6e',
                'accent' => '#f24e1e',
                'accent_text' => '#ffffff',
                'badge_bg' => '#a259ff',
                'badge_text' => '#ffffff',
                'highlight' => '#f24e1e',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_slack' => [
        'id' => 'pro_slack',
        'name' => 'Slack Purple',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'slack.svg',
        'description' => 'Friendly design inspired by Slack',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#dddddd',
                'text' => '#1d1c1d',
                'muted' => '#616061',
                'accent' => '#4a154b',
                'accent_text' => '#ffffff',
                'badge_bg' => '#ecb22e',
                'badge_text' => '#1d1c1d',
                'highlight' => '#4a154b',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 46,
                'body_size' => 15,
            ],
            'radius' => 10,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_intercom' => [
        'id' => 'pro_intercom',
        'name' => 'Intercom Blue',
        'group' => 'modern',
        'is_pro' => true,
        'preview_image' => 'intercom.svg',
        'description' => 'Friendly blue design',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e1e1e1',
                'text' => '#222222',
                'muted' => '#737373',
                'accent' => '#0052cc',
                'accent_text' => '#ffffff',
                'badge_bg' => '#deebff',
                'badge_text' => '#0052cc',
                'highlight' => '#0052cc',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 52,
                'body_size' => 15,
            ],
            'radius' => 16,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_tailwind' => [
        'id' => 'pro_tailwind',
        'name' => 'Tailwind Cyan',
        'group' => 'modern',
        'is_pro' => true,
        'preview_image' => 'tailwind.svg',
        'description' => 'Fresh cyan accents',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e2e8f0',
                'text' => '#0f172a',
                'muted' => '#64748b',
                'accent' => '#06b6d4',
                'accent_text' => '#ffffff',
                'badge_bg' => '#ecfeff',
                'badge_text' => '#0891b2',
                'highlight' => '#06b6d4',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_github' => [
        'id' => 'pro_github',
        'name' => 'GitHub Neutral',
        'group' => 'minimal',
        'is_pro' => true,
        'preview_image' => 'github.svg',
        'description' => 'Developer-friendly neutral design',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#d0d7de',
                'text' => '#24292f',
                'muted' => '#57606a',
                'accent' => '#238636',
                'accent_text' => '#ffffff',
                'badge_bg' => '#ddf4ff',
                'badge_text' => '#0969da',
                'highlight' => '#238636',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 44,
                'body_size' => 14,
            ],
            'radius' => 6,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'pro_dribbble' => [
        'id' => 'pro_dribbble',
        'name' => 'Dribbble Pink',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'dribbble.svg',
        'description' => 'Creative pink design',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#f0f0f0',
                'text' => '#2b3137',
                'muted' => '#8c8c8c',
                'accent' => '#ea4c89',
                'accent_text' => '#ffffff',
                'badge_bg' => '#fce4ec',
                'badge_text' => '#ea4c89',
                'highlight' => '#ea4c89',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 52,
                'body_size' => 15,
            ],
            'radius' => 16,
            'border_width' => 0,
            'shadow' => 'md',
        ],
    ],

    'pro_airtable' => [
        'id' => 'pro_airtable',
        'name' => 'Airtable Fresh',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'airtable.svg',
        'description' => 'Colorful teal accents',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e5e5',
                'text' => '#333333',
                'muted' => '#666666',
                'accent' => '#18bfff',
                'accent_text' => '#ffffff',
                'badge_bg' => '#fcb400',
                'badge_text' => '#333333',
                'highlight' => '#18bfff',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_webflow' => [
        'id' => 'pro_webflow',
        'name' => 'Webflow Bold',
        'group' => 'modern',
        'is_pro' => true,
        'preview_image' => 'webflow.svg',
        'description' => 'Bold design with blue accent',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e4ebf3',
                'text' => '#1a1a2e',
                'muted' => '#7c8db5',
                'accent' => '#4353ff',
                'accent_text' => '#ffffff',
                'badge_bg' => '#4353ff',
                'badge_text' => '#ffffff',
                'highlight' => '#4353ff',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 56,
                'body_size' => 15,
            ],
            'radius' => 20,
            'border_width' => 1,
            'shadow' => 'lg',
        ],
    ],

    'pro_monday' => [
        'id' => 'pro_monday',
        'name' => 'Monday Work',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'monday.svg',
        'description' => 'Colorful work OS style',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e6e9ef',
                'text' => '#323338',
                'muted' => '#676879',
                'accent' => '#0073ea',
                'accent_text' => '#ffffff',
                'badge_bg' => '#00c875',
                'badge_text' => '#ffffff',
                'highlight' => '#0073ea',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 46,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_asana' => [
        'id' => 'pro_asana',
        'name' => 'Asana Coral',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'asana.svg',
        'description' => 'Warm coral accents',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#edeae9',
                'text' => '#1e1f21',
                'muted' => '#6d6e6f',
                'accent' => '#f06a6a',
                'accent_text' => '#ffffff',
                'badge_bg' => '#fff4f4',
                'badge_text' => '#f06a6a',
                'highlight' => '#f06a6a',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 44,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_loom' => [
        'id' => 'pro_loom',
        'name' => 'Loom Purple',
        'group' => 'gradient',
        'is_pro' => true,
        'preview_image' => 'loom.svg',
        'description' => 'Modern purple gradient',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e7eb',
                'text' => '#141414',
                'muted' => '#666666',
                'accent' => '#625df5',
                'accent_text' => '#ffffff',
                'badge_bg' => 'linear-gradient(135deg, #625df5 0%, #9089fc 100%)',
                'badge_text' => '#ffffff',
                'highlight' => '#625df5',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 16,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_miro' => [
        'id' => 'pro_miro',
        'name' => 'Miro Yellow',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'miro.svg',
        'description' => 'Creative yellow accent',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e5e5e5',
                'text' => '#050038',
                'muted' => '#5c5c74',
                'accent' => '#fac710',
                'accent_text' => '#050038',
                'badge_bg' => '#fac710',
                'badge_text' => '#050038',
                'highlight' => '#050038',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 52,
                'body_size' => 15,
            ],
            'radius' => 12,
            'border_width' => 2,
            'shadow' => 'sm',
        ],
    ],

    'pro_discord' => [
        'id' => 'pro_discord',
        'name' => 'Discord Blurple',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'discord.svg',
        'description' => 'Gaming-inspired blurple theme',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#36393f',
                'card_border' => '#42464d',
                'text' => '#ffffff',
                'muted' => '#b9bbbe',
                'accent' => '#5865f2',
                'accent_text' => '#ffffff',
                'badge_bg' => '#5865f2',
                'badge_text' => '#ffffff',
                'highlight' => '#5865f2',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 44,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 0,
            'shadow' => 'md',
        ],
    ],

    'pro_spotify' => [
        'id' => 'pro_spotify',
        'name' => 'Spotify Dark',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'spotify.svg',
        'description' => 'Music-inspired green accent',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#181818',
                'card_border' => '#282828',
                'text' => '#ffffff',
                'muted' => '#b3b3b3',
                'accent' => '#1db954',
                'accent_text' => '#000000',
                'badge_bg' => '#1db954',
                'badge_text' => '#000000',
                'highlight' => '#1db954',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 0,
            'shadow' => 'none',
        ],
    ],

    'pro_netflix' => [
        'id' => 'pro_netflix',
        'name' => 'Netflix Red',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'netflix.svg',
        'description' => 'Bold red on black',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#141414',
                'card_border' => '#333333',
                'text' => '#ffffff',
                'muted' => '#b3b3b3',
                'accent' => '#e50914',
                'accent_text' => '#ffffff',
                'badge_bg' => '#e50914',
                'badge_text' => '#ffffff',
                'highlight' => '#e50914',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 52,
                'body_size' => 15,
            ],
            'radius' => 4,
            'border_width' => 0,
            'shadow' => 'lg',
        ],
    ],

    'pro_shopify' => [
        'id' => 'pro_shopify',
        'name' => 'Shopify Green',
        'group' => 'modern',
        'is_pro' => true,
        'preview_image' => 'shopify.svg',
        'description' => 'E-commerce friendly green',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e1e3e5',
                'text' => '#202223',
                'muted' => '#6d7175',
                'accent' => '#008060',
                'accent_text' => '#ffffff',
                'badge_bg' => '#dcf5ed',
                'badge_text' => '#008060',
                'highlight' => '#008060',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 46,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_wix' => [
        'id' => 'pro_wix',
        'name' => 'Wix Yellow',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'wix.svg',
        'description' => 'Creative yellow and black',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#d6dbe1',
                'text' => '#162d3d',
                'muted' => '#577083',
                'accent' => '#faad4d',
                'accent_text' => '#162d3d',
                'badge_bg' => '#faad4d',
                'badge_text' => '#162d3d',
                'highlight' => '#3899ec',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 0,
            'border_width' => 2,
            'shadow' => 'sm',
        ],
    ],

    'pro_squarespace' => [
        'id' => 'pro_squarespace',
        'name' => 'Squarespace Elegant',
        'group' => 'minimal',
        'is_pro' => true,
        'preview_image' => 'squarespace.svg',
        'description' => 'Elegant minimal design',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#000000',
                'text' => '#000000',
                'muted' => '#767676',
                'accent' => '#000000',
                'accent_text' => '#ffffff',
                'badge_bg' => '#000000',
                'badge_text' => '#ffffff',
                'highlight' => '#000000',
            ],
            'typography' => [
                'title_size' => 18,
                'price_size' => 40,
                'body_size' => 14,
            ],
            'radius' => 0,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'pro_mailchimp' => [
        'id' => 'pro_mailchimp',
        'name' => 'Mailchimp Cavendish',
        'group' => 'colorful',
        'is_pro' => true,
        'preview_image' => 'mailchimp.svg',
        'description' => 'Playful yellow design',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#d2cecc',
                'text' => '#241c15',
                'muted' => '#6b6b6b',
                'accent' => '#ffe01b',
                'accent_text' => '#241c15',
                'badge_bg' => '#007c89',
                'badge_text' => '#ffffff',
                'highlight' => '#007c89',
            ],
            'typography' => [
                'title_size' => 24,
                'price_size' => 48,
                'body_size' => 15,
            ],
            'radius' => 16,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_convertkit' => [
        'id' => 'pro_convertkit',
        'name' => 'ConvertKit Coral',
        'group' => 'modern',
        'is_pro' => true,
        'preview_image' => 'convertkit.svg',
        'description' => 'Creator-focused coral theme',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#ffffff',
                'card_border' => '#e6e8eb',
                'text' => '#16181c',
                'muted' => '#677489',
                'accent' => '#fb6970',
                'accent_text' => '#ffffff',
                'badge_bg' => '#fff1f2',
                'badge_text' => '#fb6970',
                'highlight' => '#fb6970',
            ],
            'typography' => [
                'title_size' => 22,
                'price_size' => 48,
                'body_size' => 15,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'sm',
        ],
    ],

    'pro_supabase' => [
        'id' => 'pro_supabase',
        'name' => 'Supabase Green',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'supabase.svg',
        'description' => 'Developer-focused dark green',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#1c1c1c',
                'card_border' => '#2e2e2e',
                'text' => '#ededed',
                'muted' => '#8f8f8f',
                'accent' => '#3ecf8e',
                'accent_text' => '#000000',
                'badge_bg' => '#3ecf8e',
                'badge_text' => '#000000',
                'highlight' => '#3ecf8e',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 46,
                'body_size' => 14,
            ],
            'radius' => 8,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],

    'pro_planetscale' => [
        'id' => 'pro_planetscale',
        'name' => 'PlanetScale Yellow',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'planetscale.svg',
        'description' => 'Dark with yellow accent',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#000000',
                'card_border' => '#222222',
                'text' => '#ffffff',
                'muted' => '#999999',
                'accent' => '#f8cd05',
                'accent_text' => '#000000',
                'badge_bg' => '#f8cd05',
                'badge_text' => '#000000',
                'highlight' => '#f8cd05',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 48,
                'body_size' => 14,
            ],
            'radius' => 12,
            'border_width' => 1,
            'shadow' => 'none',
        ],
    ],

    'pro_railway' => [
        'id' => 'pro_railway',
        'name' => 'Railway Purple',
        'group' => 'dark',
        'is_pro' => true,
        'preview_image' => 'railway.svg',
        'description' => 'Modern purple dark theme',
        'tokens' => [
            'colors' => [
                'bg' => 'transparent',
                'card_bg' => '#13111c',
                'card_border' => '#2e2844',
                'text' => '#e8e4f4',
                'muted' => '#9187a4',
                'accent' => '#6f4ff2',
                'accent_text' => '#ffffff',
                'badge_bg' => '#6f4ff2',
                'badge_text' => '#ffffff',
                'highlight' => '#6f4ff2',
            ],
            'typography' => [
                'title_size' => 20,
                'price_size' => 46,
                'body_size' => 14,
            ],
            'radius' => 10,
            'border_width' => 1,
            'shadow' => 'md',
        ],
    ],
];

// Filter pro presets if not premium
if (!$is_premium) {
    foreach ($presets as $key => $preset) {
        if (!empty($preset['is_pro'])) {
            $presets[$key]['disabled'] = true;
        }
    }
}

return $presets;
