<?php

namespace King_Addons;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class ModulesMap
{
    public static function getModulesMapArray(): array
    {
        return [
            'widgets' => [
                'holographic-card' => [
                    'title' => esc_html__('3D Holographic Card', 'king-addons'),
                    'description' => esc_html__('Interactive 3D card with holographic film overlay, rim glow, and parallax effects. Features smooth pointer tracking with lerp animation for stunning visual depth.', 'king-addons'),
                    'php-class' => 'Holographic_Card',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/3d-holographic-card/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'creative',
                    'has-pro' => true,
                ],
                'styled-text-builder' => [
                    'title' => esc_html__('Styled Text Builder', 'king-addons'),
                    'description' => esc_html__('Enables the creation of uniquely styled and animated text elements, offering extensive customization options for impactful and visually captivating web typography. Allows combining different styles in one text paragraph.', 'king-addons'),
                    'php-class' => 'Styled_Text_Builder',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/styled-text-builder/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'image-hotspots' => [
                    'title' => esc_html__('Image Hotspots', 'king-addons'),
                    'description' => esc_html__('Module for Elementor to create interactive, clickable areas on images, ideal for displaying information or links in a dynamic, visually engaging way. Uses only CSS, not any JS.', 'king-addons'),
                    'php-class' => 'Image_Hotspots',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/image-hotspots/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'one-page-navigation' => [
                    'title' => esc_html__('One Page Navigation', 'king-addons'),
                    'description' => esc_html__('Facilitates seamless navigation within a single page, using anchor links to smoothly scroll to different sections, enhancing user experience and site organization. Uses only CSS, not any JS.', 'king-addons'),
                    'php-class' => 'One_Page_Navigation',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/one-page-navigation/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'navigation',
                ],
                'off-canvas-content' => [
                    'title' => esc_html__('Off-Canvas Content', 'king-addons'),
                    'description' => esc_html__('Allows the creation of hidden (offcanvas), slide-in panels on websites, ideal for menus, widgets, or additional content, accessible with a simple user interaction.', 'king-addons'),
                    'php-class' => 'Off_Canvas_Content',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/off-canvas-content/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'image-comparison' => [
                    'title' => esc_html__('Image Comparison', 'king-addons'),
                    'description' => esc_html__('Also known as Before & After, the widget offers an interactive tool to visually contrast two images side-by-side with a draggable slider, perfect for before-and-after views, product comparisons, or design showcases.', 'king-addons'),
                    'php-class' => 'Image_Comparison',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/image-comparison/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'vertical-scrollable-image' => [
                    'title' => esc_html__('Vertical Scrollable Image', 'king-addons'),
                    'description' => esc_html__('Widget allows seamless vertical scrolling on mouse hover over through long images, such as infographics or timelines, on a webpage, enhancing user engagement and storytelling without resizing. Uses only CSS, not any JS.', 'king-addons'),
                    'php-class' => 'Vertical_Scrollable_Image',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/vertical-scrollable-image/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'image-marquee' => [
                    'title' => esc_html__('Image Marquee', 'king-addons'),
                    'description' => esc_html__('Creates endlessly scrolling image ribbons with adjustable direction, speed, and gaps. Perfect for logo strips or visual showcases with optional per-image links and overlays.', 'king-addons'),
                    'php-class' => 'Image_Marquee',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'rotating-image-tiles' => [
                    'title' => esc_html__('Rotating Image Tiles', 'king-addons'),
                    'description' => esc_html__('Animated grid of circular image tiles that rotate through multiple images with smooth transitions. Pro unlocks advanced rotation modes, per-tile masks, delays, and click actions.', 'king-addons'),
                    'php-class' => 'Rotating_Image_Tiles',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'single-product' => [
                    'title' => esc_html__('Single Product', 'king-addons'),
                    'description' => esc_html__('Display a single WooCommerce product with image, price, rating, excerpt, and add-to-cart. Pro adds badges, stock bar, quantity selector, and gallery enhancements.', 'king-addons'),
                    'php-class' => 'Single_Product',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'quick-view-product' => [
                    'title' => esc_html__('Quick View Product', 'king-addons'),
                    'description' => esc_html__('Quick product preview in a modal with image, price, rating, excerpt, and add-to-cart. Pro adds gallery thumbs, variations, sticky CTA, and related options.', 'king-addons'),
                    'php-class' => 'Quick_View_Product',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'quick-product-slider' => [
                    'title' => esc_html__('Quick Product Slider', 'king-addons'),
                    'description' => esc_html__('WooCommerce product slider with image, price, rating, excerpt, and add-to-cart. Pro adds advanced hover animations, nav/dot skins, category filters, and higher limits.', 'king-addons'),
                    'php-class' => 'Quick_Product_Slider',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'quick-product-grid' => [
                    'title' => esc_html__('Quick Product Grid', 'king-addons'),
                    'description' => esc_html__('WooCommerce product grid with image, price, rating, excerpt, and add-to-cart. Pro adds advanced hover animations, category filters, advanced badges, and higher limits.', 'king-addons'),
                    'php-class' => 'Quick_Product_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'facet-taxonomy' => [
                    'title' => esc_html__('Facet Taxonomy', 'king-addons'),
                    'description' => esc_html__('Checkbox-based taxonomy filter bound to a grid by Query ID.', 'king-addons'),
                    'php-class' => 'Facet_Taxonomy',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'other',
                ],
                'facet-price' => [
                    'title' => esc_html__('Facet Price Range', 'king-addons'),
                    'description' => esc_html__('Price range filter for WooCommerce products via Query ID.', 'king-addons'),
                    'php-class' => 'Facet_Price',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'other',
                ],
                'facet-search' => [
                    'title' => esc_html__('Facet Search', 'king-addons'),
                    'description' => esc_html__('Search input that updates linked grids through faceted filters.', 'king-addons'),
                    'php-class' => 'Facet_Search',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'navigation',
                ],
                'facet-reset' => [
                    'title' => esc_html__('Facet Reset', 'king-addons'),
                    'description' => esc_html__('Reset button to clear active filters for a Query ID.', 'king-addons'),
                    'php-class' => 'Facet_Reset',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'other',
                ],
                'facet-active-filters' => [
                    'title' => esc_html__('Facet Active Filters', 'king-addons'),
                    'description' => esc_html__('Displays selected filters and allows quick removal.', 'king-addons'),
                    'php-class' => 'Facet_Active_Filters',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'other',
                ],
                'facet-meta' => [
                    'title' => esc_html__('Facet Meta/ACF', 'king-addons'),
                    'description' => esc_html__('Filter by ACF/custom field with text/select/range controls.', 'king-addons'),
                    'php-class' => 'Facet_Meta',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'other',
                ],
                'compare-table' => [
                    'title' => esc_html__('Compare Products Table', 'king-addons'),
                    'description' => esc_html__('Side-by-side WooCommerce product comparison with price, rating, stock, and add-to-cart. Pro adds category filters, difference highlights, extra attributes, and sticky header.', 'king-addons'),
                    'php-class' => 'Compare_Table',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'comparison-matrix-cards' => [
                    'title' => esc_html__('Comparison Matrix Cards', 'king-addons'),
                    'description' => esc_html__('Card-based comparison matrix for plans or products with per-feature values, badges, and CTA buttons. Pro adds highlight differences, sticky header, dynamic data sources, and filters.', 'king-addons'),
                    'php-class' => 'Comparison_Matrix_Cards',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'promo-bar' => [
                    'title' => esc_html__('Announcement / Promo Bar', 'king-addons'),
                    'description' => esc_html__('Sticky top/bottom promo bar with CTA and close. Pro adds conditions (paths, UTM, schedule), countdown, device targeting, and persistent close.', 'king-addons'),
                    'php-class' => 'Promo_Bar',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'advanced-callout-box' => [
                    'title' => esc_html__('Advanced Callout Box', 'king-addons'),
                    'description' => esc_html__('Callout box for notes, tips, and warnings with icon alignment and CTA. Pro adds collapsible mode, copy button, dynamic content, and presets.', 'king-addons'),
                    'php-class' => 'Advanced_Callout_Box',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'pull-quotes-callouts-builder' => [
                    'title' => esc_html__('Pull Quotes & Callouts Builder', 'king-addons'),
                    'description' => esc_html__('Editorial pull quotes and callouts with presets, typography, and responsive styling. Pro unlocks float layouts, actions (copy/share/link), decorative effects, and reveal animations.', 'king-addons'),
                    'php-class' => 'Pull_Quotes_Callouts_Builder',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'magnetic-buttons' => [
                    'title' => esc_html__('Magnetic Buttons', 'king-addons'),
                    'description' => esc_html__('Magnetic hover effect for a CTA button with adjustable strength, radius, and return speed. Pro adds card/icon modes, advanced curves, and constraints.', 'king-addons'),
                    'php-class' => 'Magnetic_Buttons',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'parallax-depth-cards' => [
                    'title' => esc_html__('Parallax Depth Cards', 'king-addons'),
                    'description' => esc_html__('Interactive cards with tilt and layered parallax for premium micro-interactions. Pro adds advanced layer mapping, dynamic shadow, focus edge, and adaptive performance.', 'king-addons'),
                    'php-class' => 'Parallax_Depth_Cards',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'kinetic-text-hover' => [
                    'title' => esc_html__('Kinetic Text Hover', 'king-addons'),
                    'description' => esc_html__('Premium text hover interactions with kinetic letter movement, chroma shifts, and reveal effects. Pro unlocks variable font axes, magnetic letters, and scroll reveal.', 'king-addons'),
                    'php-class' => 'Kinetic_Text_Hover',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'interactive-gradient-mesh' => [
                    'title' => esc_html__('Interactive Gradient Mesh', 'king-addons'),
                    'description' => esc_html__('Animated gradient mesh background with presets, motion controls, and exportable CSS. Pro adds per-point controls, scroll sync, and advanced fallbacks.', 'king-addons'),
                    'php-class' => 'Interactive_Gradient_Mesh',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'scrollytelling-slides' => [
                    'title' => esc_html__('Scrollytelling Slides', 'king-addons'),
                    'description' => esc_html__('Scroll-driven slides with synced text and media plus progress indicators. Pro adds sticky media, animated transitions, Lottie, and deep linking.', 'king-addons'),
                    'php-class' => 'Scrollytelling_Slides',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'spotlight-reveal' => [
                    'title' => esc_html__('Spotlight Reveal', 'king-addons'),
                    'description' => esc_html__('Reveal hidden content or backgrounds with a spotlight mask that follows the cursor or scrolls through the section. Pro unlocks custom shapes, SVG masks, blur, blend modes, and swipe control.', 'king-addons'),
                    'php-class' => 'Spotlight_Reveal',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'unfold' => [
                    'title' => esc_html__('Unfold', 'king-addons'),
                    'description' => esc_html__('Collapsible content area with fade overlay and toggle button. Pro adds Elementor template source, inside button placement, custom fade height, per-direction animation timing, and scroll-after-unfold.', 'king-addons'),
                    'php-class' => 'Unfold',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'event-calendar' => [
                    'title' => esc_html__('Event Calendar', 'king-addons'),
                    'description' => esc_html__('Responsive event list with date badge, meta, and CTA. Pro adds filters (category/search/date), compact layout, animations, and ongoing highlight.', 'king-addons'),
                    'php-class' => 'Event_Calendar',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'phone-call-button' => [
                    'title' => esc_html__('Phone Call Button', 'king-addons'),
                    'description' => esc_html__('Call-to-action button with tel: link and icon. Pro adds floating, animations, device targeting, and custom icon.', 'king-addons'),
                    'php-class' => 'Phone_Call_Button',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'faq-schema' => [
                    'title' => esc_html__('FAQ Schema', 'king-addons'),
                    'description' => esc_html__('Accordion FAQ with valid schema.org FAQPage JSON-LD. Pro adds single-open, search, toggle-all, custom icons, and animations.', 'king-addons'),
                    'php-class' => 'FAQ_Schema',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'review-schema' => [
                    'title' => esc_html__('Review Schema', 'king-addons'),
                    'description' => esc_html__('Single review with stars and schema.org Review JSON-LD. Pro adds aggregate rating, schema type selection, animations, and device targeting.', 'king-addons'),
                    'php-class' => 'Review_Schema',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'pros-cons-box' => [
                    'title' => esc_html__('Pros and Cons Box', 'king-addons'),
                    'description' => esc_html__('Two-column pros and cons layout with titles, icons, and highlights. Pro adds advanced presets, collapse, tooltips, and review schema output.', 'king-addons'),
                    'php-class' => 'Pros_Cons_Box',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'ajax-add-to-cart' => [
                    'title' => esc_html__('Ajax Add to Cart', 'king-addons'),
                    'description' => esc_html__('WooCommerce add-to-cart button with AJAX request, inline notice, and styling controls. Pro adds icons, quantity selector, fragment refresh toggle, and redirect options.', 'king-addons'),
                    'php-class' => 'Ajax_Add_To_Cart',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'breadcrumbs' => [
                    'title' => esc_html__('Breadcrumbs', 'king-addons'),
                    'description' => esc_html__('Lightweight breadcrumb navigation with customizable separator, alignment, and typography. Pro adds icons, schema, and depth controls.', 'king-addons'),
                    'php-class' => 'Breadcrumbs',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'navigation',
                ],
                'global-section-container' => [
                    'title' => esc_html__('Global Section & Container', 'king-addons'),
                    'description' => esc_html__('Allows designers to create and manage reusable website sections and containers, streamlining design consistency and efficiency across multiple pages. Useful for building Header, Footer, and CTA sections. Does not affect website performance because it uses Elementor built-in functionality. Does not use any CSS or JS.', 'king-addons'),
                    'php-class' => 'Global_Section_Container',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/global-section-container/',
                    'css' => [],
                    'js' => [],
                    'category' => 'content',
                ],
                'card-carousel' => [
                    'title' => esc_html__('Advanced Card Carousel', 'king-addons'),
                    'description' => esc_html__('Create a card carousel, also known as horizontal slider/scroller. Each card has an image, title, subtitle, description and button. Ideal for showcasing content, highlighting features, or presenting services, perfect for team members and testimonials sections. It is fully responsive, and supports both mobile and mouse dragging.', 'king-addons'),
                    'php-class' => 'Card_Carousel',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/card-carousel/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'quick-card-slider' => [
                    'title' => esc_html__('Quick Card Slider', 'king-addons'),
                    'description' => esc_html__('A clean, responsive slider for showcasing custom cards with images, text, and buttons. Includes navigation and pagination with safe spacing defaults, plus premium badges, animations, and additional navigation styles.', 'king-addons'),
                    'php-class' => 'Quick_Card_Slider',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'quick-post-slider' => [
                    'title' => esc_html__('Quick Post Slider', 'king-addons'),
                    'description' => esc_html__('A responsive slider for WordPress posts with easy defaults, navigation, and pagination spacing that avoids overlap. Premium adds advanced skins and effects.', 'king-addons'),
                    'php-class' => 'Quick_Post_Slider',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'quick-post-grid' => [
                    'title' => esc_html__('Quick Post Grid', 'king-addons'),
                    'description' => esc_html__('A lightweight grid for WordPress posts with responsive columns and safe spacing defaults. Premium adds advanced styles and animations.', 'king-addons'),
                    'php-class' => 'Quick_Post_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'custom-post-types-slider' => [
                    'title' => esc_html__('Custom Post Types Slider', 'king-addons'),
                    'description' => esc_html__('Slide any post type with featured image, meta, and excerpts. Pro unlocks advanced queries and custom field output inside slides.', 'king-addons'),
                    'php-class' => 'Custom_Post_Types_Slider',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'custom-post-types-grid' => [
                    'title' => esc_html__('Custom Post Types Grid', 'king-addons'),
                    'description' => esc_html__('Display any post type in a responsive grid with images, meta, and excerpts. Pro adds advanced queries and custom field output.', 'king-addons'),
                    'php-class' => 'Custom_Post_Types_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'quick-card-grid' => [
                    'title' => esc_html__('Quick Card Grid', 'king-addons'),
                    'description' => esc_html__('A custom content grid for images, titles, and buttons with responsive columns. Premium adds advanced styles and animations.', 'king-addons'),
                    'php-class' => 'Quick_Card_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'liquid-glass-cards' => [
                    'title' => esc_html__('Liquid Glass Cards', 'king-addons'),
                    'description' => esc_html__('Create liquid glass cards with blur, noise, and optional tilt or parallax interactions.', 'king-addons'),
                    'php-class' => 'Liquid_Glass_Cards',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'creative',
                ],
                'auto-scrolling-text' => [
                    'title' => esc_html__('Auto-Scrolling Text', 'king-addons'),
                    'description' => esc_html__('An engaging text marquee for dynamic, continuously scrolling text sections. Ideal for announcements, news tickers, or any content you want in constant motion. Customize the style with various effects, and add images to enhance your design. Uses only CSS for animation.', 'king-addons'),
                    'php-class' => 'Auto_Scrolling_Text',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/auto-scrolling-text/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'creative',
                ],
                'popup' => [
                    'title' => esc_html__('Popup & Lightbox Modal', 'king-addons'),
                    'description' => esc_html__('A versatile tool for creating engaging popups and lightbox modals. Perfect for displaying important messages, promotions, or multimedia content. Customize the appearance and behavior with various effects, and easily add images, videos, and other elements to capture your audience attention.', 'king-addons'),
                    'php-class' => 'Popup',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/popup-lightbox-modal/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'video-popup' => [
                    'title' => esc_html__('Video Popup', 'king-addons'),
                    'description' => esc_html__('A powerful tool for creating engaging video popups. Ideal for showcasing promotional videos, tutorials, or any multimedia content. Customize the appearance and behavior with various effects, and easily integrate videos to capture your audience attention.', 'king-addons'),
                    'php-class' => 'Video_Popup',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/video-popup/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'blog-posts' => [
                    'title' => esc_html__('Advanced Blog Posts Carousel', 'king-addons'),
                    'description' => esc_html__('A dynamic tool for showcasing blog posts in an engaging carousel format. Perfect for highlighting featured articles, news, and updates. Customize the layout, style, and transition effects to create an eye-catching display that enhances your website design and attracts readers.', 'king-addons'),
                    'php-class' => 'Blog_Posts',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/blog-posts-carousel/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'dynamic-posts-grid' => [
                    'title' => esc_html__('Dynamic Posts Grid', 'king-addons'),
                    'description' => esc_html__('Create dynamic, filterable grids of posts with AJAX search and load more functionality. Features color-coded post types, responsive design, and smooth animations. Perfect for resource centers, portfolios, and content libraries with advanced filtering capabilities.', 'king-addons'),
                    'php-class' => 'Dynamic_Posts_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'business-hours' => [
                    'title' => esc_html__('Business Hours', 'king-addons'),
                    'description' => esc_html__('Display your business hours, also known as opening hours or working hours, clearly and attractively. Customize the layout and style to match your website design, ensuring your customers always know when you are open. Perfect for restaurants, shops, and any business that wants to communicate their hours effectively.', 'king-addons'),
                    'php-class' => 'Business_Hours',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/business-hours/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'price-list' => [
                    'title' => esc_html__('Price List & Menu', 'king-addons'),
                    'description' => esc_html__('Showcase your price list and menu items clearly and stylishly. Perfect for restaurants, cafes, and any business offering a range of products or services. Customize the layout and style to fit your brand, ensuring your offerings are presented in an appealing and organized manner.', 'king-addons'),
                    'php-class' => 'Price_List',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/price-list-menu/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'image-hover-box' => [
                    'title' => esc_html__('Image Hover Box', 'king-addons'),
                    'description' => esc_html__('Create interactive image elements with engaging hover effects. Ideal for showcasing services, products, or portfolio items. Customize the hover effects, layout, and style to enhance your website visual appeal and provide an interactive user experience.', 'king-addons'),
                    'php-class' => 'Image_Hover_Box',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/image-hover-box/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'reading-progress-bar' => [
                    'title' => esc_html__('Reading Progress Bar', 'king-addons'),
                    'description' => esc_html__('Enhance user engagement with a dynamic reading progress bar. Ideal for blogs, articles, and long-form content. Customize the style, position, and behavior to match your website design and provide readers with a visual cue of their progress.', 'king-addons'),
                    'php-class' => 'Reading_Progress_Bar',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/reading-progress-bar/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'pulsing-button' => [
                    'title' => esc_html__('Pulsing Button', 'king-addons'),
                    'description' => esc_html__('Boost interactivity with an engaging call-to-action (CTA) animated button. Ideal for driving clicks, sign-ups, or purchases. Customize animation effects, colors, and styles to match your brand and catch visitors attention. Perfect for increasing conversions.', 'king-addons'),
                    'php-class' => 'Pulsing_Button',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/pulsing-button/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'creative-button' => [
                    'title' => esc_html__('Creative Button', 'king-addons'),
                    'description' => esc_html__('Add a touch of creativity to your website. Perfect for unique and eye-catching call-to-actions. Customize shapes, colors, and effects to align with your brand and capture visitor attention. Ideal for enhancing user engagement and driving interactions.', 'king-addons'),
                    'php-class' => 'Creative_Button',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/creative-button/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'hovering-image-stack' => [
                    'title' => esc_html__('Hovering Image Stack', 'king-addons'),
                    'description' => esc_html__('Create visually appealing image stacks to showcase multiple images in a layered format. Perfect for portfolios, product displays, or galleries. Customize the stack style, spacing, and effects to match your website design and provide a unique visual experience for your visitors.', 'king-addons'),
                    'php-class' => 'Hovering_Image_Stack',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/hovering-image-stack/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'content-flip-box' => [
                    'title' => esc_html__('Content Hover & Flip Box', 'king-addons'),
                    'description' => esc_html__('Showcase interactive content. This versatile tool includes various hover effects and also has the Flip Box effect for enhanced engagement. Perfect for highlighting features, services, or promotions in a visually appealing way. Customize the layout, colors, and effects to match your website design.', 'king-addons'),
                    'php-class' => 'Content_Flip_Box',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/content-hover-flip-box/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'flip-countdown' => [
                    'title' => esc_html__('Flip Countdown & Timer', 'king-addons'),
                    'description' => esc_html__('Add dynamic urgency to your events or promotions. This tool features a unique flipping animation, perfect for time-limited offers, upcoming launches, or important dates. Customize the design, format, and style to match your website, ensuring it captures visitors attention and encourages action.', 'king-addons'),
                    'php-class' => 'Flip_Countdown',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/flip-countdown-timer/',
                    'css' => [],
                    'js' => [],
                    'category' => 'content',
                ],
                'smooth-counter' => [
                    'title' => esc_html__('Smooth Counter', 'king-addons'),
                    'description' => esc_html__('Showcase your statistics or milestones. Featuring seamless animations, this tool is perfect for displaying numbers, achievements, or progress in an engaging way. Customize the design, animation speed, and style to match your website, ensuring it draws visitors attention and enhances your content.', 'king-addons'),
                    'php-class' => 'Smooth_Counter',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/smooth-counter/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'testimonial' => [
                    'title' => esc_html__('Testimonial & Review', 'king-addons'),
                    'description' => esc_html__('Build trust and credibility. Perfect for showcasing customer reviews, feedback, or client success stories. Customize the layout, design, and style to fit your brand, ensuring that positive experiences stand out and resonate with your audience.', 'king-addons'),
                    'php-class' => 'Testimonial',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/testimonial-review/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'testimonials-wall' => [
                    'title' => esc_html__('Testimonials Wall', 'king-addons'),
                    'description' => esc_html__('Showcase many testimonials at once in a masonry wall with filters and load more, ideal for modern landing pages and case studies.', 'king-addons'),
                    'php-class' => 'Testimonials_Wall',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'testimonial-carousel' => [
                    'title' => esc_html__('Testimonial & Review Carousel', 'king-addons'),
                    'description' => esc_html__('Display customer feedback and reviews dynamically. Ideal for showcasing client testimonials, ratings, or success stories in a sliding format. Customize the layout, transition effects, and style to match your brand, making positive experiences stand out and engage your audience effectively.', 'king-addons'),
                    'php-class' => 'Testimonial_Carousel',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/testimonial-review-carousel/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'feature-list' => [
                    'title' => esc_html__('Feature List', 'king-addons'),
                    'description' => esc_html__('Showcase key features or benefits. Perfect for highlighting product or service advantages in an organized and visually appealing format. Each list item can include icons, badges, and descriptions for added emphasis. Customize the layout, style, and icons to match your website design and engage your audience effectively.', 'king-addons'),
                    'php-class' => 'Feature_List',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/feature-list/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'taxonomy-list' => [
                    'title' => esc_html__('Taxonomy List', 'king-addons'),
                    'description' => esc_html__('Display a structured list of taxonomies, such as categories or tags. Perfect for organizing content and improving navigation on your website. Customize the layout, style, and hierarchy to match your design and help visitors easily explore related topics or sections.', 'king-addons'),
                    'php-class' => 'Taxonomy_List',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/taxonomy-list/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'page-list' => [
                    'title' => esc_html__('Page List & Menu', 'king-addons'),
                    'description' => esc_html__('Display a structured list of pages, such as categories or tags. Perfect for organizing content and improving navigation on your website. Customize the layout, style, and hierarchy to match your design and help visitors easily explore related topics or sections.', 'king-addons'),
                    'php-class' => 'Page_List',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/page-list/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'search' => [
                    'title' => esc_html__('Search (AJAX, live results, filters)', 'king-addons'),
                    'description' => esc_html__('Enhance your website with the search widget for fast and dynamic search functionality. Display instant results as users type, improving user experience and navigation. Customize the layout, style, and filters to match your website design, making it easier for visitors to find content quickly and efficiently.', 'king-addons'),
                    'php-class' => 'Search',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/ajax-search/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'navigation',
                ],
                'progress-bar' => [
                    'title' => esc_html__('Progress Bar', 'king-addons'),
                    'description' => esc_html__('Highlight progress, goals, or achievements with a fully customizable design. Perfect for showcasing skills, project statuses, or performance metrics in a visually appealing way.', 'king-addons'),
                    'php-class' => 'Progress_Bar',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/progress-bar/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'team-member' => [
                    'title' => esc_html__('Team Member', 'king-addons'),
                    'description' => esc_html__('Highlight your team members with names, roles, photos, and social media links. Perfect for corporate websites, agencies, or portfolios, it offers fully customizable layouts to match your design and responsive features for any device.', 'king-addons'),
                    'php-class' => 'Team_Member',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/team-member/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'team-member-slider' => [
                    'title' => esc_html__('Team Members Slider', 'king-addons'),
                    'description' => esc_html__('Display multiple team members in a carousel/slider format. Showcase staff photos, names, roles, bios, and social links in a sleek, responsive slider for improved engagement and navigation.', 'king-addons'),
                    'php-class' => 'Team_Member_Slider',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'media',
                ],
                // 'filterable-image-gallery' => [
                //     'title'       => esc_html__('Filterable Image Gallery', 'king-addons'),
                //     'description' => esc_html__('A versatile gallery with filter buttons and optional lightbox.', 'king-addons'),
                //     'php-class'   => 'Filterable_Image_Gallery',
                //     'docs-link'   => '',
                //     'demo-link'   => '',
                //     'css'         => ['style'],
                //     'js'          => ['script'],
                // ],
                'share-buttons' => [
                    'title' => esc_html__('Share Buttons', 'king-addons'),
                    'description' => esc_html__('Add stylish and customizable share buttons to your website to boost social media engagement. Perfect for blogs, articles, and product pages, it supports various platforms and responsive designs to ensure seamless sharing across all devices.', 'king-addons'),
                    'php-class' => 'Share_Buttons',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/share-buttons/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'pricing-table' => [
                    'title' => esc_html__('Pricing Table', 'king-addons'),
                    'description' => esc_html__('Showcase pricing plans with customizable layouts and feature comparisons. Perfect for highlighting offers or services, it ensures a responsive and visually appealing design to match your website.', 'king-addons'),
                    'php-class' => 'Pricing_Table',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/pricing-table/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'charts' => [
                    'title' => esc_html__('Charts', 'king-addons'),
                    'description' => esc_html__('Visualize data effectively. Create bar, line, pie, or radar charts with customizable styles and responsive layouts. Perfect for dashboards, reports, or data-driven content.', 'king-addons'),
                    'php-class' => 'Charts',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/charts/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'kpi-tiles-microcharts' => [
                    'title' => esc_html__('KPI Tiles with Microcharts', 'king-addons'),
                    'description' => esc_html__('Display KPI tiles with deltas, trend arrows, and sparklines for dashboards, reports, and landing pages.', 'king-addons'),
                    'php-class' => 'KPI_Tiles_Microcharts',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'posts-grid' => [
                    'title' => esc_html__('Posts Grid & Slider', 'king-addons'),
                    'description' => esc_html__('Display posts in grids, sliders, or carousels with fully customizable layouts. Perfect for showcasing blog content, news, or articles in a responsive and visually appealing format.', 'king-addons'),
                    'php-class' => 'Posts_Grid',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/posts-grid-slider-carousel/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'content',
                ],
                'woocommerce-grid' => [
                    'title' => esc_html__('WooCommerce Grid & Slider', 'king-addons'),
                    'description' => esc_html__('Showcase WooCommerce products in grids, sliders, or carousels with customizable styles. Ideal for creating responsive, engaging product displays for online stores.', 'king-addons'),
                    'php-class' => 'WooCommerce_Grid',
                    'has-pro' => true,
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/woocommerce-grid/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'woocommerce',
                ],
                'image-grid' => [
                    'title' => esc_html__('Image Grid Light', 'king-addons'),
                    'description' => esc_html__('Create stunning image galleries with masonry and fit rows grid layouts. Perfectly adaptable for both mobile and desktop views. Customize the design to match your website style and showcase your images beautifully.', 'king-addons'),
                    'php-class' => 'Image_Grid',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/image-grid/',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'media-grid' => [
                    'title' => esc_html__('Advanced Image Gallery', 'king-addons'),
                    'description' => esc_html__('Create stunning media galleries with grids, sliders, or carousels. Perfect for showcasing images or videos in a fully customizable and responsive format.', 'king-addons'),
                    'php-class' => 'Media_Grid',
                    'has-pro' => true,
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/media-grid/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'category' => 'media',
                ],
                'magazine-grid' => [
                    'title' => esc_html__('Magazine Grid & Slider', 'king-addons'),
                    'description' => esc_html__('Design magazine-style layouts with grids or sliders to display posts, news, or articles. Ideal for blogs or online publications with responsive and dynamic designs.', 'king-addons'),
                    'php-class' => 'Magazine_Grid',
                    'has-pro' => true,
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/magazine-grid/',
                    'demo-link' => '',
                    'css' => [],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'timeline' => [
                    'title' => esc_html__('Timeline', 'king-addons'),
                    'description' => esc_html__('Display posts or events in a chronological timeline format. Perfect for storytelling, showcasing milestones, or creating visually appealing timelines.', 'king-addons'),
                    'php-class' => 'Timeline',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/timeline/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'steps-process-timeline' => [
                    'title' => esc_html__('Steps Process Timeline', 'king-addons'),
                    'description' => esc_html__('Create clean “How it works” sections with numbered steps, icons, descriptions, and optional CTAs.', 'king-addons'),
                    'php-class' => 'Steps_Process_Timeline',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'interactive-steps-progress' => [
                    'title' => esc_html__('Interactive Steps with Progress', 'king-addons'),
                    'description' => esc_html__('Interactive step-by-step sections with progress markers and expandable details. Pro unlocks horizontal layouts, sticky progress, and deep links.', 'king-addons'),
                    'php-class' => 'Interactive_Steps_Progress',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'reveal-swipe-cards' => [
                    'title' => esc_html__('Reveal Swipe Cards', 'king-addons'),
                    'description' => esc_html__('Card grid with wipe-reveal animation on hover or scroll. Content is hidden by a colored overlay that slides away to reveal the card. Pro adds mask shapes (circle, diagonal, wave), blur edges, touch swipe, and sequence modes.', 'king-addons'),
                    'php-class' => 'Reveal_Swipe_Cards',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'creative',
                ],
                'floating-tags-marquee' => [
                    'title' => esc_html__('Floating Tags Marquee', 'king-addons'),
                    'description' => esc_html__('Infinite scrolling marquee of tags/chips with direction and speed controls. Perfect for trusted by, topics, integrations, and buzzwords sections. Pro adds drag, pause on hover, multi-rows, fade edges, and reduced motion support.', 'king-addons'),
                    'php-class' => 'Floating_Tags_Marquee',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'creative',
                ],
                'interactive-image-sheen' => [
                    'title' => esc_html__('Interactive Image Sheen', 'king-addons'),
                    'description' => esc_html__('Premium silk sheen effect overlay for images and cards. Activates on hover with presets like Silk Soft, Gloss Sharp, and Dual Streak. Pro adds cursor follow, layered sheen (2-3 layers), mask shapes, and mobile fallback.', 'king-addons'),
                    'php-class' => 'Interactive_Image_Sheen',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'creative',
                ],
                'scroll-story-sections' => [
                    'title' => esc_html__('Scroll Story Sections', 'king-addons'),
                    'description' => esc_html__('Build scroll-driven storytelling blocks with step navigation and synced content panels.', 'king-addons'),
                    'php-class' => 'Scroll_Story_Sections',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'slider' => [
                    'title' => esc_html__('Slider/Carousel', 'king-addons'),
                    'description' => esc_html__('Create engaging sliders with images, text, or multimedia. Fully customizable and responsive, it is perfect for hero sections or featured content displays.', 'king-addons'),
                    'php-class' => 'Slider',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/slider/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'media',
                ],
                'form-builder' => [
                    'title' => esc_html__('Form Builder', 'king-addons'),
                    'description' => esc_html__('Build custom forms with ease using the fully customizable Form Builder. Ideal for contact forms, surveys, or lead generation with responsive designs.', 'king-addons'),
                    'php-class' => 'Form_Builder',
                    'has-pro' => true,
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/form-builder/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'forms',
                ],
                'data-table' => [
                    'title' => esc_html__('Data Table', 'king-addons'),
                    'description' => esc_html__('Present data effectively with customizable tables. Perfect for pricing comparisons, schedules, or detailed information in a responsive and user-friendly layout.', 'king-addons'),
                    'php-class' => 'Data_Table',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/data-table/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'table-builder' => [
                    'title' => esc_html__('Table Builder', 'king-addons'),
                    'description' => esc_html__('Insert tables created in the Table Builder with sorting, search, and pagination.', 'king-addons'),
                    'php-class' => 'Table_Builder',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'category' => 'content',
                ],
                'maintenance-page' => [
                    'title' => esc_html__('Maintenance Page', 'king-addons'),
                    'description' => esc_html__('Embed Maintenance Mode templates or selected pages directly in Elementor.', 'king-addons'),
                    'php-class' => 'Maintenance_Page',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'category' => 'content',
                ],
                'content-ticker' => [
                    'title' => esc_html__('Content Ticker', 'king-addons'),
                    'description' => esc_html__('Display scrolling text or updates. Perfect for news, announcements, or dynamic content in a sleek, responsive design.', 'king-addons'),
                    'php-class' => 'Content_Ticker',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/content-ticker/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'content-toggle' => [
                    'title' => esc_html__('Content Toggle', 'king-addons'),
                    'description' => esc_html__('Showcase key information with a two-state switcher that swaps between primary and secondary content to reduce scrolling. Pro adds template sources, external selector toggling, and enhanced animations.', 'king-addons'),
                    'php-class' => 'Content_Toggle',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'mailchimp' => [
                    'title' => esc_html__('MailChimp', 'king-addons'),
                    'description' => esc_html__('Easily integrate MailChimp forms into your website. Perfect for growing your email list with customizable and responsive sign-up forms.', 'king-addons'),
                    'php-class' => 'MailChimp',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/mailchimp/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'forms',
                ],
                'tabs' => [
                    'title' => esc_html__('Tabs', 'king-addons'),
                    'description' => esc_html__('Organize content into tabs for easy navigation and a clean layout. Perfect for FAQs, features, or segmented content in a fully responsive format. The Elementor content to be placed inside.', 'king-addons'),
                    'php-class' => 'Tabs',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/tabs/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'google-maps' => [
                    'title' => esc_html__('Google Maps', 'king-addons'),
                    'description' => esc_html__('Perfect for displaying business locations, contact details, or navigation routes, this widget allows you to adjust styles, markers, and layouts. Ideal for enhancing user experience with responsive and visually appealing map designs.', 'king-addons'),
                    'php-class' => 'Google_Maps',
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/google-maps/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'accordion' => [
                    'title' => esc_html__('Accordion', 'king-addons'),
                    'description' => esc_html__('Present collapsible sections for better content organization. Ideal for FAQs, long articles, or feature breakdowns with customizable and responsive designs. The Elementor content to be placed inside. It also has a search-by-items feature.', 'king-addons'),
                    'php-class' => 'Accordion',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/accordion/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'image-accordion' => [
                    'title' => esc_html__('Image Accordion', 'king-addons'),
                    'description' => esc_html__('Create interactive image accordions for visually dynamic displays. Perfect for portfolios, galleries, or storytelling in a customizable and responsive layout. It has a lightbox feature.', 'king-addons'),
                    'php-class' => 'Image_Accordion',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/image-accordion/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'media',
                ],
                'countdown' => [
                    'title' => esc_html__('Countdown & Timer', 'king-addons'),
                    'description' => esc_html__('Add urgency to your promotions or events. Perfect for sales, launches, or special events in a fully customizable and responsive format.', 'king-addons'),
                    'php-class' => 'Countdown',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/countdown-timer/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'pricing-calculator' => [
                    'title' => esc_html__('Pricing Calculator', 'king-addons'),
                    'description' => esc_html__('Add interactive pricing calculators to your website. Perfect for service-based businesses, product customization, or quote estimations with responsive and customizable layouts.', 'king-addons'),
                    'php-class' => 'Pricing_Calculator',
                    'has-pro' => true,
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/pricing-calculator/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'content',
                ],
                'lottie-animations' => [
                    'title' => esc_html__('Lottie Animations', 'king-addons'),
                    'description' => esc_html__('Add lightweight and scalable animations to your website. Perfect for creating engaging, interactive elements, it supports customization of animation speed, loop settings, and triggers. Enhance user experience with modern, responsive designs.', 'king-addons'),
                    'php-class' => 'Lottie_Animations',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/lottie-animations/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'creative',
                ],
                'pricing-slider' => [
                    'title' => esc_html__('Pricing Slider', 'king-addons'),
                    'description' => esc_html__('Interactive slider for choosing pricing plans, allowing users to dynamically adjust pricing parameters and see matching features. Perfect for subscription-based services, product configurations, or any variable pricing model. Compatible with WooCommerce products.', 'king-addons'),
                    'php-class' => 'Pricing_Slider',
                    'docs-link' => '',
                    //                    'demo-link' => 'https://kingaddons.com/elementor/pricing-slider/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'media',
                ],
                'mega-menu' => [
                    'title' => esc_html__('Mega Menu', 'king-addons'),
                    'description' => esc_html__('Create powerful navigation menus with support for dropdown menus, custom layouts, and responsive design. Perfect for creating professional website headers with both WordPress menus and custom navigation structures.', 'king-addons'),
                    'php-class' => 'Mega_Menu',
                    'docs-link' => '',
                    // 'demo-link' => 'https://kingaddons.com/elementor/mega-menu/',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'navigation',
                ],
                'login-register-form' => [
                    'title' => esc_html__('Login | Register Form', 'king-addons'),
                    'description' => esc_html__('Create beautiful login and registration forms with AJAX submission, form validation, and seamless user experience. Perfect for membership sites, user portals, and customer areas with customizable styling options.', 'king-addons'),
                    'php-class' => 'Login_Register_Form',
                    'docs-link' => '',
                    'demo-link' => '',
                    // 'demo-link' => 'https://kingaddons.com/elementor/login-register-form/',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'forms',
                ],
                // 'test' => [
                //     'title' => esc_html__('Test Title', 'king-addons'),
                //     'description' => esc_html__('Description', 'king-addons'),
                //     'php-class' => 'Test',
                //     'docs-link' => '',
                //     //                    'demo-link' => 'https://kingaddons.com/elementor/test/',
                //     'demo-link' => '',
                //     'css' => ['style'],
                //     'js' => [],
                // ],
                'woo-product-title' => [
                    'title' => esc_html__('Product Title', 'king-addons'),
                    'description' => esc_html__('Displays the WooCommerce product title with layout and style controls for builder templates.', 'king-addons'),
                    'php-class' => 'Woo_Product_Title',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-price' => [
                    'title' => esc_html__('Product Price', 'king-addons'),
                    'description' => esc_html__('Displays WooCommerce product price with optional discount badge formatting.', 'king-addons'),
                    'php-class' => 'Woo_Product_Price',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-sku' => [
                    'title' => esc_html__('Product SKU', 'king-addons'),
                    'description' => esc_html__('Displays product SKU with label and optional fallbacks.', 'king-addons'),
                    'php-class' => 'Woo_Product_SKU',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-rating' => [
                    'title' => esc_html__('Product Rating', 'king-addons'),
                    'description' => esc_html__('Shows product rating stars and optional reviews count/link.', 'king-addons'),
                    'php-class' => 'Woo_Product_Rating',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-stock' => [
                    'title' => esc_html__('Product Stock', 'king-addons'),
                    'description' => esc_html__('Displays product stock status with optional quantity and low-stock messaging.', 'king-addons'),
                    'php-class' => 'Woo_Product_Stock',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-short-description' => [
                    'title' => esc_html__('Product Short Description', 'king-addons'),
                    'description' => esc_html__('Shows WooCommerce short description with optional trim and read more (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Product_Short_Description',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-full-description' => [
                    'title' => esc_html__('Product Full Description', 'king-addons'),
                    'description' => esc_html__('Displays full product description with optional trimming (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Product_Full_Description',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-add-to-cart' => [
                    'title' => esc_html__('Add To Cart', 'king-addons'),
                    'description' => esc_html__('Renders WooCommerce add-to-cart button with quantity and optional AJAX (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Product_Add_To_Cart',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-images-gallery' => [
                    'title' => esc_html__('Product Images Gallery', 'king-addons'),
                    'description' => esc_html__('Displays product main image and gallery with slider/grid layouts.', 'king-addons'),
                    'php-class' => 'Woo_Product_Images_Gallery',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-meta' => [
                    'title' => esc_html__('Product Meta', 'king-addons'),
                    'description' => esc_html__('Shows product categories, tags, and optional brand/SKU.', 'king-addons'),
                    'php-class' => 'Woo_Product_Meta',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-breadcrumbs' => [
                    'title' => esc_html__('Product Breadcrumbs', 'king-addons'),
                    'description' => esc_html__('WooCommerce breadcrumbs with separator and trim options.', 'king-addons'),
                    'php-class' => 'Woo_Product_Breadcrumbs',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-tabs' => [
                    'title' => esc_html__('Product Tabs', 'king-addons'),
                    'description' => esc_html__('Displays product tabs with layout and styling options.', 'king-addons'),
                    'php-class' => 'Woo_Product_Tabs',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-custom-tabs' => [
                    'title' => esc_html__('Product Custom Tabs', 'king-addons'),
                    'description' => esc_html__('Adds custom tabs from text or meta/ACF (Pro for multiple/ACF/meta).', 'king-addons'),
                    'php-class' => 'Woo_Product_Custom_Tabs',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-acf-field' => [
                    'title' => esc_html__('Product ACF / Attribute Field', 'king-addons'),
                    'description' => esc_html__('Outputs a product ACF field or product attribute with optional before/after text and fallback.', 'king-addons'),
                    'php-class' => 'Woo_Product_ACF_Field',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-variations' => [
                    'title' => esc_html__('Product Variations', 'king-addons'),
                    'description' => esc_html__('Variation selectors; swatches and advanced behaviors are Pro.', 'king-addons'),
                    'php-class' => 'Woo_Product_Variations',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-countdown' => [
                    'title' => esc_html__('Product Sale Countdown', 'king-addons'),
                    'description' => esc_html__('Countdown to sale end date with optional custom date and seconds (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Product_Countdown',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-badges' => [
                    'title' => esc_html__('Product Badges', 'king-addons'),
                    'description' => esc_html__('Sale/New badges; Pro adds percent, best seller, custom badges.', 'king-addons'),
                    'php-class' => 'Woo_Product_Badges',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-related' => [
                    'title' => esc_html__('Related Products', 'king-addons'),
                    'description' => esc_html__('Displays related products grid.', 'king-addons'),
                    'php-class' => 'Woo_Product_Related',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-upsell' => [
                    'title' => esc_html__('Upsell Products', 'king-addons'),
                    'description' => esc_html__('Displays upsell products grid.', 'king-addons'),
                    'php-class' => 'Woo_Product_Upsell',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-product-cross-sell' => [
                    'title' => esc_html__('Cross-sell Products', 'king-addons'),
                    'description' => esc_html__('Displays cross-sell products grid.', 'king-addons'),
                    'php-class' => 'Woo_Product_Cross_Sell',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-archive-title' => [
                    'title' => esc_html__('Archive Title', 'king-addons'),
                    'description' => esc_html__('Displays WooCommerce archive title.', 'king-addons'),
                    'php-class' => 'Woo_Archive_Title',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-archive-description' => [
                    'title' => esc_html__('Archive Description', 'king-addons'),
                    'description' => esc_html__('Displays WooCommerce archive description.', 'king-addons'),
                    'php-class' => 'Woo_Archive_Description',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-products-grid' => [
                    'title' => esc_html__('Products Grid', 'king-addons'),
                    'description' => esc_html__('Displays products grid for WooCommerce archives.', 'king-addons'),
                    'php-class' => 'Woo_Products_Grid',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-products-pagination' => [
                    'title' => esc_html__('Products Pagination', 'king-addons'),
                    'description' => esc_html__('Pagination control for product archives.', 'king-addons'),
                    'php-class' => 'Woo_Products_Pagination',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-products-sorting' => [
                    'title' => esc_html__('Products Sorting', 'king-addons'),
                    'description' => esc_html__('Sorting control for product archives.', 'king-addons'),
                    'php-class' => 'Woo_Products_Sorting',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-products-result-count' => [
                    'title' => esc_html__('Products Result Count', 'king-addons'),
                    'description' => esc_html__('Shows product result count on archives.', 'king-addons'),
                    'php-class' => 'Woo_Products_Result_Count',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-cart-table' => [
                    'title' => esc_html__('Cart Table', 'king-addons'),
                    'description' => esc_html__('Displays WooCommerce cart items table with optional totals.', 'king-addons'),
                    'php-class' => 'Woo_Cart_Table',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-cart-totals' => [
                    'title' => esc_html__('Cart Totals', 'king-addons'),
                    'description' => esc_html__('Shows WooCommerce cart totals section.', 'king-addons'),
                    'php-class' => 'Woo_Cart_Totals',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-cart-cross-sells' => [
                    'title' => esc_html__('Cart Cross-sells', 'king-addons'),
                    'description' => esc_html__('Displays cross-sell products on cart page.', 'king-addons'),
                    'php-class' => 'Woo_Cart_Cross_Sells',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-archive-banner' => [
                    'title' => esc_html__('Archive Banner', 'king-addons'),
                    'description' => esc_html__('Banner for shop/category archives with image, title, description.', 'king-addons'),
                    'php-class' => 'Woo_Archive_Banner',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-form' => [
                    'title' => esc_html__('Checkout Form', 'king-addons'),
                    'description' => esc_html__('Renders the WooCommerce checkout form with optional login/coupon/order-notes toggles.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Form',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-order-summary' => [
                    'title' => esc_html__('Checkout Order Summary', 'king-addons'),
                    'description' => esc_html__('Displays checkout order review; Pro can make it sticky.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Order_Summary',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-payment' => [
                    'title' => esc_html__('Checkout Payment', 'king-addons'),
                    'description' => esc_html__('Shows checkout payment methods and place order area.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Payment',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-place-order' => [
                    'title' => esc_html__('Checkout Place Order Button', 'king-addons'),
                    'description' => esc_html__('Standalone place order button for checkout.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Place_Order',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-coupon' => [
                    'title' => esc_html__('Checkout Coupon', 'king-addons'),
                    'description' => esc_html__('Displays the coupon form on checkout.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Coupon',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-login' => [
                    'title' => esc_html__('Checkout Login', 'king-addons'),
                    'description' => esc_html__('Shows returning customer login prompt on checkout.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Login',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-progress' => [
                    'title' => esc_html__('Checkout Progress', 'king-addons'),
                    'description' => esc_html__('Progress indicator for cart/checkout/complete; Pro adds steps layout.', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Progress',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-navigation' => [
                    'title' => esc_html__('My Account Navigation', 'king-addons'),
                    'description' => esc_html__('Displays WooCommerce My Account navigation menu.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Navigation',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-content' => [
                    'title' => esc_html__('My Account Content', 'king-addons'),
                    'description' => esc_html__('Outputs My Account endpoint content.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Content',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-orders' => [
                    'title' => esc_html__('My Account Orders', 'king-addons'),
                    'description' => esc_html__('Lists customer orders with pagination.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Orders',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-downloads' => [
                    'title' => esc_html__('My Account Downloads', 'king-addons'),
                    'description' => esc_html__('Shows customer downloadable products.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Downloads',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-address' => [
                    'title' => esc_html__('My Account Address', 'king-addons'),
                    'description' => esc_html__('Allows customer to view/edit billing/shipping addresses.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Address',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-details' => [
                    'title' => esc_html__('My Account Details', 'king-addons'),
                    'description' => esc_html__('Account details form (name, email, password).', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Details',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-dashboard' => [
                    'title' => esc_html__('My Account Dashboard', 'king-addons'),
                    'description' => esc_html__('Outputs WooCommerce My Account dashboard area.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Dashboard',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-order-details' => [
                    'title' => esc_html__('My Account Order Details', 'king-addons'),
                    'description' => esc_html__('Displays order view in My Account when an order is selected.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Order_Details',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-logout' => [
                    'title' => esc_html__('My Account Logout', 'king-addons'),
                    'description' => esc_html__('Shows a logout button/link for My Account.', 'king-addons'),
                    'php-class' => 'Woo_My_Account_Logout',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-my-account-acf-fields' => [
                    'title' => esc_html__('My Account ACF Extra Fields', 'king-addons'),
                    'description' => esc_html__('Adds extra ACF fields for My Account endpoints (Pro).', 'king-addons'),
                    'php-class' => 'Woo_My_Account_ACF_Fields',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-steps' => [
                    'title' => esc_html__('Checkout Steps (Multi-step)', 'king-addons'),
                    'description' => esc_html__('Multi-step indicator for checkout (Pro for live steps).', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Steps',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-sticky-sidebar' => [
                    'title' => esc_html__('Checkout Sticky Sidebar', 'king-addons'),
                    'description' => esc_html__('Sticky order summary for checkout (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Checkout_Sticky_Sidebar',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-checkout-acf-fields' => [
                    'title' => esc_html__('Checkout ACF Extra Fields', 'king-addons'),
                    'description' => esc_html__('Adds ACF-driven extra fields to checkout (Pro).', 'king-addons'),
                    'php-class' => 'Woo_Checkout_ACF_Fields',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woo-cart-coupon-form' => [
                    'title' => esc_html__('Cart Coupon Form', 'king-addons'),
                    'description' => esc_html__('Shows the cart coupon entry form.', 'king-addons'),
                    'php-class' => 'Woo_Cart_Coupon_Form',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-cart-empty' => [
                    'title' => esc_html__('Cart Empty Message', 'king-addons'),
                    'description' => esc_html__('Displays empty cart notice and return to shop button.', 'king-addons'),
                    'php-class' => 'Woo_Cart_Empty',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                // WooCommerce Shortcode Wrapper Widgets
                'woo-shortcode-cart' => [
                    'title' => esc_html__('WC Cart (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders the standard WooCommerce cart page using the [woocommerce_cart] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Cart',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-checkout' => [
                    'title' => esc_html__('WC Checkout (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders the standard WooCommerce checkout page using the [woocommerce_checkout] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Checkout',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-my-account' => [
                    'title' => esc_html__('WC My Account (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders the standard WooCommerce My Account page using the [woocommerce_my_account] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_My_Account',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-products' => [
                    'title' => esc_html__('WC Products (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders WooCommerce products using standard shortcodes with configurable query options.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Products',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-order-tracking' => [
                    'title' => esc_html__('WC Order Tracking (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders the standard WooCommerce order tracking form using the [woocommerce_order_tracking] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Order_Tracking',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-product-page' => [
                    'title' => esc_html__('WC Product Page (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders a full single product page by ID or SKU using the [product_page] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Product_Page',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-product-category' => [
                    'title' => esc_html__('WC Product Category (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders products from a specific category using the [product_category] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Product_Category',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-product-categories' => [
                    'title' => esc_html__('WC Product Categories (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders product categories grid using the [product_categories] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Product_Categories',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-add-to-cart' => [
                    'title' => esc_html__('WC Add To Cart Button (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders an add-to-cart button for a specific product using the [add_to_cart] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Add_To_Cart',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'woo-shortcode-shop-messages' => [
                    'title' => esc_html__('WC Shop Messages (Shortcode)', 'king-addons'),
                    'description' => esc_html__('Renders WooCommerce shop messages and notices using the [shop_messages] shortcode.', 'king-addons'),
                    'php-class' => 'Woo_Shortcode_Shop_Messages',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => false,
                    'category' => 'woocommerce',
                ],
                'tb-post-title' => [
                    'title' => esc_html__('TB - Post Title', 'king-addons'),
                    'description' => esc_html__('Displays current post title with tag and link options; Pro adds truncation and hover underline.', 'king-addons'),
                    'php-class' => 'TB_Post_Title',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-content' => [
                    'title' => esc_html__('TB - Post Content', 'king-addons'),
                    'description' => esc_html__('Outputs current post content with base styling; Pro adds block exclusions and advanced typography.', 'king-addons'),
                    'php-class' => 'TB_Post_Content',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-excerpt' => [
                    'title' => esc_html__('TB - Post Excerpt', 'king-addons'),
                    'description' => esc_html__('Shows post excerpt with length and suffix controls; Pro adds character trim and HTML stripping.', 'king-addons'),
                    'php-class' => 'TB_Post_Excerpt',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-featured-image' => [
                    'title' => esc_html__('TB - Featured Image', 'king-addons'),
                    'description' => esc_html__('Displays featured image with size and link choices; Pro adds fallback, aspect ratio, and overlay hovers.', 'king-addons'),
                    'php-class' => 'TB_Featured_Image',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-meta' => [
                    'title' => esc_html__('TB - Post Meta', 'king-addons'),
                    'description' => esc_html__('Shows date, author, and taxonomy meta with layout and order controls; Pro adds reading time, icons, and badges.', 'king-addons'),
                    'php-class' => 'TB_Post_Meta',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-taxonomies' => [
                    'title' => esc_html__('TB - Post Taxonomies', 'king-addons'),
                    'description' => esc_html__('Lists post categories or tags with label and separator options; Pro adds custom taxonomies, badges, and placeholders.', 'king-addons'),
                    'php-class' => 'TB_Post_Taxonomies',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-author-box' => [
                    'title' => esc_html__('TB - Author Box', 'king-addons'),
                    'description' => esc_html__('Author avatar, name, and bio layouts; Pro adds social icons and custom link options.', 'king-addons'),
                    'php-class' => 'TB_Author_Box',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-navigation' => [
                    'title' => esc_html__('TB - Post Navigation', 'king-addons'),
                    'description' => esc_html__('Previous/next post navigation with labels and titles; Pro adds same-term restriction and icon styles.', 'king-addons'),
                    'php-class' => 'TB_Post_Navigation',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-post-comments' => [
                    'title' => esc_html__('TB - Post Comments', 'king-addons'),
                    'description' => esc_html__('Wraps comments list and form with visibility toggles; Pro adds custom empty text and order controls.', 'king-addons'),
                    'php-class' => 'TB_Post_Comments',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-related-posts' => [
                    'title' => esc_html__('TB - Related Posts', 'king-addons'),
                    'description' => esc_html__('Shows related posts by category with layout controls; Pro adds tag/custom taxonomy sources, fallbacks, and ordering options.', 'king-addons'),
                    'php-class' => 'TB_Related_Posts',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-archive-title' => [
                    'title' => esc_html__('TB - Archive Title', 'king-addons'),
                    'description' => esc_html__('Shows current archive title with prefix handling; Pro adds custom prefixes per archive type.', 'king-addons'),
                    'php-class' => 'TB_Archive_Title',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-archive-description' => [
                    'title' => esc_html__('TB - Archive Description', 'king-addons'),
                    'description' => esc_html__('Displays archive or author description with fallback; Pro adds trimming and placeholders.', 'king-addons'),
                    'php-class' => 'TB_Archive_Description',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-archive-posts' => [
                    'title' => esc_html__('TB - Archive Posts', 'king-addons'),
                    'description' => esc_html__('Renders current archive or search query in grid or list layouts; Pro adds card presets and built-in pagination.', 'king-addons'),
                    'php-class' => 'TB_Archive_Posts',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-archive-pagination' => [
                    'title' => esc_html__('TB - Archive Pagination', 'king-addons'),
                    'description' => esc_html__('Pagination for the current archive with label controls; Pro adds first/last links and extra skins.', 'king-addons'),
                    'php-class' => 'TB_Archive_Pagination',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-archive-result-count' => [
                    'title' => esc_html__('TB - Archive Result Count', 'king-addons'),
                    'description' => esc_html__('Shows result count range for the current query; Pro adds custom format templates.', 'king-addons'),
                    'php-class' => 'TB_Archive_Result_Count',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-404-title' => [
                    'title' => esc_html__('TB - 404 Title', 'king-addons'),
                    'description' => esc_html__('Customizable 404 page title with alignment and spacing controls; Pro adds style presets.', 'king-addons'),
                    'php-class' => 'TB_404_Title',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-404-description' => [
                    'title' => esc_html__('TB - 404 Description', 'king-addons'),
                    'description' => esc_html__('Description text for 404 templates with typography controls; Pro adds preset messages.', 'king-addons'),
                    'php-class' => 'TB_404_Description',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-404-search-form' => [
                    'title' => esc_html__('TB - 404 Search Form', 'king-addons'),
                    'description' => esc_html__('Styled search form for 404 and utility layouts; Pro adds icon and post type filters.', 'king-addons'),
                    'php-class' => 'TB_404_Search_Form',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],
                'tb-back-to-home' => [
                    'title' => esc_html__('TB - Back to Home', 'king-addons'),
                    'description' => esc_html__('Button linking to home with styling controls; Pro adds custom URL and icon/hover options.', 'king-addons'),
                    'php-class' => 'TB_Back_To_Home',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'theme-builder',
                ],

                // Widgets that were previously (incorrectly) listed under 'features'.
                'product-360-viewer' => [
                    'title' => esc_html__('360° Product Viewer', 'king-addons'),
                    'description' => esc_html__('Show a 360° product spin using a frame sequence with drag, autoplay, and zoom. Pro adds unlimited frames, advanced drag/scroll/inertia controls, and frame-specific hotspots.', 'king-addons'),
                    'php-class' => 'Product_360_Viewer',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'sticky-contact-bar' => [
                    'title' => esc_html__('Sticky Contact Bar', 'king-addons'),
                    'description' => esc_html__('Sticky multi-channel contact bar (WhatsApp/Telegram/Messenger and more). Pro adds schedule-based states, UTM-aware availability, and advanced per-channel visibility rules.', 'king-addons'),
                    'php-class' => 'Sticky_Contact_Bar',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'cookie-preferences-button' => [
                    'title' => esc_html__('Cookie Preferences Button', 'king-addons'),
                    'description' => esc_html__('Adds a manage-consent button that opens the Cookie / Consent Bar settings modal so visitors can review or change their choices.', 'king-addons'),
                    'php-class' => 'Cookie_Preferences_Button',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'content',
                ],
                'sticky-video' => [
                    'title' => esc_html__('Sticky Video', 'king-addons'),
                    'description' => esc_html__('Display a floating mini video player for YouTube, Vimeo, or self-hosted sources with optional close control and sticky positioning. Pro adds top placements, reveal triggers, persistence, device targeting, and CTA button.', 'king-addons'),
                    'php-class' => 'Sticky_Video',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'category' => 'media',
                ],
                'wishlist-button' => [
                    'title' => esc_html__('Wishlist Button', 'king-addons'),
                    'description' => esc_html__('Add or remove products from a wishlist with customizable text, icons, and WooCommerce hook positions.', 'king-addons'),
                    'php-class' => 'Wishlist_Button',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-counter' => [
                    'title' => esc_html__('Wishlist Counter', 'king-addons'),
                    'description' => esc_html__('Show live wishlist item count with optional icon and click-through to the wishlist page.', 'king-addons'),
                    'php-class' => 'Wishlist_Counter',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-page' => [
                    'title' => esc_html__('Wishlist Page', 'king-addons'),
                    'description' => esc_html__('Render a wishlist table or list inside Elementor templates with column controls.', 'king-addons'),
                    'php-class' => 'Wishlist_Page',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-icon' => [
                    'title' => esc_html__('Wishlist Icon', 'king-addons'),
                    'description' => esc_html__('Floating wishlist icon with count badge and mini preview (Pro).', 'king-addons'),
                    'php-class' => 'Wishlist_Icon',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-mini-list' => [
                    'title' => esc_html__('Wishlist Mini List', 'king-addons'),
                    'description' => esc_html__('Off-canvas or inline mini wishlist with quick actions (Pro).', 'king-addons'),
                    'php-class' => 'Wishlist_Mini_List',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-multiple-lists-switcher' => [
                    'title' => esc_html__('Wishlist Lists Switcher', 'king-addons'),
                    'description' => esc_html__('Switch between multiple wishlists with dropdown or tabs (Pro).', 'king-addons'),
                    'php-class' => 'Wishlist_Multiple_Lists_Switcher',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'wishlist-share-buttons' => [
                    'title' => esc_html__('Wishlist Share Buttons', 'king-addons'),
                    'description' => esc_html__('Share current wishlist via Telegram, WhatsApp, email, or copy link (Pro).', 'king-addons'),
                    'php-class' => 'Wishlist_Share_Buttons',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'woocommerce-floating-cart-icon' => [
                    'title' => esc_html__('WooCommerce Floating Cart Icon', 'king-addons'),
                    'description' => esc_html__('Floating cart icon with item count and quick mini-cart preview. Pro adds hover/auto-open triggers, drawer layout, item thumbnails, remove links, and device/empty visibility rules.', 'king-addons'),
                    'php-class' => 'WooCommerce_Floating_Cart_Icon',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                    'has-pro' => true,
                    'category' => 'woocommerce',
                ],
                'pricing-table-ext' => [
                    'title' => esc_html__('Pricing Table', 'king-addons'),
                    'description' => esc_html__('Display pricing tables created with the Pricing Table Builder extension.', 'king-addons'),
                    'php-class' => 'Pricing_Table_Ext',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => [],
                    'js' => [],
                    'has-pro' => true,
                    'category' => 'content',
                ],
            ],
            'features' => [
                'faceted-filters' => [
                    'title' => esc_html__('Faceted Filters', 'king-addons'),
                    'description' => esc_html__('AJAX filters for posts and WooCommerce products with taxonomy, search, and price conditions.', 'king-addons'),
                    'php-class' => 'Faceted_Filters',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script'],
                ],
                'conditional-display' => [
                    'title' => esc_html__('Conditional Display', 'king-addons'),
                    'description' => esc_html__('Dynamically show or hide content based on user roles, dates, devices, URL parameters, WooCommerce conditions, cookies, and more.', 'king-addons'),
                    'php-class' => 'Conditional_Display',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['preview-handler'],
                ],
                //                'copy-paste' => [
                //                    'title' => esc_html__('Cross-Domain Copy & Paste for Elementor content', 'king-addons'),
                //                    'description' => esc_html__('Seamlessly copy and paste Elementor content across different domains. Perfect for speeding up workflows and maintaining consistent designs across multiple websites.', 'king-addons'),
                //                    'php-class' => 'Copy_Paste',
                ////                    'has-pro' => true,
                //                    'docs-link' => '',
                ////                    'demo-link' => 'https://kingaddons.com/elementor/copy-paste/',
                //                    'demo-link' => '',
                //                    'css' => ['style'],
                //                    'js' => [],
                //                ],
                'protected-content' => [
                    'title' => esc_html__('Protected Content', 'king-addons'),
                    'description' => esc_html__('Restrict access to specific content based on user roles or conditions. Perfect for membership sites, premium content, or personalized experiences.', 'king-addons'),
                    'php-class' => 'Protected_Content',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['preview-handler'],
                ],
                //                'conditional-display' => [
                //                    'title' => esc_html__('Conditional Display', 'king-addons'),
                //                    'description' => esc_html__('Dynamically show or hide content based on user roles, dates, or other conditions. Ideal for creating personalized and dynamic website experiences.', 'king-addons'),
                //                    'php-class' => 'Conditional_Display',
                ////                    'has-pro' => true,
                //                    'docs-link' => '',
                ////                    'demo-link' => 'https://kingaddons.com/elementor/conditional-display/',
                //                    'demo-link' => '',
                //                    'css' => ['style'],
                //                    'js' => [],
                //                ],
                'particles-background' => [
                    'title' => esc_html__('Particles Background', 'king-addons'),
                    'description' => esc_html__('Brings website to life by adding a dynamic, animated particle effect as background, creating an engaging and modern visual experience.', 'king-addons'),
                    'php-class' => 'Particles_Background',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/particles-background/',
                    'css' => [],
                    'js' => ['preview-handler']
                ],
                'parallax-background' => [
                    'title' => esc_html__('Parallax Background', 'king-addons'),
                    'description' => esc_html__('Adds a dynamic, multi-layered visual effect to website backgrounds, moving at different speeds during scrolling for an immersive, 3D-like experience for sections and containers. The feature uses only lightweight JS code (11 kilobytes).', 'king-addons'),
                    'php-class' => 'Parallax_Background',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/parallax-background/',
                    'css' => [],
                    'js' => ['preview-handler']
                ],
                'animated-gradient-mesh-background' => [
                    'title' => esc_html__('Animated Gradient & Mesh Background', 'king-addons'),
                    'description' => esc_html__('Add animated gradient or mesh backgrounds to sections, containers, and columns with presets, motion controls, and optional Pro scroll binding and export.', 'king-addons'),
                    'php-class' => 'Animated_Gradient_Mesh_Background',
                    'has-pro' => true,
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/interactive-gradient-mesh/',
                    'css' => ['style'],
                    'js' => ['script'],
                ],
                'matte-glass-background' => [
                    'title' => esc_html__('Matte Glass Background', 'king-addons'),
                    'description' => esc_html__('Adds matte glass background feature also known as frosted glass effect. The feature uses only CSS, not any JavaScript at all.', 'king-addons'),
                    'php-class' => 'Matte_Glass_Background',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/matte-glass-background/',
                    'css' => [],
                    'js' => []
                ],
                'advanced-border-radius' => [
                    'title' => esc_html__('Advanced Border Radius', 'king-addons'),
                    'description' => esc_html__('Perfect for creating unique, rounded corners on elements. Customize the border radius for each corner, add different styles, and create visually appealing shapes to match your brand. Ideal for adding a modern and stylish touch to your site.', 'king-addons'),
                    'php-class' => 'Advanced_Border_Radius',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/advanced-border-radius/',
                    'css' => [],
                    'js' => []
                ],
                'floating-animation' => [
                    'title' => esc_html__('Floating Animation', 'king-addons'),
                    'description' => esc_html__('Adds floating animation setting. The feature does not use JavaScript, only lightweight CSS animation.', 'king-addons'),
                    'php-class' => 'Floating_Animation',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/floating-animation/',
                    'css' => [],
                    'js' => ['preview-handler']
                ],
                'custom-css' => [
                    'title' => esc_html__('Custom CSS', 'king-addons'),
                    'description' => esc_html__('Provides an easy-to-use interface for adding personalized CSS styles, allowing precise control over the appearance and layout of web elements on your page.', 'king-addons'),
                    'php-class' => 'Custom_CSS',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/custom-css/',
                    'css' => [],
                    'js' => ['preview-handler']
                ],
                'rotating-animation' => [
                    'title' => esc_html__('Rotating Animation', 'king-addons'),
                    'description' => esc_html__('Adds rotating animation setting. The feature does not use JS, only lightweight CSS animation.', 'king-addons'),
                    'php-class' => 'Rotating_Animation',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/rotating-animation/',
                    'css' => [],
                    'js' => ['preview-handler']
                ],
                'wrapper-link' => [
                    'title' => esc_html__('Wrapper Link', 'king-addons'),
                    'description' => esc_html__('Wrap everything in link - section, container, column and common elements', 'king-addons'),
                    'php-class' => 'Wrapper_Link',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/wrapper-link/',
                    'css' => [],
                    'js' => []
                ],
                'duplicator' => [
                    'title' => esc_html__('Duplicator', 'king-addons'),
                    'description' => esc_html__('Adds feature to duplicate posts, pages, Elementor templates and etc.', 'king-addons'),
                    'php-class' => 'Duplicator',
                    'docs-link' => '',
                    'demo-link' => 'https://kingaddons.com/elementor/duplicator/',
                    'css' => [],
                    'js' => []
                ],
                'collapse-expand-text' => [
                    'title' => esc_html__('Collapse & Expand Text', 'king-addons'),
                    'description' => esc_html__('Adds collapse and expand functionality to text elements, allowing users to show/hide content with smooth animations. Perfect for long text content and improved user experience.', 'king-addons'),
                    'php-class' => 'Collapse_Expand_Text',
                    'docs-link' => '',
                    'demo-link' => '',
                    'css' => ['style'],
                    'js' => ['script', 'preview-handler']
                ],
            ]
        ];
    }
}
