<?php
/**
 * Plugin Name: Kimiyi Bot
 * Plugin URI: https://Kimiyi.com
 * Description: Kimiyi is an AI powered chatbot platform that enables you to quickly and easily build incredible chatbots to communicate and engage your customers on website, Facebook messenger and other platforms.
 * Version: 1.5.3
 * Author: Kimiyi
 * Author URI: https://www.kimiyi.ai/
 * License: GPL2
 * Text Domain: Kimiyibot
 */


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
add_action('wp_head', 'Kimiyi_function');



function Kimiyi_function()
{
  $textvar = get_option('kimiyibot_plugin_variable_default', ''); // Default if not set
  $url = "https://internalwebapi.kimiyi.ai/api/Wordpress/getBotsUrl?APIKey=" . urlencode($textvar);
  $response  = wp_remote_get($url);

  if (is_wp_error($response)) {
    die('Error occurred: ' . esc_html($response->get_error_message())); // Escape error message
  }
  $api_result = trim(str_replace('"', '', wp_remote_retrieve_body($response)));
  $escaped_result = esc_html($api_result); // Use esc_html for the API result
  $script_url = 'https://widget.kimiyi.ai/DeployJS/Deploy3.js?id=' . esc_js($escaped_result);
  wp_register_script('kimiyi-widget', $script_url, array(), null, true);
  wp_enqueue_script('kimiyi-widget');


}

/**
 * Activate the plugin.
*/ 
register_activation_hook(__FILE__, 'Kimiyi_activate');
add_action('admin_init', 'Kimiyi_redirect');




function Kimiyi_activate() {
    add_option('Kimiyi_do_activation_redirect', true);
}

function Kimiyi_redirect() {
    if (get_option('Kimiyi_do_activation_redirect', false)) {
        delete_option('Kimiyi_do_activation_redirect');
        wp_redirect('admin.php?page=kimiyiai-chatbot.php');
    }
}

add_action('admin_menu', 'Kimiyi_admin_menu');

function Kimiyi_admin_menu()
{
	 add_menu_page('KimiyiBot', 'KimiyiBot', 'manage_options', 'kimiyiai-chatbot.php', 'Kimiyi_footer_text_admin_page','dashicons-format-chat');
  //add_management_page('Kimiyi', 'Kimiyi', 'manage_options', __FILE__, 'Kimiyi_footer_text_admin_page');
}
add_action( 'admin_menu', 'Kimiyi_admin_menu' );
function Kimiyi_footer_text_admin_page()
{

  $textvar = get_option('kimiyibot_plugin_variable_default', 'Kimiyi bot script');
  if (isset($_POST['change-clicked'])) {
 
    if ( ! isset( $_POST['my_Kimiyi_update_setting'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['my_Kimiyi_update_setting'] ) ), 'Kimiyi-update-setting' ) ) {
      die( "<br><br>Hmm .. looks like you didn't send any credentials.. No CSRF for you! " );
    }
    $footertext = esc_url_raw($_POST['footertext']);
    $footerval = explode('//',$footertext);
    update_option('kimiyibot_plugin_variable_default', end($footerval));
    $textvar = get_option('kimiyibot_plugin_variable_default', 'Kimiyi bot script');
  }

  ?>
<div class="wrap">
  <div id="poststuff">
    <div id="post-body" class="metabox-holder columns-2">
      <div id="post-body-content">
        <div class="postbox">
          <div class="inside">
          <img src="<?php echo esc_url(plugin_dir_url( __FILE__ ) . 'images/icon.png'); ?>" alt="Kimiyi">
            <h1>
              Kimiyi - Settings
              </h1>
            <h3 class="cc-labels"><?php esc_html_e('Instructions: ', 'kimiyiai-chatbot'); ?></h3>

            <p>1.
                <?php
                esc_html_e('If you do not have a Kimiyi account, please log on to ', 'kimiyiai-chatbot'); 
                ?>
                <a href="https://app.kimiya.ai/" target="_blank"><?php esc_html_e('Kimiyi', 'kimiyiai-chatbot'); ?></a>, 
                <?php esc_html_e('and sign up', 'kimiyiai-chatbot'); ?>
            </p>
			      <p>2.
              <?php esc_html_e('Go to digital staff panel and select the digital staff > the Workspace Page', 'kimiyiai-chatbot'); ?>
            </p>
            <p>3.
              <?php esc_html_e('Scroll down to the integration part, and then copy the API Key', 'kimiyiai-chatbot'); ?>
            </p>
			    <p>4.
              <?php esc_html_e('Paste it below and you are done.', 'kimiyiai-chatbot'); ?>
            </p>

            <h3 class="cc-labels" for="script"><?php esc_html_e('Kimiyi API Key:', 'kimiyiai-chatbot'); ?></h3>
            <?php $PHP_SELF = sanitize_url($_SERVER['REQUEST_URI']); ?>
            <form action="<?php echo esc_url($PHP_SELF); ?>" method="post">
              <input style="width:100%" type="text" class="regular-text" value="<?php echo esc_html($textvar); ?>" placeholder="Paste your Kimiyi API Key here, it resembles xxxxxx-xxxx-xxxx-xxxx-xxxx" name="footertext">
              <input name="change-clicked" type="hidden" value="1" />
              <input name="my_Kimiyi_update_setting" type="hidden" value="<?php echo esc_attr(wp_create_nonce('Kimiyi-update-setting')); ?>" />
              <br />
              <br />
              <input class="button button-primary" type="submit" value="<?php esc_html_e('Save settings', 'kimiyiai-chatbot'); ?>" />
            </form>
          </div>
        </div>
      </div>
      
    </div>
  </div>
</div>

<?php
}
?>