<?php

/**
 * Plugin Name: Kickscraper
 * Description: A plugin for manage kickscraper application stuffs.
 * Version: 0.1
 * Author: Shakil Ahamed
 * Author URI: https://shakilahamed.com
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: kickscraper
 * Plugin URI: https://kickscraper.com
 */

// Hook into the 'wp_head' action
add_action('wp_head', 'kickscraper_add_script_to_head', 1);
function kickscraper_add_script_to_head()
{
    // Fetch the kick_key option from the database
    $kick_key = get_option('kickscraper_kick_key');

    // Echo the script with the dynamic kick_key
    echo '<script id="kickscraper_script" src="https://cdn.kickscraper.com?kick_key=' . esc_attr($kick_key) . '&v=' . time() . '"></script>' . "\n";
}

// Add a settings link on the plugin page
function kickscraper_plugin_settings_link($links)
{
    $settings_link = '<a href="options-general.php?page=kickscraper-key-config">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
}

$plugin = plugin_basename(__FILE__);
add_filter("plugin_action_links_$plugin", 'kickscraper_plugin_settings_link');

// Create menu item for plugin settings
add_action('admin_menu', 'kickscraper_plugin_menu');
function kickscraper_plugin_menu()
{
    add_options_page('Kick Scraper Key Configuration', 'Kick Scraper Key', 'manage_options', 'kickscraper-key-config', 'kickscraper_plugin_page');
}

// Create the settings page content
function kickscraper_plugin_page()
{
?>
    <div class="wrap">
        <h2>Kick Scraper Key</h2>
        <form method="post" action="options.php">
            <?php settings_fields('kickscraper-options-group'); ?>
            <?php do_settings_sections('kickscraper-options-group'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Kick Scraper API Key</th>
                    <td><input type="text" name="kickscraper_kick_key" value="<?php echo esc_attr(get_option('kickscraper_kick_key')); ?>" /></td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
<?php
}

// Register and define the settings
add_action('admin_init', 'kickscraper_register_settings');
function kickscraper_register_settings()
{
    register_setting('kickscraper-options-group', 'kickscraper_kick_key');
}
