<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Manual Setup Guide
 *
 * @since   1.0
 */

global $KCCWoo_Authorise;

$step = array_key_exists('_wpnonce', $_GET) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'kccwoo-nonce') && array_key_exists('step', $_GET) ? (int) $_GET['step'] : 1;
$generate_key = array_key_exists('_wpnonce', $_GET) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'kccwoo-nonce') && array_key_exists('generate', $_GET) && $_GET['generate'] == 'true';

if($generate_key) {
   $api_key = $KCCWoo_Authorise->create_key();
} else {
   $api_key = $KCCWoo_Authorise->get_kccwoo_api_key();
}

$nonce = wp_create_nonce('kccwoo-nonce');
?>

<h2><?php esc_html_e('Manual Process', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>

<?php
switch($step) {
   case 1:
      ?>
      <div class="box full-width">
         <div class="box-content">
            <h2><?php esc_html_e('Step 1', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('The first step in setting up the connection between WooCommerce® and Khaos Control Cloud is to create an API key that Khaos Control Cloud will use to communicate with WooCommerce®.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <?php
            if($api_key && $api_key['consumer_key']) {
               ?>
               <div class="notice notice-success">
                  <?php /* translators: %s: api truncated key */ ?>
                  <p><?php printf(esc_html__('You have an API key set up, ***%s, you can use that API key or you can generate a new one', 'khaos-control-cloud-connector-for-woocommerce'), esc_html($api_key['truncated_key'])); ?></p>
               </div>
               <p><?php esc_html_e('If you would like to continue using this API key then click the button below to skip to Step 3.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
               <p><a class="button button-secondary" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=3&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Use existing API key', 'khaos-control-cloud-connector-for-woocommerce'); ?></a></p>
               <p>&nbsp;</p>
               <?php
            }
            ?>
            <p><?php esc_html_e('To generate a new API key, please click the button below to continue to the next Step.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignright" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=2&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Continue', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
   
   case 2:
      ?>
      <div class="box">
         <div class="box-content">
            <h2><?php esc_html_e('Step 2', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('You can either generate a new API key automatically, or if you need specific settings you can generate it manually.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            
            <h4><?php esc_html_e('Generate Automatically', 'khaos-control-cloud-connector-for-woocommerce'); ?></h4>
            <p><?php esc_html_e('To generate a new API key automatically, simple click the button below.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><em><?php esc_html_e('Please Note, this will remove any existing API keys with a name of "Khaos Control Cloud", so if you require these still, please setup a new API key manually.', 'khaos-control-cloud-connector-for-woocommerce'); ?></em></p>
            <?php
            if($generate_key) {
               if($api_key) {
                  ?>
                  <div class="notice notice-success">
                     <p><?php esc_html_e('API Key generated successfully. Make sure to copy your new keys now as the secret key will be hidden once you leave this page.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
                     <p><strong><?php esc_html_e('Consumer Key:', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong> <?php echo esc_html($api_key['consumer_key']); ?></p>
                     <p><strong><?php esc_html_e('Consumer Secret:', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong> <?php echo esc_html($api_key['consumer_secret']); ?></p>
                  </div>
                  <?php
               } else {
                  ?>
                  <div class="notice notice-error">
                     <p><?php esc_html_e('There was an issue generating the API key, please try again.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
                  </div>
                  <?php
               }
            }
            ?>
            <p><a class="button button-secondary" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=2&generate=true&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Create API Key Automatically', 'khaos-control-cloud-connector-for-woocommerce'); ?></a></p>
            
            <p>&nbsp;</p>
            
            <h4><?php esc_html_e('Generate Manually', 'khaos-control-cloud-connector-for-woocommerce'); ?></h4>
            <p><?php esc_html_e('You can also generate a new API key manually by clicking the button below and filling in the required details.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('You will need to set 3 options when creating the API key:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><strong><?php esc_html_e('Description', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This should be set to "Khaos Control Cloud".', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('User', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This must be an Admin user in your Wordpress CMS.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Permissions', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('These must be set to "Read/Write".', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('Once you have entered these details, click the "Generate API key" button.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('Once the API Key has been generated you will be shown the "Consumer Key" and "Consumer Secret", you will need these in order to setup the Channel in Khaos Control Cloud.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><strong><?php esc_html_e('Either keep this screen open or make a copy of the "Consumer Key" and "Consumer Secret", as you will need to enter them into Khaos Control Cloud.', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong></p>
            <p><a class="button button-secondary" target="_blank" href="/wp-admin/admin.php?page=wc-settings&tab=advanced&section=keys&create-key=1"><?php esc_html_e('Create API Key Manually', 'khaos-control-cloud-connector-for-woocommerce'); ?></a></p>
         </div>
         <div class="box-images">
            <img src="<?php echo esc_url(plugins_url('assets/images/step-2a.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 2 A', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
            <img src="<?php echo esc_url(plugins_url('assets/images/step-2b.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 2 B', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignleft" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=1&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Back', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
               <a class="button button-primary alignright" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=3&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Continue', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
      
   case 3:
      ?>
      <div class="box">
         <div class="box-content">
            <h2><?php esc_html_e('Step 3', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('Now that you have the API Key details for WooCommerce® you will need to setup a new Channel in Khaos Control Cloud.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><a href="https://app.khaoscloud.com" target="_blank"><?php esc_html_e('Log into your Khaos Control Cloud account', 'khaos-control-cloud-connector-for-woocommerce'); ?></a> <?php esc_html_e('and click on the blue box at the top of the screen and select "New Channel".', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('This will bring up a popup asking you to select a channel type, from the drop-down select "WooCommerce" and click the "OK" button.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="box-images">
            <img src="<?php echo esc_url(plugins_url('assets/images/step-3a.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 3 A', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
            <img src="<?php echo esc_url(plugins_url('assets/images/step-3b.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 3 B', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignleft" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=2&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Back', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
               <a class="button button-primary alignright" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=4&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Continue', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
      
   case 4:
      ?>
      <div class="box full-width">
         <div class="box-content">
            <h2><?php esc_html_e('Step 4', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('You should now see a screen where you can setup the details of the Channel.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('Set the "General" options as required:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><strong><?php esc_html_e('Name', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This is the name of the channel as it will appear in Khaos Control Cloud. It does not need to match up to any official channel name so long as you can identify it.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Channel Enabled', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('Determines whether the channel is enabled or disabled. We would recommend that it remains enabled once you have authenticated the channel.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('You will also need to set these "Channel Specific" options:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><strong><?php esc_html_e('WooCommerce® URL', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This is the URL that Khaos Control Cloud will use to access the WooCommerce® site. This should be set to:', 'khaos-control-cloud-connector-for-woocommerce'); ?> <strong><?php echo esc_html(get_site_url() .'/wp-json/wc/v2/'); ?></strong></li>
               <li><strong><?php esc_html_e('Consumer Key', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This is the "Consumer Key" from the API Key you setup within WooCommerce®.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Consumer Secret', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This is the "Consumer Secret" from the API Key you setup within WooCommerce®.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Download POS Orders', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, the system will download orders created via the WooCommerce® EPOS gateway.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Download Pending Orders', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, the system will download orders that are marked as pending on your WooCommerce® store. If these do not have a payment, it is possible they will imported into Manual Hold.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Import Metadata as ExtDesc', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, this option sets KCC to use stock metadata from your channel as an extended description for stock items on sales orders. This is generally used for things such as personalisation or free text messages relating to the item.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('Click the "Save Channel" button to complete the setup.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignleft" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=manual&step=3&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Back', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
}
?>