<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Automated Setup Guide
 *
 * @since   1.0
 */

$step = array_key_exists('_wpnonce', $_GET) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'kccwoo-nonce') && array_key_exists('step', $_GET) ? (int) $_GET['step'] : 1;

$nonce = wp_create_nonce('kccwoo-nonce');

// TODO: Complete the automated process instructions once the KCC side is done
?>

<h2><?php esc_html_e('Automatic Process', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>

<?php
switch($step) {
   case 1:
      ?>
      <div class="box">
         <div class="box-content">
            <h2><?php esc_html_e('Step 1', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><a href="https://app.khaoscloud.com" target="_blank"><?php esc_html_e('Log into your Khaos Control Cloud account', 'khaos-control-cloud-connector-for-woocommerce'); ?></a> <?php esc_html_e('and click on the blue box at the top of the screen and select "New Channel".', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('This will bring up a popup asking you to select a channel type, from the drop-down select "WooCommerce" and click the "OK" button.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="box-images">
            <img src="<?php echo esc_url(plugins_url('assets/images/step-3a.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 1', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
            <img src="<?php echo esc_url(plugins_url('assets/images/step-3b.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 1 A', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignright" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=automated&step=2&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Continue', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
      
   case 2:
      ?>
      <div class="box full-width">
         <div class="box-content">
            <h2><?php esc_html_e('Step 2', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('Click on the XXXXXXXXXX button to begin the authorisation process.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('Enter the base URL of your WooCommerce® website into the popup box, e.g. https://www.website.com.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignleft" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=automated&step=1&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Back', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
               <a class="button button-primary alignright" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=automated&step=3&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Continue', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
      break;
      
   case 3:
      ?>
      <div class="box">
         <div class="box-content">
            <h2><?php esc_html_e('Step 3', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('Click on the Authorise button to complete the process. This will generate an API Key in WooCommerce® and pass the details back to Khaos Control Cloud.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><?php esc_html_e('Set the "General" options as required:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><strong><?php esc_html_e('Name', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('This is the name of the channel as it will appear in Khaos Control Cloud. It does not need to match up to any official channel name so long as you can identify it.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Channel Enabled', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('Determines whether the channel is enabled or disabled. We would recommend that it remains enabled once you have authenticated the channel.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('You can then set these "Channel Specific" options as required:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><strong><?php esc_html_e('Download POS Orders', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, the system will download orders created via the WooCommerce® EPOS gateway.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Download Pending Orders', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, the system will download orders that are marked as pending on your WooCommerce® store. If these do not have a payment, it is possible they will imported into Manual Hold.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><strong><?php esc_html_e('Import Metadata as ExtDesc', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php esc_html_e('When enabled, this option sets KCC to use stock metadata from your channel as an extended description for stock items on sales orders. This is generally used for things such as personalisation or free text messages relating to the item.', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('Click the "Save Channel" button to complete the setup.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <div class="box-images">
            <img src="<?php echo esc_url(plugins_url('assets/images/step-3-A.jpg', dirname(dirname(__FILE__)))); ?>" alt="<?php esc_html_e('Step 3', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
         </div>
         <div class="controls">
            <p>
               <a class="button button-primary alignleft" href="/wp-admin/admin.php?page=kccwoo-setup-guide&type=automated&step=2&_wpnonce=<?php echo esc_html($nonce); ?>"><?php esc_html_e('Back', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>
            </p>
            <div class="clear"></div>
         </div>
      </div>
      <?php
}
?>