<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Settings Page
 *
 * @since   1.0
 */

global $KCCWoo_Setup_Guide;
global $KCCWoo_Authorise;

$api_key = $KCCWoo_Authorise->get_kccwoo_api_key();
?>

<div id="wpbody" role="main">
   <div class="kccwoo-header">
      <h1><?php esc_html_e('Khaos Control Cloud Integration Settings', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
      <a href="https://www.khaoscontrol.com/" target="_blank"><img src="<?php echo esc_url(plugins_url('assets/images/kcc-logo.png', dirname(__FILE__))); ?>" alt="<?php esc_html_e('Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?>" /></a>
   </div>
   <div class="kccwoo-content">
      <h1><?php esc_html_e('Khaos Control Cloud Integration Settings', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
      
      <?php
      if($api_key) {
         $last_access = DateTime::createFromFormat('Y-m-d H:i:s', $api_key['last_access']);
         
         if($last_access) {
            ?>
            <div class="notice notice-success">
               <?php /* translators: %s: last access date */ ?>
               <p><?php printf(esc_html__('Khaos Control Cloud last connected to your website on %s', 'khaos-control-cloud-connector-for-woocommerce'), esc_html($last_access->format('d-m-Y H:i:s'))); ?></p>
            </div>
            <?php
         } else {
            ?>
            <div class="notice notice-error">
               <?php /* translators: %s: last access date */ ?>
               <p><?php esc_html_e('Khaos Control Cloud has not connected to your website yet', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            </div>
            <?php
         }
         ?>
         <p>&nbsp;</p>
         <?php
      }
      ?>
      
      <div class="box full-width">
         <div class="box-content">
            <h2><?php esc_html_e('The settings for the WooCommerce® integration can be found in the "Channels" screen in Khaos Control Cloud.', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('Here are some of the options you can change:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <ul class="ul-disc">
               <li><?php esc_html_e('Enable / Disable the Channel', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><?php esc_html_e('Change your Order Import settings', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><?php esc_html_e('Change your Stock Import settings', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               <li><?php esc_html_e('Change the WooCommerce® API Key details', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
            </ul>
            <p><?php esc_html_e('More information on Channels configuration can be found', 'khaos-control-cloud-connector-for-woocommerce'); ?> <a target="_blank" href="https://servicedesk.khaoscloud.com/portal/en/kb/articles/channel-configuration"><?php esc_html_e('here', 'khaos-control-cloud-connector-for-woocommerce'); ?></a>.</p>
            <p><a class="button button-primary" href="https://app.khaoscloud.com" target="_blank"><?php esc_html_e('Log into Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?></a></p>
         </div>
      </div>
      <div class="box full-width">
         <div class="box-content">
            <h2><?php esc_html_e('WooCommerce® API Key', 'khaos-control-cloud-connector-for-woocommerce'); ?></h2>
            <p><?php esc_html_e('If you need to generate a new API Key for WooCommerce® you can do so here:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
            <p><a class="button button-primary" href="/wp-admin/admin.php?page=kccwoo-setup-guide&step=2"><?php esc_html_e('Create API Key', 'khaos-control-cloud-connector-for-woocommerce'); ?></a></p>
         </div>
      </div>
   </div>
</div>