<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Setup Guide Page
 *
 * @since   1.0
 */

global $KCCWoo_Setup_Guide;
global $KCCWoo_Authorise;

$api_key = $KCCWoo_Authorise->get_kccwoo_api_key();
$type = array_key_exists('_wpnonce', $_GET) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'kccwoo-nonce') && array_key_exists('type', $_GET) ? sanitize_text_field(wp_unslash($_GET['type'])) : 'manual';
?>

<div id="wpbody" role="main">
   <div class="kccwoo-header">
      <h1><?php esc_html_e('Khaos Control Cloud Integration Setup', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
      <a href="https://www.khaoscontrol.com/" target="_blank"><img src="<?php echo esc_url(plugins_url('assets/images/kcc-logo.png', dirname(__FILE__))); ?>" alt="<?php esc_html_e('Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?>" /></a>
   </div>
   <div class="kccwoo-content">
      <h1><?php esc_html_e('How to Integrate WooCommerce® with Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
      
      <?php require_once(KCCWOO_PLUGIN_DIR .'pages/parts/'. $type .'.php'); ?>
   </div>
</div>