<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Authorise Page
 *
 * @since   1.0
 */

global $KCCWoo_Setup_Guide;
global $KCCWoo_Authorise;

$authorise = false;

$nonce = wp_create_nonce('kccwoo-nonce');

if(array_key_exists('authorise', $_POST)) {
   if(array_key_exists('_wpnonce', $_POST) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'kccwoo-nonce')) {
      $authorise = $KCCWoo_Authorise->authorise();
   }
}
?>

<div id="wpbody" role="main">
   <div class="kccwoo-header">
      <h1><?php esc_html_e('Khaos Control Cloud Integration Authorisation', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
      <a href="https://www.khaoscontrol.com/" target="_blank"><img src="<?php echo esc_url(plugins_url('assets/images/kcc-logo.png', dirname(__FILE__))); ?>" alt="<?php esc_html_e('Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?>" /></a>
   </div>
   <div class="kccwoo-content">
      <div class="box full-width center">
         <div class="box-content">
            <img src="<?php echo esc_url(plugins_url('assets/images/kcc-logo-green.png', dirname(__FILE__))); ?>" alt="<?php esc_html_e('Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
            
            <?php
            if(array_key_exists('authorise', $_POST)) {
               if(!$authorise) {
                  ?>
                  <div class="authorisation-failed">
                     <h1 class="text-center"><?php esc_html_e('Oops. Something Went Wrong', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
                  </div>
                  <?php
               } else {
                  ?>
                  <div class="authorisation-complete" data-woocommerce-url="<?php echo esc_html($authorise['woocommerce_url']); ?>" data-consumer-key="<?php echo esc_html($authorise['consumer_key']); ?>" data-consumer-secret="<?php echo esc_html($authorise['consumer_secret']); ?>">
                     <h1 class="text-center"><?php esc_html_e('Authorisation Complete', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
                     <p><?php esc_html_e('Here are the API Key details, make sure to copy your new keys now as the secret key will be hidden once you leave this page:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
                     <p><strong><?php esc_html_e('Consumer Key', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php echo esc_html($authorise['consumer_key']); ?></p>
                     <p><strong><?php esc_html_e('Consumer Secret', 'khaos-control-cloud-connector-for-woocommerce'); ?></strong>: <?php echo esc_html($authorise['consumer_secret']); ?></p>
                  </div>
                  <?php
               }
            } elseif(array_key_exists('cancel', $_POST)) {
               ?>
               <div class="authorisation-cancelled">
                  <h1 class="text-center"><?php esc_html_e('Authorisation Cancelled', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
               </div>
               <?php
            } else {
               ?>
               <h1><?php esc_html_e('Khaos Control Cloud would like to connect to your store', 'khaos-control-cloud-connector-for-woocommerce'); ?></h1>
               <p><?php esc_html_e('This will give Khaos Control Cloud access which will allow it to:', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
               <ul class="ul-disc">
                  <li><?php esc_html_e('Create and use an API Key in WooCommerce®', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
                  <li><?php esc_html_e('Import Products to Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
                  <li><?php esc_html_e('Import Orders to Khaos Control Cloud', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
                  <li><?php esc_html_e('Update Product Stock Statuses in WooCommerce®', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
                  <li><?php esc_html_e('Update Order Statuses in WooCommerce®', 'khaos-control-cloud-connector-for-woocommerce'); ?></li>
               </ul>
               <form method="post" action="">
                  <input type="hidden" name="_wpnonce" value="<?php echo esc_html($nonce); ?>" />
                  <input type="submit" class="button" name="cancel" value="<?php esc_html_e('Cancel', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
               </form><!--
            --><form method="post" action="">
               <input type="hidden" name="_wpnonce" value="<?php echo esc_html($nonce); ?>" />
                  <input type="submit" class="button button-primary" name="authorise" value="<?php esc_html_e('Authorise', 'khaos-control-cloud-connector-for-woocommerce'); ?>" />
               </form>
               <?php
            }
            ?>
         </div>
      </div>
   </div>
</div>