<?php
defined( 'ABSPATH' ) or die( 'No direct access to this file' );

/**
 * Plugin Name: Khaos Control Cloud Connector for WooCommerce®
 * Description: Setup guide for how to integrate WooCommerce® and Khaos Control Cloud.
 * Version: 1.0
 * Author: Khaos Control
 * Author URI: https://www.khaoscontrol.com/
 * Text Domain: khaos-control-cloud-connector-for-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.6
 * Requires PHP: 7.0
 * Requires Plugins: woocommerce
 * WC requires at least: 6.0.0
 * WC tested up to: 6.0.0
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 * 
 * @package KCCConnector
 * 
 * Copyright 2025 Khaos Control
 */

/**
 * Setup constants for filepath usage
 */
define('KCCWOO_PLUGIN_FILE', __FILE__);
define('KCCWOO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('KCCWOO_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * Load the plugin class file
 */
require_once(KCCWOO_PLUGIN_DIR .'class/class.kccwoo-setup-guide.php');
require_once(KCCWOO_PLUGIN_DIR .'class/class.kccwoo-authorise.php');

/**
 * Initialise an instance of the classes
 */
$KCCWoo_Setup_Guide = new KCCWoo_Setup_Guide();
$KCCWoo_Authorise = new KCCWoo_Authorise();
?>