<?php
defined('ABSPATH') or die('No direct access to this file');

use Automattic\Jetpack\Constants;

/**
 * Khaos Control Cloud Connector for WooCommerce® Setup
 *
 * @since   1.0
 */

/**
 * Main KCCWoo_Setup_Guide Class.
 *
 * @class KCCWoo_Setup_Guide
 */
final class KCCWoo_Setup_Guide {
   /**
	 * CSS version.
	 *
	 * @var string
	 */
   public $css_version = '1.0.7';
   
   /**
	 * JS version.
	 *
	 * @var string
	 */
   public $js_version = '1.0.0';
   
   /**
    * Plugin constructor
    *
    * @since   1.0
    */
   public function __construct() {
      if(!defined('ABSPATH')) {
         return;
      }
      
      register_activation_hook(KCCWOO_PLUGIN_DIR .'khaos-control-cloud-setup-guide.php', array(&$this, 'kccwoo_setup_guide_install'));
      
      /**
       * Hook into actions and filters.
       *
       * @since 1.0
       */
      if(is_admin()) {
         add_action('admin_menu', array(&$this, 'setup_admin_menu'));
         add_action('admin_enqueue_scripts', array(&$this, 'load_scripts'));
         add_action('admin_notices', array(&$this, 'admin_notices'));
      }
   }
   
   /**
    * Install the plugin
    *
    * @since   1.0
    */
   public function kccwoo_setup_guide_install() {
      /**
       * This has been put in place for future use
       */
   }
   
   /**
    * Uninstall the plugin
    *
    * @since   1.0
    */
   public function kccwoo_setup_guide_uninstall() {
      /**
       * This has been put in place for future use
       */
   }
   
   /**
    * Add the Khaos Control Cloud Integration Admin Menu
    *
    * @since   1.0
    */
   public function setup_admin_menu() {
      /**
       * Include required file for checking if a plugin is active
       */
      require_once(ABSPATH .'/wp-admin/includes/plugin.php');
   
      $menu_icon = 'data:image/svg+xml;base64,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';
         
      add_menu_page(esc_html__('Khaos Control Cloud Connector Setup', 'khaos-control-cloud-connector-for-woocommerce'), esc_html__('KCC Connector', 'khaos-control-cloud-connector-for-woocommerce'), 'manage_woocommerce', 'kccwoo-setup-guide', array(&$this, 'guide_page'), $menu_icon, '58');
      
      add_submenu_page('kccwoo-setup-guide', esc_html__('Khaos Control Cloud Connector Setup', 'khaos-control-cloud-connector-for-woocommerce'), esc_html__('Connector', 'khaos-control-cloud-connector-for-woocommerce'), 'manage_woocommerce', 'kccwoo-setup-guide', array(&$this, 'guide_page'));
      
      add_submenu_page('kccwoo-setup-guide', esc_html__('Khaos Control Cloud Connector Settings', 'khaos-control-cloud-connector-for-woocommerce'), esc_html__('Settings', 'khaos-control-cloud-connector-for-woocommerce'), 'manage_woocommerce', 'kccwoo-setup-guide-settings', array(&$this, 'settings_page'));
      
      add_submenu_page(NULL, esc_html__('Khaos Control Cloud Connector Authorisation', 'khaos-control-cloud-connector-for-woocommerce'), NULL, 'manage_woocommerce', 'kccwoo-setup-guide-authorisation', array(&$this, 'authorisation_page'));
   }
   
   /**
    * Include the content for the setup guide page
    *
    * @since   1.0
    */
   public function guide_page() {
      if(is_plugin_active('woocommerce/woocommerce.php')) {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-guide.php');
      } else {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-inactive.php');
      }
   }
   
   /**
    * Include the content for the settings page
    *
    * @since   1.0
    */
   public function settings_page() {
      if(is_plugin_active('woocommerce/woocommerce.php')) {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-settings.php');
      } else {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-inactive.php');
      }
   }
   
   /**
    * Include the content for the settings page
    *
    * @since   1.0
    */
   public function authorisation_page() {
      if(is_plugin_active('woocommerce/woocommerce.php')) {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-authorise.php');
      } else {
         require_once(KCCWOO_PLUGIN_DIR .'pages/page.kccwoo-setup-guide-inactive.php');
      }
   }
   
   /**
    * Load the admin CSS and JS files
    *
    * @since   1.0
    */
   public function load_scripts() {
      require_once(ABSPATH . 'wp-admin/includes/screen.php');

      $current_screen = get_current_screen();
      
      wp_enqueue_style(
         'kccwoo-setup-guide',
         KCCWOO_PLUGIN_URL .'assets/css/admin.css',
         array(),
         $this->css_version
      );
      
      if($current_screen && isset($current_screen->id) && $current_screen->id == 'admin_page_kccwoo-setup-guide-authorisation') {
         wp_enqueue_script(
            'kccwoo-authorisation',
            KCCWOO_PLUGIN_URL .'assets/js/admin.js',
            array('jquery'),
            $this->js_version,
            true
         );
      }
   }
   
   /**
    * Display any required admin notices
    *
    * @since   1.0
    */
   public function admin_notices() {
      global $KCCWoo_Authorise;
      
      $show_error_notice = false;
      $show_sync_notice = false;
      $last_access_date = '';
      
      if(!$KCCWoo_Authorise) {
         $show_error_notice = true;
      } else {
         $api_key = $KCCWoo_Authorise->get_kccwoo_api_key();
         
         if(!$api_key || $api_key['consumer_key'] == '') {
            $show_error_notice = true;
         } else {
            $last_access = DateTime::createFromFormat('Y-m-d H:i:s', $api_key['last_access']);
            if($last_access) {
               $last_access->setTime(0, 0, 0);
            }
            
            $current_date = new DateTime('now', new DateTimeZone('Europe/London'));
            $current_date->setTime(0, 0, 0);
            
            if(!$last_access || $last_access->format('U') < $current_date->format('U')) {
               $last_access_date = $last_access ? ' since '. $last_access->format('d-m-Y') : false;
               $show_sync_notice = true;
            }
         }
      }
      
      if($show_error_notice) {
         ?>
         <div class="notice notice-error is-dismissible">
            <p><?php esc_html_e('Khaos Control Cloud Integration is not complete, please follow the guide to complete the setup.', 'khaos-control-cloud-connector-for-woocommerce'); ?></p>
         </div>
         <?php
      }
      
      if($show_sync_notice) {
         ?>
         <div class="notice notice-error is-dismissible">
            <?php /* translators: %s: last access date */ ?>
            <p><?php printf(esc_html__('Khaos Control Cloud has not connected to your site%s, please check your Channel settings and Channel Notifications.', 'khaos-control-cloud-connector-for-woocommerce'), esc_html($last_access_date)); ?></p>
         </div>
         <?php
      }
   }
}
?>