<?php
defined('ABSPATH') or die('No direct access to this file');

/**
 * Khaos Control Cloud Connector for WooCommerce® Authorisation
 *
 * @since   1.0
 */

/**
 * Main KCCWooAuthorise Class.
 *
 * @class KCCWoo_Authorise
 */
final class KCCWoo_Authorise {
   /**
    * Plugin constructor
    *
    * @since   1.0
    */
    public function __construct() {
      if(!defined('ABSPATH')) {
         return;
      }
   }
   
   /**
    * Delete any existing WooCommerce® Khaos Control Cloud API Keys and create a new WooCommerce® Khaos Control Cloud API Key
    * 
    * @since   1.0
    * 
    * @return array API Key details
    */
    public function create_key() {
      global $wpdb;
      
      $description      = 'Khaos Control Cloud';
      $consumer_key     = 'ck_' . wc_rand_hash();
		$consumer_secret  = 'cs_' . wc_rand_hash();
      $user_id          = get_current_user_id();
      $permissions      = 'read_write';
      $truncated_key    = substr($consumer_key, -7);
      
      $wpdb->delete(
         $wpdb->prefix . 'woocommerce_api_keys',
         array(
            'description'     => $description
         ),
			array(
            '%s'
         )
      );
      
      $wpdb->insert(
			$wpdb->prefix . 'woocommerce_api_keys',
			array(
				'user_id'         => $user_id,
				'description'     => $description,
				'permissions'     => $permissions,
				'consumer_key'    => wc_api_hash($consumer_key),
				'consumer_secret' => $consumer_secret,
				'truncated_key'   => $truncated_key
			),
			array(
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
			)
		);

		return array(
			'key_id'          => $wpdb->insert_id,
			'consumer_key'    => $consumer_key,
			'consumer_secret' => $consumer_secret,
         'truncated_key'   => $truncated_key,
         'last_access'     => ''
		);
   }
   
   /**
    * Get the WooCommerce® API Key setup for Khaos Control Cloud
    *
    * @since   1.0
    * 
	 * @return array The ID of the API Key and the truncated key for display
    */
   public function get_kccwoo_api_key() {
      global $wpdb;
      
      $key = $wpdb->get_results(
         "SELECT key_id, consumer_key, consumer_secret, truncated_key, last_access FROM {$wpdb->prefix}woocommerce_api_keys WHERE description = 'Khaos Control Cloud' ORDER BY key_id DESC LIMIT 1",
         ARRAY_A
      );
      
      if($key) {
         return $key[0];
      }
      
      return array(
         'key_id'          => 0,
         'consumer_key'    => '',
         'consumer_secret' => '',
         'truncated_key'   => '',
         'last_access'     => ''
      );
   }
   
   /**
    * Authorise the integration with Khaos Control Cloud
    * 
    * @since   1.0
    * 
    * @return array API Key details
    */
   public function authorise() {
      $api_key = $this->get_kccwoo_api_key();
      
      if(!$api_key || $api_key['consumer_key'] == '') {
         $api_key = $this->create_key();
      }
      
      return array(
         'woocommerce_url' => get_site_url() .'/wp-json/wc/v2/',
         'consumer_key'    => $api_key['consumer_key'],
         'consumer_secret' => $api_key['consumer_secret']
      );
   }
}