<?php

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Eliminar opciones guardadas
 */
$keygin_option_keys = [
    'keygin_settings',
    'keygin_last_sync',
    'keygin_logs',
    'keygin_connection_status',
    'keygin_selected_warehouse',
];

foreach ($keygin_option_keys as $keygin_option) {
    delete_option($keygin_option);
    delete_site_option($keygin_option);
}

/**
 * Eliminar transients creados por el plugin
 */
delete_transient('keygin_warehouses');
delete_transient('keygin_warehouses_fetched_at');

/**
 * Eliminar cualquier otro transient que empiece con keygin_
 */
global $wpdb;

// Obtener todos los transients que comiencen con "keygin_"
// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$keygin_transients = $wpdb->get_col(
    $wpdb->prepare(
        "SELECT option_name FROM {$wpdb->options} 
        WHERE option_name LIKE %s OR option_name LIKE %s",
        '_transient_keygin_%',
        '_transient_timeout_keygin_%'
    )
);
// phpcs:enable

// Eliminar cada transient usando delete_transient()
if (!empty($keygin_transients)) {
    foreach ($keygin_transients as $keygin_transient_name) {
        // Remover prefijos "_transient_" o "_transient_timeout_"
        $name = preg_replace('/^_transient_/', '', $keygin_transient_name);
        $name = preg_replace('/^_transient_timeout_/', '', $name);

        if ($name) {
            delete_transient($name);
        }
    }
}

/**
 * Borrar evento cron programado
 */
wp_clear_scheduled_hook('keygin_sync_event');

/**
 * Eliminar logs en /uploads/keygin-sync-logs/
 */
$keygin_upload = wp_upload_dir();
$keygin_log_dir = trailingslashit($keygin_upload['basedir']) . 'keygin-sync-logs';

if (is_dir($keygin_log_dir)) {

    $keygin_files = glob($keygin_log_dir . '/*');

    if (!empty($keygin_files)) {
        foreach ($keygin_files as $keygin_file) {
            if (is_file($keygin_file)) {
                @wp_delete_file($keygin_file);
            }
        }
    }

    @rmdir($keygin_log_dir); // borrar el directorio si queda vacío
}

/**
 * Eliminar metadatos _keygin_id de los productos
 */
$keygin_products = get_posts([
    'post_type'      => 'product',
    'numberposts'    => -1,
    'fields'         => 'ids',
    'no_found_rows'  => true,
]);

if (!empty($keygin_products)) {
    foreach ($keygin_products as $keygin_product_id) {
        delete_post_meta($keygin_product_id, '_keygin_id');
    }
}