<?php
/*
    Plugin Name: Keygin Erp Sync
    Plugin URI: https://hasselcode.com/sincroniza-contifico-y-woocommerce-con-keygin-sync/
    Description: Automatic synchronization between WooCommerce and Contifico ERP.
    Version: 1.0.5
    Author: HasselCode
    Author URI: https://hasselcode.com/
    License: GPL2
    License URI: https://www.gnu.org/licenses/gpl-2.0.html
    Text Domain: keygin-erp-sync
    Domain Path: /languages
*/

/*
 * Copyright (c) 2025 HasselCode
 * Keygin Erp Sync – ERP & WooCommerce Integration
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 * 
 * ██╗  ██╗ █████╗ ███████╗███████╗███████╗██╗      ██████╗ ██████╗ ██████╗ ███████╗
 * ██║  ██║██╔══██╗██╔════╝██╔════╝██╔════╝██║     ██╔════╝██╔═══██╗██╔══██╗██╔════╝
 * ███████║███████║███████╗███████╗█████╗  ██║     ██║     ██║   ██║██║  ██║█████╗
 * ██╔══██║██╔══██║╚════██║╚════██║██╔══╝  ██║     ██║     ██║   ██║██║  ██║██╔══╝
 * ██║  ██║██║  ██║███████║███████║███████╗███████╗╚██████╗╚██████╔╝██████╔╝███████╗
 * ╚═╝  ╚═╝╚═╝  ╚═╝╚══════╝╚══════╝╚══════╝╚══════╝ ╚═════╝ ╚═════╝ ╚═════╝ ╚══════╝
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'KEYGIN_ERP_SYNC_VERSION', '1.0.5' );
define( 'KEYGIN_ERP_SYNC_PATH', plugin_dir_path( __FILE__ ) );
define( 'KEYGIN_ERP_SYNC_URL', plugin_dir_url( __FILE__ ) );

/**
 * Includes
 */
require_once KEYGIN_ERP_SYNC_PATH . 'includes/logs/class-logger.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/api/class-api.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/sync/class-stock.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/sync/class-product.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/cron/class-scheduler.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/admin/class-settings.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/admin/class-admin-product-indicator.php';
require_once KEYGIN_ERP_SYNC_PATH . 'includes/admin/class-admin-notices.php';

/**
 * Initialize plugin
 */
add_action( 'plugins_loaded', 'keygin_init_plugin', 20 );
if ( ! function_exists( 'keygin_init_plugin' ) ) {
     function keygin_init_plugin() {

        if ( ! class_exists( 'WooCommerce' ) ) {
            add_action( 'admin_notices', 'keygin_woocommerce_missing_notice' );
            return;
        }

        Keygin_Logger::init();

        $settings = new Keygin_Admin_Settings();
        $settings->init();

        new Keygin_Scheduler();
        new Keygin_Admin_Notices();

        $stock_sync = new Keygin_Stock_Sync();
        add_action(
            'woocommerce_order_status_completed',
            array( $stock_sync, 'update_stock_on_order_complete' )
        );
    }
}

/**
 * WooCommerce missing notice
 */
function keygin_woocommerce_missing_notice() {
    ?>
    <div class="notice notice-error">
        <p>
            <strong>
                <?php esc_html_e(
                    'Keygin Erp Sync requires WooCommerce to be installed and active.',
                    'keygin-erp-sync'
                ); ?>
            </strong>
        </p>
    </div>
    <?php
}

/**
 * Plugin activation
 */
register_activation_hook( __FILE__, 'keygin_activate_plugin' );
function keygin_activate_plugin() {
    update_option( 'keygin_erp_sync_active', true );

    $scheduler = new Keygin_Scheduler();
    $scheduler->clear_schedule();
}

/**
 * Plugin deactivation
 */
register_deactivation_hook( __FILE__, 'keygin_deactivate_plugin' );
function keygin_deactivate_plugin() {
    $scheduler = new Keygin_Scheduler();
    $scheduler->clear_schedule();

    delete_option( 'keygin_erp_sync_active' );
}