<?php
if (!defined('ABSPATH')) {
    exit;
}

// Capability check
if (!current_user_can('manage_options')) {
    wp_die(esc_html_e('You do not have permission to access this page.', 'keygin-erp-sync'));
}

// Get existing settings
$keygin_settings = (array) get_option('keygin_settings', []);

// Clean values
$api_key        = $keygin_settings['api_key'] ?? '';
$api_token      = $keygin_settings['api_token'] ?? '';
$warehouse      = $keygin_settings['warehouse'] ?? '';
$warehouse_name = $keygin_settings['warehouse_name'] ?? '';
$frequency      = $keygin_settings['frequency'] ?? '';
$sync_options   = $keygin_settings['sync_options'] ?? [];

// Get cached warehouses
$warehouses = get_transient('keygin_warehouses');
if (!is_array($warehouses)) {
    $warehouses = [];
}

// Synchronization frequencies
$frequencies = [
    'twicedaily' => esc_html_e('Twice daily', 'keygin-erp-sync'),
    'daily'      => esc_html_e('Daily', 'keygin-erp-sync'),
];

// Status messages
$status = isset($_GET['keygin_status'])
    ? sanitize_key($_GET['keygin_status'])
    : '';
?>

<div class="wrap keygin-settings">
    <h1><?php esc_html_e('Keygin Erp Sync Settings', 'keygin-erp-sync'); ?></h1>
    <p><?php esc_html_e('Connect your WooCommerce store with Contifico ERP to enable automatic synchronization.', 'keygin-erp-sync'); ?></p>

    <?php if ($status === 'success') : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Settings saved successfully.', 'keygin-erp-sync'); ?></p>
        </div>
    <?php elseif ($status === 'missing_fields') : ?>
        <div class="notice notice-error is-dismissible">
            <p><?php esc_html_e('Please complete all required fields before saving.', 'keygin-erp-sync'); ?></p>
        </div>
    <?php endif; ?>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" id="keygin-settings-form">
        <input type="hidden" name="action" value="keygin_save_settings">
        <?php wp_nonce_field('keygin_save_settings', 'keygin_nonce'); ?>

        <!-- Connection credentials -->
        <h2><?php esc_html_e('Connection credentials', 'keygin-erp-sync'); ?></h2>
        <p><?php esc_html_e('Enter the API Key and Token provided by Contifico ERP.', 'keygin-erp-sync'); ?></p>

        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="keygin_api_key"><?php esc_html_e('API Key', 'keygin-erp-sync'); ?></label>
                    </th>
                    <td>
                        <input
                            type="password"
                            id="keygin_api_key"
                            name="keygin_api_key"
                            class="regular-text"
                            value="<?php echo esc_attr($api_key); ?>"
                            placeholder="<?php esc_attr_e('Enter your API Key', 'keygin-erp-sync'); ?>"
                            required
                        >
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="keygin_api_token"><?php esc_html_e('API Token', 'keygin-erp-sync'); ?></label>
                    </th>
                    <td>
                        <input
                            type="password"
                            id="keygin_api_token"
                            name="keygin_api_token"
                            class="regular-text"
                            value="<?php echo esc_attr($api_token); ?>"
                            placeholder="<?php esc_attr_e('Enter your API Token', 'keygin-erp-sync'); ?>"
                            required
                        >
                        <p>
                            <button type="button" id="keygin-test-connection" class="button-secondary">
                                <?php esc_html_e('Test connection', 'keygin-erp-sync'); ?>
                            </button>
                        </p>
                        <div id="keygin-connection-result" style="margin-top:10px;"></div>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="keygin_frequency"><?php esc_html_e('Synchronization frequency', 'keygin-erp-sync'); ?></label>
                    </th>
                    <td>
                        <select id="keygin_frequency" name="keygin_frequency" class="regular-text" required>
                            <option value="" disabled <?php selected($frequency, ''); ?>>
                                <?php esc_html_e('Select a frequency', 'keygin-erp-sync'); ?>
                            </option>

                            <?php foreach ($frequencies as $key => $label) : ?>
                                <option value="<?php echo esc_attr($key); ?>" <?php selected($frequency, $key); ?>>
                                    <?php echo esc_html($label); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="keygin_warehouse"><?php esc_html_e('Warehouse for stock movements', 'keygin-erp-sync'); ?></label>
                    </th>
                    <td>
                        <select id="keygin_warehouse" name="keygin_warehouse" class="regular-text" required>
                            <option value="" disabled>
                                <?php esc_html_e('Select a warehouse', 'keygin-erp-sync'); ?>
                            </option>

                            <?php foreach ($warehouses as $bodega) : ?>
                                <option value="<?php echo esc_attr($bodega['id']); ?>" <?php selected($warehouse, $bodega['id']); ?>>
                                    <?php echo esc_html($bodega['name']); ?>
                                </option>
                            <?php endforeach; ?>

                            <?php if (!$warehouses && $warehouse) : ?>
                                <option value="<?php echo esc_attr($warehouse); ?>" selected>
                                    <?php echo esc_html($warehouse_name ?: esc_html_e('Selected warehouse', 'keygin-erp-sync')); ?>
                                </option>
                            <?php endif; ?>
                        </select>

                        <input type="hidden" id="keygin_warehouse_name" name="keygin_warehouse_name" value="<?php echo esc_attr($warehouse_name); ?>">
                    </td>
                </tr>
            </tbody>
        </table>

        <h2><?php esc_html_e('Synchronization preferences', 'keygin-erp-sync'); ?></h2>

        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><?php esc_html_e('SKU', 'keygin-erp-sync'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" checked disabled>
                            <?php esc_html_e('Synchronize using the product SKU', 'keygin-erp-sync'); ?>
                        </label>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php esc_html_e('Product name', 'keygin-erp-sync'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="keygin_sync[nombre]" value="1" <?php checked(isset($sync_options['nombre'])); ?>>
                            <?php esc_html_e('Synchronize product title', 'keygin-erp-sync'); ?>
                        </label>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php esc_html_e('Stock', 'keygin-erp-sync'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="keygin_sync[cantidad_stock]" value="1" <?php checked(isset($sync_options['cantidad_stock'])); ?>>
                            <?php esc_html_e('Synchronize stock quantity', 'keygin-erp-sync'); ?>
                        </label>
                    </td>
                </tr>
            </tbody>
        </table>

        <button type="submit" id="keygin-save-button" class="button-primary">
            <?php esc_html_e('Save changes', 'keygin-erp-sync'); ?>
        </button>
    </form>
</div>