<?php
namespace Keskintech\KeskintechMarketplaces;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class KTMP_Templates {
    public function SaveTemplate($FileName, $name, $columnName, $marketplace_id, $MatchedHeaderJSONName, $SelectedSheetName) {
	   	global $wpdb;
		$current_time = current_time('d.m.Y H:i');
        $result = $wpdb->insert(
            "{$wpdb->prefix}ktmp_templates",
            array(
                'template_name' => $name,
                'file_name' => $FileName,
                'columnname' => $columnName,
                'marketplace_id' => $marketplace_id,
                'header_name' => $MatchedHeaderJSONName,
                'sheet_name' => $SelectedSheetName,
				'template_date' => $current_time,
            ),
            array('%s', '%s', '%s', '%d', '%s', '%s')
        );
        return $result ? true : false;
    }
    public function GetAllTemplates() {
		global $wpdb;
        $results = $wpdb->get_results(
            "SELECT * FROM {$wpdb->prefix}ktmp_templates ORDER BY id DESC",
             OBJECT
        );
        return $results;
    }
	public function DeleteMarketplaceTemplates($marketplace_id) {
		global $wpdb;
		$results = $wpdb->get_results($wpdb->prepare(
           "SELECT id FROM {$wpdb->prefix}ktmp_templates WHERE marketplace_id = %d",
           $marketplace_id
        ));
		foreach ($results as $result) {
		   $this->DeleteTemplate($result->id);
        }
	}
	public function DeleteTemplate($templateId) {
		global $wpdb;
        $template = $wpdb->get_row(
          $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}ktmp_templates WHERE id = %d",
            $templateId
          )
        );
        $result = $wpdb->delete(
          "{$wpdb->prefix}ktmp_templates",
          array('id' => $templateId),
          array('%d')
        );
        $savedTemplatesPath = KTMP_UPLOADS_DIR . '/tmp/saved-templates/';
        $templateFileName = $template->file_name;
        $matchedHeaderName = $template->header_name;
        $templateFilePath = $savedTemplatesPath . $templateFileName . '.json';
        $matchedHeaderFilePath = $savedTemplatesPath . $matchedHeaderName . '.json';
        if (file_exists($templateFilePath)) {
          unlink($templateFilePath);
        }
        if (file_exists($matchedHeaderFilePath)) {
          unlink($matchedHeaderFilePath);
        }
        return $result ? true : false;
    }
    public function ListTemplates() {
      $savedTemplatesPath = KTMP_UPLOADS_DIR . '/tmp/saved-templates/';
      $templates = $this->GetAllTemplates();
      echo '<div class="template_history">';
      echo '<p class="template_history_header">' . esc_html__( 'Saved Templates', 'keskintech-marketplaces' ) . '</p>';
      echo '<ul class="template_history_list" id="ktmp-template-list">';
	  if(empty($templates)){
		esc_html_e( 'No saved template found.', 'keskintech-marketplaces' );
	  }
      foreach ($templates as $template) {
        $fileName = $template->file_name;
        $matchedHeaderName = $template->header_name;
        $columnName = $template->columnname;
        $marketplace_id = $template->marketplace_id;
        echo '<li class="template_history_list_item">';
		echo '<a class="deleteTemplateLink" href="#" data-template-id="' . esc_html($template->id) . '">' . esc_html__( 'Delete', 'keskintech-marketplaces' ) . '</a>'; 
        echo '<div class="ktmp_template_list">';
        if (empty($columnName) || empty($marketplace_id) || !file_exists("$savedTemplatesPath/$fileName.json") || !file_exists("$savedTemplatesPath/$matchedHeaderName.json")) {
            echo '<span>'. esc_html($template->template_name) .' - ' . esc_html__( 'Template files are missing.', 'keskintech-marketplaces' ) . '</span>';
        } else {
			$date = $template->template_date;
            echo '<a class="COMPLETED templateLink" href="#" data-FilePath="' . esc_url($savedTemplatesPath) . esc_html($fileName) . '.json" data-columnname="'. esc_html($columnName) .'" data-marketplace_id="'. esc_html($marketplace_id) .'" data-matchedheaderjsonpath="' . esc_url($savedTemplatesPath) . esc_html($matchedHeaderName) . '.json" data-sheetname="'. esc_html($template->sheet_name) .'">';
                echo '<span>'. esc_html($template->template_name) .' - '. esc_html($date) .'</span>';
            echo '</a>';
		}
        echo '</li>';
      }
      echo '</ul>';
      echo '</div>';
    }
	public static function enqueue_template_script() {
      wp_enqueue_script('ktmp_template_script', KTMP_PLUGIN_URL . 'js/ktmp-templates.min.js', array('jquery'), '1.0', true);
    }
	public static function ktmp_template_enqueue_scripts() {
      self::enqueue_template_script();
      wp_localize_script('ktmp_template_script', 'ktmp', array(
        'nonce' => wp_create_nonce('ktmp_deletetemplate_nonce'),
		'ktmp_process_nonce' => wp_create_nonce('ktmp_process_nonce'),
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'confirmDelete' => esc_html__('Are you sure you want to delete this template?', 'keskintech-marketplaces'),
        'errorMessage' => esc_html__('An error occurred while deleting the template.', 'keskintech-marketplaces'),
      ));
    }
	public static function ktmp_save_template_enqueue_scripts($FilePathName, $MatchedHeaderJSONPathName, $marketplace_id, $SKUColumnName, $SelectedSheetName){
	  self::enqueue_template_script();
      wp_localize_script('ktmp_template_script', 'ktmp_saveastemplate', array(
        'nonce' => wp_create_nonce('ktmp_saveastemplate_nonce'),
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'FilePathName' => $FilePathName,
		'MatchedHeaderJSONPathName' => $MatchedHeaderJSONPathName,
		'marketplace_id' => $marketplace_id,
		'SKUColumnName' => $SKUColumnName,
		'SelectedSheetName' => $SelectedSheetName,
      ));	  
	}
}
