<?php
namespace Keskintech\KeskintechMarketplaces;
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! class_exists( 'KTMP_Send_Update_Handler' ) ) {

    class KTMP_Send_Update_Handler {
        private static $instance = null;
		
		public static function get_instance() {
          if (self::$instance == null) {
            self::$instance = new KTMP_Send_Update_Handler();
          }
          return self::$instance;
        }

        public function handle_request() {
            if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] ) ), 'ktmp_process_nonce' ) ) {
				ktmp_log( __( 'Unauthorized request.', 'keskintech-marketplaces' ), '500' );
				exit;
            }
    
            if ( isset( $_POST['ktmp_start_process'] ) && isset( $_POST['process_type'] ) ) {
				$this->handle_start_process();
            } elseif ( isset( $_POST['ktmp_XlsxGetSheet'] ) ) {
                $this->handle_xlsx_get_sheet();
            } elseif ( isset( $_POST['match_columns'] ) ) {
                $this->handle_match_columns();
            } elseif ( isset( $_POST['send_column_upload'] ) ) {
                $this->handle_column_send_upload();
            } elseif ( isset( $_POST['send_products'] ) || isset( $_POST['send-column-update'] ) ) {
                $this->handle_preview();
            } elseif ( isset( $_POST['start_download'] ) ) {
                $this->handle_file_download();
            } else {
                ktmp_log( __( 'Unknown transaction type.', 'keskintech-marketplaces' ), '501' );
                exit;
            } 
        }

        
        private function handle_start_process() {
            if ( isset( $_FILES['file'] ) && $_FILES['file']['error'] === UPLOAD_ERR_OK ) {
				$file_path  = $_FILES['file']['tmp_name'];
                $fileName   = sanitize_file_name( $_FILES['file']['name'] );
                $filetype   = strtolower( pathinfo( $fileName, PATHINFO_EXTENSION ) );
                $allowed_filetypes = array( 'csv', 'xlsx', 'xlsm' );
                if ( in_array( $filetype, $allowed_filetypes ) ) {
                    if ( $filetype === 'csv' ) {
                        $this->process_csv_file( $file_path );
                    } elseif ( in_array( $filetype, array( 'xlsx', 'xlsm' ) ) ) {
                        $this->process_xlsx_file( $file_path);
                    }
                } else {
                    ktmp_log( __( 'File type is not supported.', 'keskintech-marketplaces' ), '510' );
                    exit;
                }
            } else {
				ktmp_log( __( 'File could not be uploaded or read.', 'keskintech-marketplaces' ), '511' );
                exit;
            }
        }

        
        private function process_csv_file( $file_path ) {
            $rows = ktmp_csv_to_array( $file_path );
            $headervaluesjsonpath = ktmp_array_to_header_values_path( $rows );

            if ( sanitize_text_field( $_POST['process_type'] ) === 'update' ) {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Update Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Check The CSV File.', 'keskintech-marketplaces' ) . '</span></h1></div>';
                $uploadedfilejson = ktmp_array_to_json( 'uploaded-file', $rows );
            } else {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Upload Products', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Check Uploaded Data.', 'keskintech-marketplaces' ) . '</span></h1></div>';
            }

            echo '<form action="" method="post">';
			wp_nonce_field('ktmp_process_nonce');
            echo '<div class="ktmp-info-box">' . esc_html__( 'If the data has been read correctly, you can start processing!', 'keskintech-marketplaces' ) . '
                   <input type="hidden" name="headervaluesjsonpath" value="' . esc_attr( $headervaluesjsonpath ) . '">
                   <input type="hidden" name="marketplace_id" value="' . intval( $_POST['marketplace_id'] ) . '">
                   <input type="hidden" name="process_type" value="' . esc_attr( sanitize_text_field( $_POST['process_type'] ) ) . '">
                   ' . ( isset( $uploadedfilejson ) ? '<input type="hidden" name="uploadedfilejson" value="' . esc_attr( $uploadedfilejson ) . '">' : '' ) . '
                   <input type="submit" name="match_columns" class="ktmp-pure-white" value="' . esc_attr__( 'Start Processing', 'keskintech-marketplaces' ) . '">
                </div>
              </form>';
            ktmp_CSVtoTable( $file_path );
        }

        
        private function process_xlsx_file( $file_path ) {
	      $file_name = basename( $file_path );
          $XLSXTmpfilepath = KTMP_UPLOADS_DIR . '/tmp/' . $file_name; 
          if ( copy( $file_path, $XLSXTmpfilepath ) ) {
            ktmp_XlsxGetSheet( $file_name );
          } else {
            ktmp_log( __( 'An error occurred while copying the file.', 'keskintech-marketplaces' ), '512' );
            exit;
          }
        }


        private function handle_xlsx_get_sheet() {
            $rows = ktmp_xlsx_to_array( sanitize_text_field( $_POST['filename'] ), sanitize_text_field( $_POST['selectedSheet'] ) );
            $headervaluesjsonpath = ktmp_array_to_header_values_path( $rows );

            if ( sanitize_text_field( $_POST['process_type'] ) === 'update' ) {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Update Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Check the XLSX page.', 'keskintech-marketplaces' ) . '</span></h1></div>';
                $uploadedfilejson = ktmp_array_to_json( 'uploaded-file', $rows );
            } else {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Upload Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Check the XLSX page.', 'keskintech-marketplaces' ) . '</span></h1></div>';
            }
			$selected_sheet = sanitize_text_field( $_POST['selectedSheet'] );
			$sheet_name_key = 'SheetName' . $selected_sheet;
            echo '<form action="" method="post">';
			wp_nonce_field('ktmp_process_nonce');
            echo '<div class="ktmp-info-box">' . esc_html__( 'If the data has been read correctly, you can start processing!', 'keskintech-marketplaces' ) . '
                <input type="hidden" name="selectedSheet" value="' . esc_attr( $selected_sheet ) . '">
                <input type="hidden" name="SelectedSheetName" value="' . esc_attr( isset( $_POST[$sheet_name_key] ) ? sanitize_text_field( $_POST[ $sheet_name_key ] ) : '' ) . '">
                <input type="hidden" name="filepath" value="' . esc_attr( sanitize_text_field( $_POST['filename'] ) ) . '">
                <input type="hidden" name="headervaluesjsonpath" value="' . esc_attr( $headervaluesjsonpath ) . '">
                <input type="hidden" name="marketplace_id" value="' . esc_attr( intval( $_POST['marketplace_id'] ) ) . '">
                <input type="hidden" name="process_type" value="' . esc_attr( sanitize_text_field( $_POST['process_type'] ) ) . '">
                ' . ( isset( $uploadedfilejson ) ? '<input type="hidden" name="uploadedfilejson" value="' . esc_attr( $uploadedfilejson ) . '">' : '' ) . '
                <input type="submit" name="match_columns" value="' . esc_attr__( 'Start Processing', 'keskintech-marketplaces' ) . '" class="ktmp-pure-white">
            </div>
            </form>';

            echo '<div class="ktmp-warning-box ktmp-orange-alert">' . esc_html__( 'If you have not selected the correct sheet, you can select it again.', 'keskintech-marketplaces' ) . ' &#9660;</div>';

            ktmp_XlsxGetSheet( sanitize_text_field( $_POST['filename'] ), true );
        }

        
        private function handle_match_columns() {
            $process_type = isset( $_POST['process_type'] ) ? sanitize_text_field( $_POST['process_type'] ) : '';
            $uploadedfilejson = ( $process_type === 'upload' ) ? null : ( isset( $_POST['uploadedfilejson'] ) ? sanitize_text_field( $_POST['uploadedfilejson'] ) : null );
            ktmp_column_matching_process( $process_type, sanitize_text_field( $_POST['headervaluesjsonpath'] ), $uploadedfilejson, isset( $_POST['SelectedSheetName'] ) ? sanitize_text_field( $_POST['SelectedSheetName'] ) : null );
        }

        
        private function handle_column_send_upload() {
            echo '<div class="ktmp-title"><h1>' . esc_html__( 'Upload Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'Select the products you will submit.', 'keskintech-marketplaces' ) . '</span></h1></div>';
            $MatchedHeaderJSONPath = ktmp_matched_column_array(sanitize_text_field( $_POST['headervaluesjsonpath'] ));
            echo '<h2 class="ktmp-sub-heading">' . esc_html__( 'Send by Category', 'keskintech-marketplaces' ) . '</h2>';
            $args = array(
                'taxonomy'     => 'product_cat',
                'hide_empty'   => false,
                'hierarchical' => true,
            );
            $categories = get_terms( $args );

            echo '<form action="" method="post" class="ktmp-mini-form">
                  <label for="category">' . esc_html__( 'Select Product Category:', 'keskintech-marketplaces' ) . '</label>';
            wp_nonce_field('ktmp_process_nonce');
            wp_dropdown_categories( array(
                'show_option_all' => __( 'All Categories', 'keskintech-marketplaces' ),
                'taxonomy'        => 'product_cat',
                'name'            => 'selected_category',
                'id'              => 'category',
                'orderby'         => 'name',
                'hierarchical'    => true,
                'selected'        => isset( $_POST['selected_category'] ) ? intval( $_POST['selected_category'] ) : 0,
            ) );

            echo '<label for="product_attributes_select">' . esc_html__( 'Filter by Attributes', 'keskintech-marketplaces' ) . '</label>';
            ktmp_display_product_attributes_selectbox();
            echo '
                <input type="hidden" name="MatchedHeaderJSONPath" value="' . esc_attr( $MatchedHeaderJSONPath ) . '">
                <input type="hidden" name="marketplace_id" value="' . esc_attr( intval( $_POST['marketplace_id'] ) ) . '">
                <input type="hidden" name="send-by-filter" value="kategori">
                <input type="hidden" name="process_type" value="send">
                <input type="submit" name="send_products" class="ktmp-save" value="' . esc_attr__( 'Send', 'keskintech-marketplaces' ) . '">
                <input type="hidden" name="SelectedSheetName" value="' . esc_attr( sanitize_text_field( $_POST['SelectedSheetName'] ) ) . '">
                </form>';

            echo '<h2 class="ktmp-sub-heading">' . esc_html__( 'Or Select from Product List', 'keskintech-marketplaces' ) . '</h2>';
            ktmp_send_products_table( intval( $_POST['marketplace_id'] ), $MatchedHeaderJSONPath, sanitize_text_field( $_POST['SelectedSheetName'] ) );
        }
		
		
        private function handle_preview() {
            $SelectedSheetName = isset( $_POST['SelectedSheetName'] ) ? sanitize_text_field( $_POST['SelectedSheetName'] ) : esc_html__( 'Your Products', 'keskintech-marketplaces' );

            if ( isset( $_POST['send-column-update'] ) ) {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Update Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'You can download your file.', 'keskintech-marketplaces' ) . '</span></h1></div>';
                echo '<input type="hidden" name="indirmeyi_baslat_guncelleme" value="guncelleme">';
				 $send_column_update = sanitize_text_field( $_POST['send-column-update'] );
                 $file_path = $send_column_update === 'template' ? 'saved-templates/' : 'uploaded-file/';
                 $file_path = KTMP_UPLOADS_DIR . '/tmp/' . $file_path . sanitize_text_field( $_POST['filepath'] );
				 
				 $jsonData = file_get_contents( $file_path );
                 $rows = json_decode( $jsonData, true );
				 
				 $matched_column_array = $send_column_update === 'template' ? [ sanitize_text_field( $_POST['matchedheaderjsonpath'] ), sanitize_textarea_field( $_POST['columnname'] ) ] : ktmp_matched_column_array( sanitize_text_field( $_POST['headervaluesjsonpath'] ), true );
                 ktmp_HandleUpdateProducts($rows, $matched_column_array, intval( $_POST['marketplace_id'] ), sanitize_text_field( $_POST['SelectedSheetName'] ), $send_column_update !== 'template');
            } else {
                echo '<div class="ktmp-title"><h1>' . esc_html__( 'Upload Product', 'keskintech-marketplaces' ) . '<span>' . esc_html__( 'You can download your file.', 'keskintech-marketplaces' ) . '</span></h1></div>';

                if ( isset( $_POST['send-by-filter'] ) ) {
                    $selected_category = isset( $_POST['selected_category'] ) ? intval( $_POST['selected_category'] ) : 0;
                    $ktmp_send_by_category = ktmp_send_by_category( intval( $_POST['marketplace_id'] ), $selected_category, sanitize_text_field( $_POST['MatchedHeaderJSONPath'] ), sanitize_text_field( $_POST['product_attributes_select'] ) );

                    if ( ! empty( $ktmp_send_by_category[1] ) ) {
                        $ReadyToWritePath = sanitize_text_field( $ktmp_send_by_category[0] );
                        ktmp_download_file_form( $SelectedSheetName, intval( $_POST['marketplace_id'] ), $ReadyToWritePath );
                        ktmp_array_to_table( $ktmp_send_by_category[1] );
                    } else {
                        echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'No products were found matching your selected criteria.', 'keskintech-marketplaces' ) . '</p></div>';
                    }
                } else {
                    $selectedProducts = array();
                    if ( isset( $_POST['product_id'] ) && is_array( $_POST['product_id'] ) ) {
                        $selectedProducts = array_map( 'intval', $_POST['product_id'] );
                        $ktmp_send_selected_products = ktmp_send_selected_products( intval( $_POST['marketplace_id'] ), $selectedProducts, sanitize_text_field( $_POST['MatchedHeaderJSONPath'] ) );
                        $ReadyToWritePath = sanitize_text_field( $ktmp_send_selected_products[0] );
                        ktmp_download_file_form( $SelectedSheetName, intval( $_POST['marketplace_id'] ), $ReadyToWritePath );
                        ktmp_array_to_table( $ktmp_send_selected_products[1] );
                    } else {
                        echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__( 'Please select product.', 'keskintech-marketplaces' ) . '</p></div>';
                    }
                }
            }
        }


        private function handle_file_download() {
            $filetype = isset( $_POST['filetype'] ) ? sanitize_text_field( $_POST['filetype'] ) : '';
            $marketplace_id = isset( $_POST['marketplace_id'] ) ? intval( $_POST['marketplace_id'] ) : 0;
            $ReadyToWriteName = isset( $_POST['ReadyToWritePath'] ) ? sanitize_text_field( $_POST['ReadyToWritePath'] ) : '';
			$folder_file = sanitize_text_field($_POST['folder']) . $ReadyToWriteName ;
            $SelectedSheetName = isset( $_POST['SelectedSheetName'] ) ? sanitize_text_field( $_POST['SelectedSheetName'] ) : '';
            
            if ( $filetype === 'csv' ) {
                ktmp_export_as_csv( $marketplace_id, $folder_file );
            } else {
                ktmp_export_as_xlsx( $marketplace_id, $folder_file, $SelectedSheetName );
            }
        }
    }
}
?>
