<?php

namespace Keskintech\KeskintechMarketplaces;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class KTMP_Scheduler {
    public function __construct() {
        add_action('init', array($this, 'initialize_scheduler'));
        add_action('ktmp_delete_old_logs_action', array(KTMP_Logs::get_instance(), 'delete_old_logs'));
		add_action('ktmp_delete_tmp_files', array($this, 'delete_tmp_files'));
    }

    public function initialize_scheduler() {
        if (!wp_next_scheduled('ktmp_delete_old_logs_action')) {
            wp_schedule_event(time(), 'weekly', 'ktmp_delete_old_logs_action');
        }
		if (!wp_next_scheduled('ktmp_delete_tmp_files')) {
			wp_schedule_event(time(), 'weekly', 'ktmp_delete_tmp_files');
		}
    }
	
	public function delete_tmp_files(){
        $folders = array('header-values', 'matched-header', 'ready-to-write', 'updated-file', 'uploaded-file');
        $folder_path = KTMP_UPLOADS_DIR . '/tmp/';
        $tmp_files = glob($folder_path . '*.tmp');
        foreach ($tmp_files as $tmp_file) {
            $last_modified_time = filemtime($tmp_file);
            if (time() - $last_modified_time > 7 * 24 * 60 * 60) { 
                unlink($tmp_file);
            }
        }
        foreach ($folders as $folder_name) {
            $child_folder_path = $folder_path . $folder_name . '/';
            if (is_dir($child_folder_path)) {
                $json_files = glob($child_folder_path . '*.json');
                foreach ($json_files as $json_file) {
                    $last_modified_time = filemtime($json_file);
                    if (time() - $last_modified_time > 7 * 24 * 60 * 60) { 
                        unlink($json_file);
                    }
                }
            }
        }
    }
	
	public static function deactivate_scheduler() {
        $timestamp = wp_next_scheduled('ktmp_delete_old_logs_action');
        if ($timestamp) {
            wp_unschedule_event($timestamp, 'ktmp_delete_old_logs_action');
        }
        $timestamp = wp_next_scheduled('ktmp_delete_tmp_files');
        if ($timestamp) {
            wp_unschedule_event($timestamp, 'ktmp_delete_tmp_files');
        }
    }
}