<?php
namespace Keskintech\KeskintechMarketplaces;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class KTMP_Product {
	private static $instance = null;
	public static function get_instance() {
        if (self::$instance == null) {
            self::$instance = new KTMP_Product();
        }
        return self::$instance;
    }
    public function get_all_product_prices (){
		global $wpdb;
		$all = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}ktmp_product_prices");
		return $all;
	}
    public function DeleteProductData($product_id, $parent = true) {
		global $wpdb;
        if ($parent) {
		  $wpdb->delete(
            "{$wpdb->prefix}ktmp_product_prices",
            array('product_id' => $product_id)
          );
	      $product = wc_get_product($product_id);
		  $product_type = $product->get_type();
	      if ($product_type === 'variation') {
		    $variations = $product->get_available_variations();
            foreach ($variations as $variation) {
			  $variation_id = $variation['variation_id'];
			  $wpdb->delete(
                "{$wpdb->prefix}ktmp_product_prices",
                array('product_id' => $variation_id)
              );
			}
          }
        } else {		
          $wpdb->delete(
            "{$wpdb->prefix}ktmp_product_prices",
            array('product_id' => $product_id)
          );
        }
    }
    public function IsThereaPrice($marketplace_id, $product_id) {
        global $wpdb;
		$existing_data = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}ktmp_product_prices WHERE marketplace_id = %d AND product_id = %d",
                $marketplace_id,
                $product_id
            )
        );
        return !empty($existing_data);
    }

    public function Product_Price_Transactions($operation_type, $product_id, $marketplace_id, $marketplace_value) {
		global $wpdb;
        if ($operation_type == 'add') {
            $result = $wpdb->insert(
                "{$wpdb->prefix}ktmp_product_prices",
                array(
                    'product_id' => $product_id,
                    'marketplace_id' => $marketplace_id,
                    'price' => $marketplace_value
                ),
                array('%d', '%d', '%f')
            );
        } elseif ($operation_type == 'update') {
			$MarketplaceProduct = new KTMP_MarketplaceProduct();
			$old_price = $MarketplaceProduct->ProductMarketplacePrice($marketplace_id, $product_id);
			if($old_price[0] != $marketplace_value){
				$result = $wpdb->update(
                "{$wpdb->prefix}ktmp_product_prices",
                array('price' => $marketplace_value),
                array('product_id' => $product_id, 'marketplace_id' => $marketplace_id),
                array('%f'),
                array('%d', '%d')
                );
		    }
			else{
				$result = true;
			}
		} elseif ($operation_type == 'delete') {
            $result = $wpdb->delete(
                "{$wpdb->prefix}ktmp_product_prices",
                array('product_id' => $product_id, 'marketplace_id' => $marketplace_id),
                array('%d', '%d')
            );
        }		
		return $result;
    }
	public function GetProductConstant($product_id) {
		global $wpdb;
        $result = $wpdb->get_var($wpdb->prepare("SELECT price FROM {$wpdb->prefix}ktmp_product_prices WHERE product_id = %d AND marketplace_id=1", $product_id));
        return $result;
    }
}