<?php
namespace Keskintech\KeskintechMarketplaces;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class KTMP_MarketplaceProduct {
	public function __construct() {
        $this->keskintechProduct = KTMP_Product::get_instance();
        $this->KeskintechMarketplace = KTMP_Marketplace::get_instance();
    }
    private function PricingSwitchCase($base, $operation_type, $value) {
        switch ($operation_type) {
            case 'addition':
                return $base + $value;
            case 'subtraction':
                return $base - $value;
            case 'multiplication':
                return $base * $value;
            case 'division':
                return ($value != 0) ? $base / $value : false;
            default:
                return false;
        }
    }
	public function ProductBaseValue($product_id,$marketplace_id){
	    $base = $this->KeskintechMarketplace->BaseFrom($marketplace_id);
        if ($base == 0) {
            $base_value = get_post_meta($product_id, '_price', true);
			return $base_value;
        } elseif ($base == 1) {
            $base_value = $this->keskintechProduct->GetProductConstant($product_id);
            if ($base_value == null) {
                return false;
            }
			return $base_value;
        } else {
            return false;
        }
    }
	public function PriceRuleTransactionResult($product_id, $marketplace_id, $base_value, $pricing_rules=false) {
        $base_value = floatval($base_value);
		if(!$pricing_rules){
			$pricing_rules = $this->KeskintechMarketplace->GetPricingRules($marketplace_id);
		}
        if ($pricing_rules != null) {
		    foreach ($pricing_rules as $rule) {
               $base_value = $this->PricingSwitchCase($base_value, $rule['operation_type'], $rule['value']);
               if ($base_value == false) {
                   return false;
               }
            }
			if ($base_value <= 0) {
				return false;
			}
			$base_value = $this->ResultAfterRounding($marketplace_id, $base_value);
			return $base_value;
		}
		else { return false;}
    }
	private function ResultAfterRounding($marketplace_id, $result){
        $GetRoundingRule = $this->KeskintechMarketplace->GetRoundingRule($marketplace_id);
        if (!$GetRoundingRule) {
          return $result;
        }
        $rounding_type = $GetRoundingRule['round-type'];
        $rounding_value = $GetRoundingRule['round-value'];
        $result = floatval($result);
        switch ($rounding_type) {
           case 'decimal':
             $result = floor($result) + $rounding_value / 100;
             break;
           case 'ones':
             $result = floor($result / 10) * 10 + $rounding_value;
             break;
           case 'tens':
             $result = floor($result / 100) * 100 + $rounding_value;
             break;
           case 'hundreds':
             $result = floor($result / 1000) * 1000 + $rounding_value;
             break;
           default:
             break;
        }
        return $result;
    }
    public function ProductPrimaryPrice($marketplace_id, $product_id){
		global $wpdb;
		$price = $wpdb->get_var($wpdb->prepare("SELECT price FROM {$wpdb->prefix}ktmp_product_prices WHERE product_id = %d AND marketplace_id = %d", $product_id, $marketplace_id));
		return $price;
	}
    public function ProductMarketplacePrice($marketplace_id, $product_id, $marketplace_price_rules = NULL) {
       $price = $this->ProductPrimaryPrice($marketplace_id, $product_id);
       if($marketplace_id == 1 || $price !== null) {
           return [$price, 'pricing-primary'];
       } 
	   else{
		   $ProductBaseValue = $this->ProductBaseValue($product_id, $marketplace_id);
		   if($ProductBaseValue){
			   $PriceRuleTransactionResult = $this->PriceRuleTransactionResult($product_id, $marketplace_id, $ProductBaseValue);
			   if($PriceRuleTransactionResult !== false) {
				   return [$PriceRuleTransactionResult, 'pricing-rule',];
			   }
		   }
		   return [get_post_meta($product_id, '_price', true), 'pricing-current-site'];
       }
    }
}