<?php
namespace Keskintech\KeskintechMarketplaces;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class KTMP_Marketplace {
	private static $instance = null;
	public static function get_instance() {
        if (self::$instance == null) {
            self::$instance = new KTMP_Marketplace();
        }
        return self::$instance;
    }
	/* Marketplace */
	public function MarketplaceAdd($market_name) {
		global $wpdb;
		$market_name = stripslashes($market_name);
	    $result = $wpdb->insert(
              $wpdb->prefix . 'ktmp_marketplaces',
                array(
                  'market_name' => $market_name,
                ),
               array('%s')
       );
	   return $result ? true : false;
    }
    public function getMarketplaceName($marketplace_id) {
        global $wpdb;
		$name = $wpdb->get_var($wpdb->prepare("SELECT market_name FROM {$wpdb->prefix}ktmp_marketplaces WHERE marketplace_id = %d", $marketplace_id));
        return $name;
    }
    private function getMarketplacesIds() {
		global $wpdb;
        $results = $wpdb->get_results("SELECT marketplace_id FROM {$wpdb->prefix}ktmp_marketplaces", ARRAY_N);
        return wp_list_pluck($results, 0);
    }
	public function getAllMarketplaces($all = false) {
		global $wpdb;
        if ($all) {
           $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}ktmp_marketplaces ORDER BY marketplace_id ASC", OBJECT);
        } else {
           $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}ktmp_marketplaces WHERE marketplace_id != 1 ORDER BY marketplace_id ASC", OBJECT);
        }
        return $results;
    }
    public function getSelectedMarketplace($marketplace_id){
		global $wpdb;
		return $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}ktmp_marketplaces WHERE marketplace_id=%d", $marketplace_id), ARRAY_A);
    }
	public function MarketplaceEdit($market_name, $marketplace_id) {
		global $wpdb;
		$market_name = stripslashes($market_name);
        $result = $wpdb->update(
                  "{$wpdb->prefix}ktmp_marketplaces",
                  array('market_name' => $market_name),
                  array('marketplace_id' => $marketplace_id),
                  array('%s'),
                 array('%d')
        );
		return $result ? true : false;
    }
    public function MarketplaceDelete($marketplace_id) {
		global $wpdb;
        $result = $wpdb->delete(
            "{$wpdb->prefix}ktmp_marketplaces",
            array('marketplace_id' => $marketplace_id),
            array('%d')
        );
		$this->when_marketplace_deleted($marketplace_id);
		return $result;
    }
	private function when_marketplace_deleted($marketplace_id){
		global $wpdb;
		$wpdb->delete(
            "{$wpdb->prefix}ktmp_product_prices",
            array('marketplace_id' => $marketplace_id),
            array('%d')
        );
		$this->DeleteMarketplacePricingRules($marketplace_id);
		$this->DeleteRoundingRule($marketplace_id);
		$KeskintechTemplates = new KTMP_Templates();
		$KeskintechTemplates->DeleteMarketplaceTemplates($marketplace_id);
		$this->DeleteMarketplaceMatches($marketplace_id);
	}
    
	/* Pricing Rules */
	public function AddMarketplacePricingRule($marketplace_id, $i, $operation_type, $value) {
		global $wpdb;
        $wpdb->insert(
            "{$wpdb->prefix}ktmp_price_rules",
            array(
                'marketplace_id' => $marketplace_id,
                'sorting_order' => $i,
                'operation_type' => $operation_type,
                'value' => $value,
            ),
            array('%d', '%d', '%s', '%f')
        );
    }
    public function GetPricingRules($marketplace_id) {
		global $wpdb;
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}ktmp_price_rules WHERE marketplace_id = %d ORDER BY sorting_order ASC",
                $marketplace_id
            ),
            ARRAY_A
        );
        return $results;
    }
	public function DeleteMarketplacePricingRules($marketplace_id) {
		global $wpdb;
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}ktmp_price_rules WHERE marketplace_id = %d", $marketplace_id ) );
		$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}ktmp_marketplace_meta WHERE marketplace_id = %d AND meta_key = 'base'", $marketplace_id ) );
    }
	/* Rounding Form Handler */
    public function RoundingRule($marketplace_id, $round_type, $round_value) {
		global $wpdb;
		$round_value = str_replace(',', '.', $round_value);
        if ($round_value === '' || !is_numeric($round_value)) {
            return false;
        }
	    $rounded = $this->ktmp_round_the_price($round_value, $round_type);
        if(!$rounded && !is_numeric($round_value)){
			return false;
		}
        $this->DeleteRoundingRule($marketplace_id);
        $wpdb->insert(
               "{$wpdb->prefix}ktmp_marketplace_meta",
                array(
                   'marketplace_id' => $marketplace_id,
                   'meta_key'  => 'round-type',
                   'meta_value'=> $round_type,
                ),
                array('%d', '%s', '%s')
        );
        $wpdb->insert(
         "{$wpdb->prefix}ktmp_marketplace_meta",
          array(
            'marketplace_id' => $marketplace_id,
            'meta_key'  => 'round-value',
            'meta_value'=> $rounded,
          ),
          array('%d', '%s', '%s')
        );
        return true;
    }
    public function DeleteRoundingRule($marketplace_id) {
		global $wpdb;
        $existing_tip = $wpdb->get_row(
          $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}ktmp_marketplace_meta WHERE marketplace_id = %d AND meta_key = 'round-type'",
            $marketplace_id
          )
        );
        if ($existing_tip) {
          $wpdb->delete(
            "{$wpdb->prefix}ktmp_marketplace_meta",
             array(
                'marketplace_id' => $marketplace_id,
                'meta_key' => 'round-type',
             ),
             array('%d', '%s')
          );
		  $wpdb->delete(
            "{$wpdb->prefix}ktmp_marketplace_meta",
             array(
                'marketplace_id' => $marketplace_id,
                'meta_key' => 'round-value',
             ),
             array('%d', '%s')
          );
        }
        return true;
    }
    public function GetRoundingRule($marketplace_id) {
		global $wpdb;
        $round_type = $wpdb->get_var(
          $wpdb->prepare(
            "SELECT meta_value FROM {$wpdb->prefix}ktmp_marketplace_meta WHERE marketplace_id = %d AND meta_key = %s",
            $marketplace_id,
            'round-type'
            )
        );
        $round_value = $wpdb->get_var(
          $wpdb->prepare(
            "SELECT meta_value FROM {$wpdb->prefix}ktmp_marketplace_meta WHERE marketplace_id = %d AND meta_key = %s",
            $marketplace_id,
            'round-value'
          )
        );
        if ($round_type !== null && $round_value !== null) {
          return array('round-type' => $round_type, 'round-value' => $round_value);
        }
        return false;
    }
    private function ktmp_round_the_price($number, $round_type) {
        if (strpos($number, '.') !== false) {
           list($integer_value, $decimal_value) = explode('.', $number);
           $decimal_digits = strlen($decimal_value);
        } else {
           $integer_value = $number;
           $decimal_value = '';
           $decimal_digits = 0;
        }
        $integer_digits = strlen($integer_value);
        if ($round_type == 'decimal') {
           if ($number < 1 && $number != 0) {
             return false;
           }
           if ($integer_digits == 1) {
             $number = $number * 10;
           }
           $rounded_deger = substr($number, 0, 2);
           return $rounded_deger;
        } 
		elseif ($round_type == 'ones') {
           if (strlen($integer_value) > 1) {
             return false;
           }
           $rounded_deger = number_format((float)$number, 2, '.', '');
           return $rounded_deger;
       } elseif ($round_type == 'tens') {
           if (strlen($integer_value) > 2 || $number < 1) {
             return false;
           }
           if ($integer_digits == 1) {
             $number = $number * 10;
           }
           $rounded_deger = number_format((float)$number, 2, '.', '');
           return $rounded_deger;
       } elseif ($round_type == 'hundreds') {
           if (strlen($integer_value) > 3 || $number < 1) {
             return false;
           }
           if ($integer_digits == 1) {
             $number = $number * 10 * 10;
           }
           if ($integer_digits == 2) {
             $number = $number * 10;
           }
           $rounded_deger = number_format((float)$number, 2, '.', '');
           return $rounded_deger;
       } else {
           return false;
       }
    }
    public function BaseFrom($marketplace_id) {
		global $wpdb;
        $result = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM {$wpdb->prefix}ktmp_marketplace_meta WHERE meta_key = 'base' AND marketplace_id =%d", $marketplace_id));
        return $result !== null ? $result : '';
    }
    public function AddBaseFrom($marketplace_id, $base_from) {
		global $wpdb;
        $wpdb->insert(
           "{$wpdb->prefix}ktmp_marketplace_meta",
            array(
                'marketplace_id' => $marketplace_id,
                'meta_key' => 'base',
                'meta_value' => $base_from,
            ),
            array('%d', '%s', '%s')
        );
    }
    
    /* Pricing */
	public function marketplace_common_price($product_ids){
		global $wpdb;
        $marketplaces_ids = $this->getMarketplacesIds();
        $marketplace_common_price = [];
        foreach ($marketplaces_ids as $marketplaces_id){
           $marketplace_common_price[$marketplaces_id] = '';
           foreach($product_ids as $index => $product_id){
              $result = $wpdb->get_var($wpdb->prepare("SELECT price FROM {$wpdb->prefix}ktmp_product_prices WHERE product_id = %d AND marketplace_id = %d", $product_id, $marketplaces_id));
              if($index == 0){
                 if($result == null){
                    break;    
                 }
                 else{
                    $marketplace_common_price[$marketplaces_id] = $result;
                 }
              }
              else{
                 if($result === null || $result !== $marketplace_common_price[$marketplaces_id]){
                    $marketplace_common_price[$marketplaces_id] = '';
                    break;
                 }
              }
           }
        }
        return $marketplace_common_price;
    }
	/* Matching */
	public function MatchedOrDefaultTermName($term_id, $marketplace_id, $type) {
		global $wpdb;
        $result = $wpdb->get_var($wpdb->prepare("SELECT key_2 FROM {$wpdb->prefix}ktmp_matching WHERE marketplace_id = %d AND meta_key = %s AND key_1 = %s", $marketplace_id, $type, $term_id));
        if ($result) {
           return $result;
        } else {
			if($term_id === 0){
				return;
			}
            $term_name = get_term($term_id)->name;
            return $term_name;
        }
    }
	public function GetMatchedTerms($id, $type){
		global $wpdb;
	    $defaultValues= [];
        $results = $wpdb->get_results(
          $wpdb->prepare("SELECT key_1, marketplace_id, key_2 FROM {$wpdb->prefix}ktmp_matching WHERE key_1 = %s AND meta_key = %s", $id,$type),
          ARRAY_A
        );
	    return array_column($results, 'key_2', 'marketplace_id');
    }
	public function MatchTerm($TermId, $key_2, $marketplace_id, $type) {
		global $wpdb;
        $existingRow = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}ktmp_matching WHERE key_1 = %s AND marketplace_id = %d AND meta_key =%s", $TermId, $marketplace_id, $type));
        $key_2 = stripslashes($key_2);
	    if ($existingRow) {
          $updated = $wpdb->update(
           "{$wpdb->prefix}ktmp_matching",
            array('key_2' => $key_2),
            array('key_1' => $TermId, 'meta_key' => $type, 'marketplace_id' => $marketplace_id),
            array('%s'),
            array('%s', '%s', '%d')
          );
          if ($updated !== false) {
            return true;
          } else {
            return false;
          }
        } 
	    else {
          $inserted = $wpdb->insert(
            "{$wpdb->prefix}ktmp_matching",
            array(
                  'key_1' => $TermId,
                  'marketplace_id' => $marketplace_id,
                  'meta_key' => $type,
                  'key_2' => $key_2,
            ),
            array(
                  '%s',
                  '%d',
                  '%s',
                  '%s',
            )
          );
          if ($inserted !== false) {
            return true;
          } else {
            return false;
          }
        }
    }
	public function DeleteMatchedTerm($key_1, $marketplace_id, $type, $all=false) {
		global $wpdb;
		if (!$all) {
           $deleted = $wpdb->delete(
            "{$wpdb->prefix}ktmp_matching",
             array(
               'key_1' => $key_1, 
               'marketplace_id' => $marketplace_id,
               'meta_key' => $type
             ),
             array('%s', '%d', '%s')
           );
           return $deleted;
        }
		else {
           $deleted = $wpdb->delete(
            "{$wpdb->prefix}ktmp_matching",
             array(
                'key_1' => $key_1,
                'meta_key' => $type
             ),
             array('%s', '%s')
           );
           return $deleted;
       }
    }
	public function DeleteMarketplaceMatches($marketplace_id){
		global $wpdb;
		$wpdb->delete(
            "{$wpdb->prefix}ktmp_matching",
            array('marketplace_id' => $marketplace_id),
            array('%d')
       );
	}
	public function WhenBrandTermUpdated(){
		global $wpdb;
        $wpdb->query(
            $wpdb->prepare(
              "DELETE FROM {$wpdb->prefix}ktmp_matching WHERE meta_key = %s AND key_1 != %d",
              'brand', 0
            )
        );
    }
    private function GetMarketplacesMatchCount($marketplace_id, $slug){
		global $wpdb;
		if($slug == 'term'){
		   $query = $wpdb->prepare(
             "SELECT COUNT(*) FROM {$wpdb->prefix}ktmp_matching WHERE marketplace_id = %d AND (meta_key = 'term' OR meta_key = 'att_taxonomy')",
             $marketplace_id
           );
		}
		elseif($slug == 'brand'){
			$brand_from = get_option('ktmp_brand_from');
			if($brand_from =='term'){
				$query = $wpdb->prepare(
                   "SELECT COUNT(*) FROM {$wpdb->prefix}ktmp_matching WHERE marketplace_id = %d AND meta_key ='brand' AND key_1 !=0",
                  $marketplace_id
                );
			}
			else{
				$query = $wpdb->prepare(
                   "SELECT COUNT(*) FROM {$wpdb->prefix}ktmp_matching WHERE marketplace_id = %d AND meta_key ='brand' AND key_1 =0",
                  $marketplace_id
                );
			}
		}
		else{
		   $query = $wpdb->prepare(
             "SELECT COUNT(*) FROM {$wpdb->prefix}ktmp_matching WHERE marketplace_id = %d AND meta_key = %s ",
             $marketplace_id, $slug
           );
		}
		$match_count = $wpdb->get_var($query);
        return $match_count;
	}
	private function AttributeTermCount($taxonomy_count){
		global $wpdb;
		$attribute_terms_count = $wpdb->get_var( "
           SELECT COUNT(*) 
           FROM {$wpdb->term_taxonomy} 
           WHERE taxonomy LIKE 'pa_%'
        " );
		if(!$taxonomy_count){
		  $attribute_taxonomies = wc_get_attribute_taxonomies();
          $taxonomy_count = count($attribute_taxonomies);
		}
		return $taxonomy_count + $attribute_terms_count;
	}
	public function MarketplacesGetPercent($marketplace_id, $slug, $count, $taxonomy_count = false){
		if($slug == 'term'){
			$count = $this->AttributeTermCount($taxonomy_count);
		}
		$match_count = $this->GetMarketplacesMatchCount($marketplace_id, $slug);
		if ($count > 0) {
          $percent = round(($match_count / $count) * 100, 1);
        } else {
			return false;
        }
		return $percent;
	}
}
