<?php

namespace Keskintech\KeskintechMarketplaces;

if ( ! defined( 'ABSPATH' ) ) exit;
class KTMP_Logs {
    private static $instance = null;
	public static function get_instance() {
        if (self::$instance == null) {
            self::$instance = new KTMP_Logs();
        }
        return self::$instance;
    }
    public function add_error($error_message, $error_code = null) {
		global $wpdb;
        $wpdb->insert(
            "{$wpdb->prefix}ktmp_logs",
            array(
                'error_message' => sanitize_text_field($error_message),
                'error_code'    => sanitize_text_field($error_code),
                'error_time'    => current_time('mysql'),
            ),
            array('%s', '%s', '%s')
        );
    }
    public function delete_error($error_id) {
		global $wpdb;
        $wpdb->delete(
            "{$wpdb->prefix}ktmp_logs",
            array('id' => intval($error_id)),
            array('%d')
        );
    }

    public function get_errors($limit = 100) {
		global $wpdb;
        return $wpdb->get_results(
		    $wpdb->prepare(
              "SELECT * FROM {$wpdb->prefix}ktmp_logs ORDER BY id DESC LIMIT %d", $limit
            )
		);
    }
	 public function delete_old_logs() {
        global $wpdb;
        $wpdb->query(
            "DELETE FROM {$wpdb->prefix}ktmp_logs WHERE error_time < NOW() - INTERVAL 30 DAY"
        );
    }
}