<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function ktmp_latest_product_all_terms() {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
		'post_status' => 'publish'
    );
    $latest_product = new WP_Query($args);
    if ($latest_product->have_posts()) {
        while ($latest_product->have_posts()) {
            $latest_product->the_post();
            global $product;
            $product_id = $product->get_id();
            $taxonomies = get_object_taxonomies('product');
            echo '<div class="ktmp-edit-column ktmp-setting-table"><table>';
            echo '<tr><th>' . esc_html__('Taxonomy', 'keskintech-marketplaces') . '</th><th>' . esc_html__('Term Name', 'keskintech-marketplaces') . '</th></tr>';
            foreach ($taxonomies as $taxonomy) {
                $terms = get_the_terms($product_id, $taxonomy);
                if ($terms && !is_wp_error($terms)) {
                    foreach ($terms as $term) {
                        echo '<tr>';
                        echo '<td>' . esc_html($taxonomy) . '</td>';
                        echo '<td class="ktmp-truncate">' . esc_html($term->name) . '</td>';
                        echo '</tr>';
                    }
                }
            }
            echo '</table></div>';
            wp_reset_postdata();
        }
    } else {
        echo esc_html__('No products found', 'keskintech-marketplaces');
    }
} ?>
<div class="wrap">
    <h1><?php esc_html_e('General Settings', 'keskintech-marketplaces'); ?></h1>
    <form method="post" action="options.php" id="ktmp-settings">
        <?php settings_fields('ktmp_options_group'); ?>
        <?php do_settings_sections('ktmp_options_group'); ?>
        <table class="form-table">
            <tr valign="top">
                <th scope="row"><?php esc_html_e('Brand Option', 'keskintech-marketplaces'); ?></th>
                <td>
                    <label>
                      <input type="radio" name="ktmp_brand_options" value="active" <?php checked('active', get_option('ktmp_brand_options')); ?>>
                      <?php esc_html_e('Active', 'keskintech-marketplaces'); ?>
                    </label>
                    <label>
                      <input type="radio" name="ktmp_brand_options" value="passive" <?php checked('passive', get_option('ktmp_brand_options')); ?>>
                      <?php esc_html_e('Passive', 'keskintech-marketplaces'); ?>
                    </label>
				</td>
            </tr>
			<tr valign="top" class="ktmp_brand_from_input" style="display:none;">
                <th scope="row"><?php esc_html_e('Brand From', 'keskintech-marketplaces'); ?></th>
                <td>
                    <label><input type="radio" name="ktmp_brand_from" value="term" <?php checked('term', get_option('ktmp_brand_from')); ?>><?php esc_html_e('Term', 'keskintech-marketplaces'); ?></label>
                    <label><input type="radio" name="ktmp_brand_from" value="fixed-brand" <?php checked('fixed-brand', get_option('ktmp_brand_from')); ?>><?php esc_html_e('Fixed Brand', 'keskintech-marketplaces'); ?></label>
				</td>
			</tr>
			<tr valign="top" class="urun_term_bilgisi_input" style="display:none;">
                <th scope="row"><?php esc_html_e('Brand Taxonomy', 'keskintech-marketplaces'); ?></th>
                <td>
                    <input type="text" name="ktmp_brand_term" id="urun_term_bilgisi_input" style="margin-bottom:20px" value="<?php echo esc_attr(get_option('ktmp_brand_term')); ?>" placeholder="<?php esc_html_e('Taxonomy here', 'keskintech-marketplaces'); ?>">
                    <h2><?php esc_html_e('Term information of latest published product', 'keskintech-marketplaces'); ?></h2>
                    <?php 
                        ktmp_latest_product_all_terms();
					?>
				</td>
			</tr>
			<tr valign="top" class="ktmp_fixed_brand" style="display:none;">
                <th scope="row"><?php esc_html_e('Your Brand', 'keskintech-marketplaces'); ?></th>
                <td>
                    <input type="text" name="ktmp_fixed_brand" id="ktmp_fixed_brand" style="margin-bottom:20px" value="<?php echo esc_attr(get_option('ktmp_fixed_brand')); ?>" placeholder="<?php esc_html_e('Your brand', 'keskintech-marketplaces'); ?>">
				</td>
			</tr>
			<tr valign="top">
                <th scope="row"><?php esc_html_e('Default "In stock" value', 'keskintech-marketplaces'); ?></th>
                <td>
                   <input type="number" name="ktmp_in_stock_value" id="ktmp_in_stock_value" style="margin-bottom:20px" min="0" value="<?php echo esc_attr(get_option('ktmp_in_stock_value')); ?>">
                </td>
            </tr>
     </table>
        <?php submit_button(); ?>
    </form>
</div>

