<?php
if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_check_marketplace_products() {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
		'post_status'            => 'publish' 
    );
    $products = get_posts($args);
    echo '<table class="widefat fixed"><thead><tr><th>' . esc_html__('Product Name', 'keskintech-marketplaces') . '</th><th>' . esc_html__('Error/Warning', 'keskintech-marketplaces') . '</th><th>' . esc_html__('Details', 'keskintech-marketplaces') . '</th></tr></thead><tbody>';
    $in_stock_value = get_option('ktmp_in_stock_value');
    foreach ($products as $product) {
        $product_id = $product->ID;
        $product_type = wc_get_product($product_id)->get_type(); 
        $product_title = get_the_title($product_id);
        if ($product_type == 'simple') {
            $price = get_post_meta($product_id, '_price', true);
            if (empty($price)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Price missing.', 'keskintech-marketplaces') . '</td></tr>';
            }
			$brand = ktmp_product_brand($product_id);
			if(!$brand || $brand ==''){
				echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Product brand is missing.', 'keskintech-marketplaces') . '</td></tr>';
			}
            if (!has_post_thumbnail($product_id)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Featured image missing.', 'keskintech-marketplaces') . '</td></tr>';
            }
            $gallery_images = get_post_meta($product_id, '_product_image_gallery', true);
            $gallery_image_count = count(explode(',', $gallery_images));
            if ($gallery_image_count < 2) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Warning', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Not enough images in the product gallery.', 'keskintech-marketplaces') . '</td></tr>';
            }
			if (empty($in_stock_value)) {
				$manage_stock = get_post_meta($product_id, '_manage_stock', true);
                if ($manage_stock !== 'yes') {
                   echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Stock management is not enabled.', 'keskintech-marketplaces') . '</td></tr>';
                }
			}
            $description = get_post($product_id)->post_content;
            if (empty($description)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Warning', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Product description is missing.', 'keskintech-marketplaces') . '</td></tr>';
            }
            $sku = get_post_meta($product_id, '_sku', true);
            if (empty($sku)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('SKU is missing.', 'keskintech-marketplaces') . '</td></tr>';
            }
        } elseif ($product_type == 'variable') {
            $variations = get_children(array(
                'post_parent' => $product_id,
                'post_type' => 'product_variation',
                'posts_per_page' => -1,
            ));
			if (empty($variations)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('This variable product has no variations.', 'keskintech-marketplaces') . '</td></tr>';
            }
			$brand = ktmp_product_brand($product_id);
			if(!$brand || $brand ==''){
				echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Product brand is missing.', 'keskintech-marketplaces') . '</td></tr>';
			}
            $description = get_post($product_id)->post_content;
            if (empty($description)) {
                echo '<tr><td>' . esc_html($product_title) . '</td><td>' . esc_html__('Warning', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Product description is missing.', 'keskintech-marketplaces') . '</td></tr>';
            }
            foreach ($variations as $variation) {
                $variation_id = $variation->ID;
                $variation_price = get_post_meta($variation_id, '_price', true);
                if (empty($variation_price)) {
                    echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Variation price is missing.', 'keskintech-marketplaces') . '</td></tr>';
                }
                $marketplace_image_fields = array(
                    'ktmp_marketplace_image_field_1',
                    'ktmp_marketplace_image_field_2',
                    'ktmp_marketplace_image_field_3',
                    'ktmp_marketplace_image_field_4',
                    'ktmp_marketplace_image_field_5'
                );
                $missing_images = 0;
                foreach ($marketplace_image_fields as $field) {
                    if (empty(get_post_meta($variation_id, $field, true))) {
                        $missing_images++;
                    }
                }
                if ($missing_images > 3) {
                    echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Warning', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Not enough images for the variation.', 'keskintech-marketplaces') . '</td></tr>';
                }
				$thumbnail_id = get_post_thumbnail_id($variation_id);
				if (!$thumbnail_id) {
                    echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Variation does not have a featured image.', 'keskintech-marketplaces') . '</td></tr>';
                }
				if (empty($in_stock_value)) {
                   $variation_manage_stock = get_post_meta($variation_id, '_manage_stock', true);
                   if ($variation_manage_stock !== 'yes') {
                      echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Variation stock management is not enabled.', 'keskintech-marketplaces') . '</td></tr>';
                   }
                }
                $variation_sku = get_post_meta($variation_id, '_sku', true);
                if (empty($variation_sku)) {
                    echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Variation SKU is missing.', 'keskintech-marketplaces') . '</td></tr>';
                }
                $group_code = get_post_meta($variation_id, 'ktmp_variation_group_code', true);
                $attributes = get_post_meta($product_id, '_product_attributes', true);
                $variation_attribute_count = 0;
                $need_group_code = false;
                foreach ($attributes as $attribute) {
                   if (isset($attribute['is_variation']) && $attribute['is_variation'] == 1) {
                      $variation_attribute_count++;
		              if($variation_attribute_count == 2){
			             $need_group_code = true;
			             break;
		              }
                   }
                }
                if ($need_group_code==true && empty($group_code) ) {
                    echo '<tr><td>' . esc_html($variation->post_title) . '</td><td>' . esc_html__('Error', 'keskintech-marketplaces') . '</td><td>' . esc_html__('Variation Group Code is missing.', 'keskintech-marketplaces') . '</td></tr>';
                }
            }
        }
    }
    echo '</tbody></table>';
}
?>
<div class="wrap">
<h1><?php esc_html_e('Product Control', 'keskintech-marketplaces'); ?></h1>
<?php  ktmp_check_marketplace_products(); ?>
</div>