<?php

use Keskintech\KeskintechMarketplaces\KTMP_Logs;

if ( ! defined( 'ABSPATH' ) ) exit;
function ktmp_logs_table() {
    $logs_class = new KTMP_Logs();
    $errors = $logs_class->get_errors(50); ?>
    <div class="wrap">
        <h1><?php esc_html_e('Error Logs', 'keskintech-marketplaces') ?></h1>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th><?php esc_html_e('Error Message', 'keskintech-marketplaces') ?></th>
                    <th><?php esc_html_e('Error Code', 'keskintech-marketplaces') ?></th>
                    <th><?php esc_html_e('Created At', 'keskintech-marketplaces') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if ($errors): ?>
                    <?php foreach ($errors as $error): ?>
                        <tr>
                            <td><?php echo esc_html($error->id); ?></td>
                            <td><?php echo esc_html($error->error_message); ?></td>
                            <td><?php echo esc_html($error->error_code); ?></td>
                            <td><?php echo esc_html($error->error_time); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4"><?php esc_html_e('No errors found.', 'keskintech-marketplaces') ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php
}
ktmp_logs_table();
